/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.federation.optimizer.converter.segment.projection.impl;

import java.util.Collections;
import java.util.Optional;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.infra.federation.optimizer.converter.segment.SQLSegmentConverter;
import org.apache.shardingsphere.infra.federation.optimizer.converter.segment.expression.ExpressionConverter;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.FunctionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.AliasSegment;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class ExpressionProjectionConverter
implements SQLSegmentConverter<ExpressionProjectionSegment, SqlNode> {
    @Override
    public Optional<SqlNode> convertToSQLNode(ExpressionProjectionSegment segment) {
        if (null == segment) {
            return Optional.empty();
        }
        Optional<SqlNode> result = new ExpressionConverter().convertToSQLNode(segment.getExpr());
        if (result.isPresent() && segment.getAlias().isPresent()) {
            return Optional.of(new SqlBasicCall((SqlOperator)SqlStdOperatorTable.AS, new SqlNode[]{result.get(), SqlIdentifier.star(Collections.singletonList((String)segment.getAlias().get()), (SqlParserPos)SqlParserPos.ZERO, Collections.singletonList(SqlParserPos.ZERO))}, SqlParserPos.ZERO));
        }
        return result;
    }

    @Override
    public Optional<ExpressionProjectionSegment> convertToSQLSegment(SqlNode sqlNode) {
        if (sqlNode instanceof SqlBasicCall) {
            SqlBasicCall sqlBasicCall = (SqlBasicCall)sqlNode;
            if (SqlKind.AS == sqlBasicCall.getOperator().getKind() && sqlBasicCall.getOperandList().get(0) instanceof SqlNumericLiteral) {
                SqlNode exprSqlNode = (SqlNode)sqlBasicCall.getOperandList().get(0);
                SqlNode aliasSqlNode = (SqlNode)sqlBasicCall.getOperandList().get(1);
                ExpressionSegment expressionSegment = new ExpressionConverter().convertToSQLSegment(exprSqlNode).orElse(null);
                ExpressionProjectionSegment expressionProjectionSegment = new ExpressionProjectionSegment(this.getStartIndex((SqlNode)sqlBasicCall), this.getStopIndex((SqlNode)sqlBasicCall), exprSqlNode.toString(), expressionSegment);
                expressionProjectionSegment.setAlias(new AliasSegment(this.getStartIndex(aliasSqlNode), this.getStopIndex(aliasSqlNode), new IdentifierValue(aliasSqlNode.toString())));
                return Optional.of(expressionProjectionSegment);
            }
            ExpressionSegment expressionSegment = new ExpressionConverter().convertToSQLSegment(sqlNode).orElse(null);
            String text = expressionSegment instanceof FunctionSegment ? ((FunctionSegment)expressionSegment).getText() : sqlNode.toString();
            return Optional.of(new ExpressionProjectionSegment(this.getStartIndex(sqlNode), this.getStopIndex(sqlNode), text, expressionSegment));
        }
        return Optional.empty();
    }
}

