/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.federation.optimizer.converter.segment.projection.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSelectKeyword;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.infra.federation.optimizer.converter.segment.SQLSegmentConverter;
import org.apache.shardingsphere.sql.parser.sql.common.constant.AggregationType;
import org.apache.shardingsphere.sql.parser.sql.common.constant.QuoteCharacter;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.AggregationDistinctProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.AggregationProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.AliasSegment;
import org.apache.shardingsphere.sql.parser.sql.common.util.SQLUtil;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class AggregationProjectionConverter
implements SQLSegmentConverter<AggregationProjectionSegment, SqlBasicCall> {
    private static final Map<String, SqlAggFunction> REGISTRY = new TreeMap<String, SqlAggFunction>(String.CASE_INSENSITIVE_ORDER);

    private static void register(SqlAggFunction sqlAggFunction) {
        REGISTRY.put(sqlAggFunction.getName(), sqlAggFunction);
    }

    @Override
    public Optional<SqlBasicCall> convertToSQLNode(AggregationProjectionSegment segment) {
        if (null == segment) {
            return Optional.empty();
        }
        SqlLiteral functionQuantifier = null;
        List<String> parameters = Splitter.on((String)",").trimResults().splitToList((CharSequence)SQLUtil.getExpressionWithoutOutsideParentheses((String)segment.getInnerExpression()));
        if (segment instanceof AggregationDistinctProjectionSegment) {
            parameters = Collections.singletonList(((AggregationDistinctProjectionSegment)segment).getDistinctExpression());
            functionQuantifier = SqlLiteral.createSymbol((Enum)SqlSelectKeyword.DISTINCT, (SqlParserPos)SqlParserPos.ZERO);
        }
        if (segment.getAlias().isPresent()) {
            return Optional.of(new SqlBasicCall((SqlOperator)SqlStdOperatorTable.AS, new SqlNode[]{new SqlBasicCall((SqlOperator)this.convertOperator(segment.getType().name()), new SqlNode[]{this.createParametersSqlNode(parameters)}, SqlParserPos.ZERO, false, functionQuantifier), SqlIdentifier.star(Collections.singletonList((String)segment.getAlias().get()), (SqlParserPos)SqlParserPos.ZERO, Collections.singletonList(SqlParserPos.ZERO))}, SqlParserPos.ZERO));
        }
        return Optional.of(new SqlBasicCall((SqlOperator)this.convertOperator(segment.getType().name()), new SqlNode[]{this.createParametersSqlNode(parameters)}, SqlParserPos.ZERO, false, functionQuantifier));
    }

    @Override
    public Optional<AggregationProjectionSegment> convertToSQLSegment(SqlBasicCall sqlBasicCall) {
        if (null == sqlBasicCall) {
            return Optional.empty();
        }
        if (AggregationProjectionConverter.isAsOperatorAggregationType(sqlBasicCall)) {
            SqlBasicCall subSqlBasicCall = (SqlBasicCall)sqlBasicCall.getOperandList().get(0);
            AggregationType aggregationType = AggregationType.valueOf((String)subSqlBasicCall.getOperator().getName().toUpperCase());
            String innerExpression = this.getInnerExpression(subSqlBasicCall);
            AliasSegment aliasSegment = new AliasSegment(this.getStartIndex((SqlNode)sqlBasicCall.getOperandList().get(1)), this.getStopIndex((SqlNode)sqlBasicCall.getOperandList().get(1)), new IdentifierValue((String)((SqlIdentifier)sqlBasicCall.getOperandList().get((int)1)).names.get(0)));
            if (null != subSqlBasicCall.getFunctionQuantifier() && SqlSelectKeyword.DISTINCT == subSqlBasicCall.getFunctionQuantifier().getValue()) {
                return Optional.of(this.getAggregationDistinctProjectionSegment(subSqlBasicCall, aggregationType, aliasSegment));
            }
            AggregationProjectionSegment aggregationProjectionSegment = new AggregationProjectionSegment(this.getStartIndex((SqlNode)subSqlBasicCall), this.getStopIndex((SqlNode)subSqlBasicCall), aggregationType, innerExpression);
            aggregationProjectionSegment.setAlias(aliasSegment);
            return Optional.of(aggregationProjectionSegment);
        }
        AggregationType aggregationType = AggregationType.valueOf((String)sqlBasicCall.getOperator().getName());
        if (null != sqlBasicCall.getFunctionQuantifier() && SqlSelectKeyword.DISTINCT == sqlBasicCall.getFunctionQuantifier().getValue()) {
            return Optional.of(this.getAggregationDistinctProjectionSegment(sqlBasicCall, aggregationType, null));
        }
        String innerExpression = this.getInnerExpression(sqlBasicCall);
        return Optional.of(new AggregationProjectionSegment(this.getStartIndex((SqlNode)sqlBasicCall), this.getStopIndex((SqlNode)sqlBasicCall), aggregationType, innerExpression));
    }

    private AggregationDistinctProjectionSegment getAggregationDistinctProjectionSegment(SqlBasicCall sqlBasicCall, AggregationType aggregationType, AliasSegment aliasSegment) {
        String innerExpression = this.getInnerExpression(sqlBasicCall, SqlSelectKeyword.DISTINCT);
        String distinctParams = sqlBasicCall.getOperandList().stream().map(SqlNode::toString).collect(Collectors.joining(", "));
        AggregationDistinctProjectionSegment aggregationDistinctProjectionSegment = new AggregationDistinctProjectionSegment(this.getStartIndex((SqlNode)sqlBasicCall), this.getStopIndex((SqlNode)sqlBasicCall), aggregationType, innerExpression, distinctParams);
        aggregationDistinctProjectionSegment.setAlias(aliasSegment);
        return aggregationDistinctProjectionSegment;
    }

    private String getInnerExpression(SqlBasicCall sqlBasicCall, SqlSelectKeyword selectKeyword) {
        if (selectKeyword == null) {
            return this.getInnerExpression(sqlBasicCall);
        }
        String params = sqlBasicCall.getOperandList().stream().map(SqlNode::toString).collect(Collectors.joining(", "));
        return QuoteCharacter.PARENTHESES.wrap(selectKeyword.toString() + " " + params);
    }

    private String getInnerExpression(SqlBasicCall sqlBasicCall) {
        String params = sqlBasicCall.getOperandList().stream().map(SqlNode::toString).collect(Collectors.joining(", "));
        return QuoteCharacter.PARENTHESES.wrap(params);
    }

    private SqlAggFunction convertOperator(String operator) {
        Preconditions.checkState((boolean)REGISTRY.containsKey(operator), (String)"Unsupported SQL operator: `%s`", (Object)operator);
        return REGISTRY.get(operator);
    }

    public static boolean isAsOperatorAggregationType(SqlBasicCall sqlBasicCall) {
        return null != sqlBasicCall.getOperator() && SqlKind.AS == sqlBasicCall.getOperator().getKind() && sqlBasicCall.getOperandList().get(0) instanceof SqlBasicCall && AggregationType.isAggregationType((String)((SqlBasicCall)sqlBasicCall.getOperandList().get(0)).getOperator().getName());
    }

    private SqlNode createParametersSqlNode(List<String> parameters) {
        if (1 == parameters.size()) {
            try {
                Long.parseLong(parameters.get(0));
                return SqlLiteral.createExactNumeric((String)parameters.get(0), (SqlParserPos)SqlParserPos.ZERO);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return SqlIdentifier.star(parameters, (SqlParserPos)SqlParserPos.ZERO, Collections.singletonList(SqlParserPos.ZERO));
    }

    static {
        AggregationProjectionConverter.register(SqlStdOperatorTable.MAX);
        AggregationProjectionConverter.register(SqlStdOperatorTable.MIN);
        AggregationProjectionConverter.register(SqlStdOperatorTable.SUM);
        AggregationProjectionConverter.register(SqlStdOperatorTable.COUNT);
        AggregationProjectionConverter.register(SqlStdOperatorTable.AVG);
        AggregationProjectionConverter.register(SqlStdOperatorTable.BIT_XOR);
    }
}

