/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.federation.optimizer.converter.segment.expression.impl;

import java.util.List;
import java.util.Optional;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.infra.federation.optimizer.converter.segment.SQLSegmentConverter;
import org.apache.shardingsphere.infra.federation.optimizer.converter.segment.expression.ExpressionConverter;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ListExpression;

public final class ListExpressionConverter
implements SQLSegmentConverter<ListExpression, SqlNode> {
    @Override
    public Optional<SqlNode> convertToSQLNode(ListExpression segment) {
        SqlNode left = null;
        for (ExpressionSegment each : segment.getItems()) {
            Optional<SqlNode> sqlNode = new ExpressionConverter().convertToSQLNode(each);
            if (!sqlNode.isPresent()) continue;
            if (null == left) {
                left = sqlNode.get();
                continue;
            }
            left = new SqlBasicCall((SqlOperator)SqlStdOperatorTable.OR, new SqlNode[]{left, sqlNode.get()}, SqlParserPos.ZERO);
        }
        return Optional.ofNullable(left);
    }

    @Override
    public Optional<ListExpression> convertToSQLSegment(SqlNode sqlNode) {
        if (null == sqlNode) {
            return Optional.empty();
        }
        if (sqlNode instanceof SqlNodeList) {
            List items = ((SqlNodeList)sqlNode).getList();
            ListExpression result = new ListExpression(this.getStartIndex(sqlNode), this.getStopIndex(sqlNode));
            items.forEach(each -> new ExpressionConverter().convertToSQLSegment((SqlNode)each).ifPresent(result.getItems()::add));
            return Optional.of(result);
        }
        return Optional.empty();
    }
}

