/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.federation.optimizer.converter.segment.expression.impl;

import java.util.Optional;
import lombok.Generated;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.infra.federation.optimizer.converter.segment.SQLSegmentConverter;
import org.apache.shardingsphere.infra.federation.optimizer.converter.statement.SelectStatementConverter;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExistsSubqueryExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;

public final class ExistsSubqueryExpressionConverter
implements SQLSegmentConverter<ExistsSubqueryExpression, SqlBasicCall> {
    private final boolean not;

    public ExistsSubqueryExpressionConverter() {
        this.not = false;
    }

    @Override
    public Optional<SqlBasicCall> convertToSQLNode(ExistsSubqueryExpression expression) {
        if (null == expression) {
            return Optional.empty();
        }
        SqlBasicCall sqlNode = new SqlBasicCall((SqlOperator)SqlStdOperatorTable.EXISTS, new SqlNode[]{new SelectStatementConverter().convertToSQLNode(expression.getSubquery().getSelect())}, SqlParserPos.ZERO);
        return expression.isNot() ? Optional.of(new SqlBasicCall((SqlOperator)SqlStdOperatorTable.NOT, new SqlNode[]{sqlNode}, SqlParserPos.ZERO)) : Optional.of(sqlNode);
    }

    @Override
    public Optional<ExistsSubqueryExpression> convertToSQLSegment(SqlBasicCall sqlBasicCall) {
        if (null == sqlBasicCall) {
            return Optional.empty();
        }
        SqlNode subquerySqlNode = (SqlNode)sqlBasicCall.getOperandList().get(0);
        SelectStatement selectStatement = new SelectStatementConverter().convertToSQLStatement(subquerySqlNode);
        SubquerySegment subquery = new SubquerySegment(this.getStartIndex(subquerySqlNode) - 1, this.getStopIndex(subquerySqlNode) + 1, selectStatement);
        ExistsSubqueryExpression result = new ExistsSubqueryExpression(this.getStartIndex((SqlNode)sqlBasicCall), subquery.getStopIndex(), subquery);
        result.setNot(this.not);
        return Optional.of(result);
    }

    @Generated
    public ExistsSubqueryExpressionConverter(boolean not) {
        this.not = not;
    }
}

