/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.federation.optimizer.converter.segment.expression.impl;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.infra.federation.optimizer.converter.segment.SQLSegmentConverter;
import org.apache.shardingsphere.infra.federation.optimizer.converter.segment.expression.ExpressionConverter;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.InExpression;

public final class InExpressionConverter
implements SQLSegmentConverter<InExpression, SqlBasicCall> {
    private final boolean not;

    public InExpressionConverter() {
        this.not = false;
    }

    @Override
    public Optional<SqlBasicCall> convertToSQLNode(InExpression expression) {
        if (null == expression) {
            return Optional.empty();
        }
        LinkedList sqlNodes = new LinkedList();
        ExpressionConverter expressionConverter = new ExpressionConverter();
        expressionConverter.convertToSQLNode(expression.getLeft()).ifPresent(sqlNodes::add);
        expressionConverter.convertToSQLNode(expression.getRight()).ifPresent(sqlNode -> {
            if (sqlNode instanceof SqlBasicCall) {
                SqlNodeList sqlNodeList = new SqlNodeList(Arrays.asList((Object[])((SqlBasicCall)sqlNode).getOperands().clone()), SqlParserPos.ZERO);
                sqlNodes.add(sqlNodeList);
            } else {
                sqlNodes.add(sqlNode);
            }
        });
        SqlBasicCall sqlNode2 = new SqlBasicCall((SqlOperator)SqlStdOperatorTable.IN, sqlNodes.toArray(new SqlNode[0]), SqlParserPos.ZERO);
        return expression.isNot() ? Optional.of(new SqlBasicCall((SqlOperator)SqlStdOperatorTable.NOT, new SqlNode[]{sqlNode2}, SqlParserPos.ZERO)) : Optional.of(sqlNode2);
    }

    @Override
    public Optional<InExpression> convertToSQLSegment(SqlBasicCall sqlBasicCall) {
        if (null == sqlBasicCall) {
            return Optional.empty();
        }
        ExpressionConverter expressionConverter = new ExpressionConverter();
        ExpressionSegment left = expressionConverter.convertToSQLSegment((SqlNode)sqlBasicCall.getOperandList().get(0)).orElseThrow(IllegalStateException::new);
        ExpressionSegment right = expressionConverter.convertToSQLSegment((SqlNode)sqlBasicCall.getOperandList().get(1)).orElseThrow(IllegalStateException::new);
        return Optional.of(new InExpression(this.getStartIndex((SqlNode)sqlBasicCall), sqlBasicCall.getOperandList().get(1) instanceof SqlSelect ? this.getStopIndex((SqlNode)sqlBasicCall) + 1 : this.getStopIndex((SqlNode)sqlBasicCall), left, right, this.not));
    }

    @Generated
    public InExpressionConverter(boolean not) {
        this.not = not;
    }
}

