/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.federation.optimizer.converter.segment.expression.impl;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.infra.federation.optimizer.converter.segment.SQLSegmentConverter;
import org.apache.shardingsphere.infra.federation.optimizer.converter.segment.expression.ExpressionConverter;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ListExpression;

public final class BinaryOperationExpressionConverter
implements SQLSegmentConverter<BinaryOperationExpression, SqlBasicCall> {
    private static final Map<String, SqlOperator> REGISTRY = new TreeMap<String, SqlOperator>(String.CASE_INSENSITIVE_ORDER);

    private static void register() {
        BinaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.EQUALS);
        BinaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.NOT_EQUALS);
        BinaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.GREATER_THAN);
        BinaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL);
        BinaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.LESS_THAN);
        BinaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL);
        BinaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.OR);
        BinaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.AND);
        BinaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.PLUS);
        BinaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.MINUS);
        BinaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.MULTIPLY);
        BinaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.DIVIDE);
        BinaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.LIKE);
    }

    private static void register(SqlOperator sqlOperator) {
        REGISTRY.put(sqlOperator.getName(), sqlOperator);
    }

    private static void registerAlias() {
        REGISTRY.put("!=", (SqlOperator)SqlStdOperatorTable.NOT_EQUALS);
    }

    @Override
    public Optional<SqlBasicCall> convertToSQLNode(BinaryOperationExpression segment) {
        SqlOperator operator = this.convertOperator(segment.getOperator());
        SqlNode left = new ExpressionConverter().convertToSQLNode(segment.getLeft()).orElseThrow(IllegalStateException::new);
        SqlNode right = new ExpressionConverter().convertToSQLNode(segment.getRight()).orElseThrow(IllegalStateException::new);
        return Optional.of(new SqlBasicCall(operator, new SqlNode[]{left, right}, SqlParserPos.ZERO));
    }

    @Override
    public Optional<BinaryOperationExpression> convertToSQLSegment(SqlBasicCall sqlBasicCall) {
        ExpressionConverter expressionConverter = new ExpressionConverter();
        ExpressionSegment left = expressionConverter.convertToSQLSegment((SqlNode)sqlBasicCall.getOperandList().get(0)).orElseThrow(IllegalStateException::new);
        ExpressionSegment right = expressionConverter.convertToSQLSegment((SqlNode)sqlBasicCall.getOperandList().get(1)).orElseThrow(IllegalStateException::new);
        String operator = sqlBasicCall.getOperator().getName();
        String text = sqlBasicCall.toString();
        if (SqlKind.LIKE == sqlBasicCall.getOperator().getKind()) {
            ListExpression listExpression = new ListExpression(this.getStartIndex((SqlNode)sqlBasicCall.getOperandList().get(1)), this.getStopIndex((SqlNode)sqlBasicCall.getOperandList().get(1)));
            listExpression.getItems().add(right);
            return Optional.of(new BinaryOperationExpression(this.getStartIndex((SqlNode)sqlBasicCall), this.getStopIndex((SqlNode)sqlBasicCall), left, (ExpressionSegment)listExpression, operator, text));
        }
        return Optional.of(new BinaryOperationExpression(this.getStartIndex((SqlNode)sqlBasicCall), this.getStopIndex((SqlNode)sqlBasicCall), left, right, operator, text));
    }

    private SqlOperator convertOperator(String operator) {
        Preconditions.checkState((boolean)REGISTRY.containsKey(operator), (String)"Unsupported SQL operator: `%s`", (Object)operator);
        return REGISTRY.get(operator);
    }

    static {
        BinaryOperationExpressionConverter.register();
        BinaryOperationExpressionConverter.registerAlias();
    }
}

