/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.util.data.collect;

import java.util.HashMap;
import java.util.Map;
import org.apache.rocketmq.test.util.data.collect.DataCollector;
import org.apache.rocketmq.test.util.data.collect.impl.ListDataCollectorImpl;
import org.apache.rocketmq.test.util.data.collect.impl.MapDataCollectorImpl;

public final class DataCollectorManager {
    private static DataCollectorManager instance = new DataCollectorManager();
    private Map<String, DataCollector> collectMap = new HashMap<String, DataCollector>();
    private Object lock = new Object();

    private DataCollectorManager() {
    }

    public static DataCollectorManager getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataCollector fetchDataCollector(String key) {
        String realKey = key;
        if (!this.collectMap.containsKey(realKey)) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.collectMap.containsKey(realKey)) {
                    MapDataCollectorImpl collect = new MapDataCollectorImpl();
                    this.collectMap.put(realKey, collect);
                }
            }
        }
        return this.collectMap.get(realKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataCollector fetchMapDataCollector(String key) {
        String realKey = key;
        if (!this.collectMap.containsKey(realKey) || this.collectMap.get(realKey) instanceof ListDataCollectorImpl) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.collectMap.containsKey(realKey) || this.collectMap.get(realKey) instanceof ListDataCollectorImpl) {
                    MapDataCollectorImpl collect = null;
                    if (this.collectMap.containsKey(realKey)) {
                        DataCollector src = this.collectMap.get(realKey);
                        collect = new MapDataCollectorImpl(src.getAllData());
                    } else {
                        collect = new MapDataCollectorImpl();
                    }
                    this.collectMap.put(realKey, collect);
                }
            }
        }
        return this.collectMap.get(realKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataCollector fetchListDataCollector(String key) {
        String realKey = key;
        if (!this.collectMap.containsKey(realKey) || this.collectMap.get(realKey) instanceof MapDataCollectorImpl) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.collectMap.containsKey(realKey) || this.collectMap.get(realKey) instanceof MapDataCollectorImpl) {
                    ListDataCollectorImpl collect = null;
                    if (this.collectMap.containsKey(realKey)) {
                        DataCollector src = this.collectMap.get(realKey);
                        collect = new ListDataCollectorImpl(src.getAllData());
                    } else {
                        collect = new ListDataCollectorImpl();
                    }
                    this.collectMap.put(realKey, collect);
                }
            }
        }
        return this.collectMap.get(realKey);
    }

    public void resetDataCollect(String key) {
        if (this.collectMap.containsKey(key)) {
            this.collectMap.get(key).resetData();
        }
    }

    public void resetAll() {
        for (Map.Entry<String, DataCollector> entry : this.collectMap.entrySet()) {
            entry.getValue().resetData();
        }
    }

    public void removeDataCollect(String key) {
        this.collectMap.remove(key);
    }

    public void removeAll() {
        this.collectMap.clear();
    }
}

