/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.util;

import java.util.Random;
import java.util.UUID;

public class RandomUtils {
    private static final int UNICODE_START = 19968;
    private static final int UNICODE_END = 40864;
    private static Random rd = new Random();

    private RandomUtils() {
    }

    public static String getStringByUUID() {
        return UUID.randomUUID().toString();
    }

    public static String getCheseWord(int len) {
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char str = RandomUtils.getCheseChar();
            res.append(str);
        }
        return res.toString();
    }

    public static String getStringWithNumber(int n) {
        int[] arg = new int[]{48, 58};
        return RandomUtils.getString(n, arg);
    }

    public static String getStringWithCharacter(int n) {
        int[] arg = new int[]{97, 123, 65, 91};
        return RandomUtils.getString(n, arg);
    }

    private static String getString(int n, int[] arg) {
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            res.append(RandomUtils.getChar(arg));
        }
        return res.toString();
    }

    private static char getChar(int[] arg) {
        int size = arg.length;
        int c = rd.nextInt(size / 2);
        return (char)RandomUtils.getIntegerBetween(arg[c *= 2], arg[c + 1]);
    }

    public static int getIntegerBetween(int n, int m) {
        if (m == n) {
            return n;
        }
        int res = RandomUtils.getIntegerMoreThanZero();
        return n + res % (m - n);
    }

    public static int getIntegerMoreThanZero() {
        int res = rd.nextInt();
        while (res <= 0) {
            res = rd.nextInt();
        }
        return res;
    }

    private static char getCheseChar() {
        return (char)(19968 + rd.nextInt(20896));
    }
}

