/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.factory;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.test.util.RandomUtils;

public class MessageFactory {
    public static Message getRandomMessage(String topic) {
        return MessageFactory.getStringMessage(topic, RandomUtils.getStringByUUID());
    }

    public static Message getStringMessage(String topic, String body) {
        Message msg = new Message(topic, body.getBytes());
        return msg;
    }

    public static Message getStringMessageByTag(String topic, String tags, String body) {
        Message msg = new Message(topic, tags, body.getBytes());
        return msg;
    }

    public static Message getRandomMessageByTag(String topic, String tags) {
        return MessageFactory.getStringMessageByTag(topic, tags, RandomUtils.getStringByUUID());
    }

    public static Collection<Message> getRandomMessageList(String topic, int size) {
        ArrayList<Message> msgList = new ArrayList<Message>();
        for (int i = 0; i < size; ++i) {
            msgList.add(MessageFactory.getRandomMessage(topic));
        }
        return msgList;
    }

    public static Collection<Message> getRandomMessageListByTag(String topic, String tags, int size) {
        ArrayList<Message> msgList = new ArrayList<Message>();
        for (int i = 0; i < size; ++i) {
            msgList.add(MessageFactory.getRandomMessageByTag(topic, tags));
        }
        return msgList;
    }
}

