/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.client.rmq;

import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.test.clientinterface.AbstractMQProducer;
import org.apache.rocketmq.test.sendresult.SendResult;

public class RMQNormalProducer
extends AbstractMQProducer {
    private static Logger logger = Logger.getLogger(RMQNormalProducer.class);
    private DefaultMQProducer producer = null;
    private String nsAddr = null;

    public RMQNormalProducer(String nsAddr, String topic) {
        this(nsAddr, topic, false);
    }

    public RMQNormalProducer(String nsAddr, String topic, boolean useTLS) {
        super(topic);
        this.nsAddr = nsAddr;
        this.create(useTLS);
        this.start();
    }

    public RMQNormalProducer(String nsAddr, String topic, String producerGroupName, String producerInstanceName) {
        this(nsAddr, topic, producerGroupName, producerInstanceName, false);
    }

    public RMQNormalProducer(String nsAddr, String topic, String producerGroupName, String producerInstanceName, boolean useTLS) {
        super(topic);
        this.producerGroupName = producerGroupName;
        this.producerInstanceName = producerInstanceName;
        this.nsAddr = nsAddr;
        this.create(useTLS);
        this.start();
    }

    public DefaultMQProducer getProducer() {
        return this.producer;
    }

    public void setProducer(DefaultMQProducer producer) {
        this.producer = producer;
    }

    protected void create(boolean useTLS) {
        this.producer = new DefaultMQProducer();
        this.producer.setProducerGroup(this.getProducerGroupName());
        this.producer.setInstanceName(this.getProducerInstanceName());
        this.producer.setUseTLS(useTLS);
        if (this.nsAddr != null) {
            this.producer.setNamesrvAddr(this.nsAddr);
        }
    }

    public void start() {
        try {
            this.producer.start();
            super.setStartSuccess(true);
        }
        catch (MQClientException e) {
            super.setStartSuccess(false);
            logger.error((Object)"producer start failed!");
            e.printStackTrace();
        }
    }

    @Override
    public SendResult send(Object msg, Object orderKey) {
        org.apache.rocketmq.client.producer.SendResult metaqResult = null;
        Message message = (Message)msg;
        try {
            long start = System.currentTimeMillis();
            metaqResult = this.producer.send(message);
            this.msgRTs.addData(System.currentTimeMillis() - start);
            if (this.isDebug) {
                logger.info((Object)metaqResult);
            }
            this.sendResult.setMsgId(metaqResult.getMsgId());
            this.sendResult.setSendResult(metaqResult.getSendStatus().equals((Object)SendStatus.SEND_OK));
            this.sendResult.setBrokerIp(metaqResult.getMessageQueue().getBrokerName());
            this.msgBodys.addData(new String(message.getBody()));
            this.originMsgs.addData(msg);
            this.originMsgIndex.put(new String(message.getBody()), metaqResult);
        }
        catch (Exception e) {
            if (this.isDebug) {
                e.printStackTrace();
            }
            this.sendResult.setSendResult(false);
            this.sendResult.setSendException(e);
            this.errorMsgs.addData(msg);
        }
        return this.sendResult;
    }

    public void send(Map<MessageQueue, List<Object>> msgs) {
        for (MessageQueue mq : msgs.keySet()) {
            this.send(msgs.get(mq), mq);
        }
    }

    public void send(List<Object> msgs, MessageQueue mq) {
        for (Object msg : msgs) {
            this.sendMQ((Message)msg, mq);
        }
    }

    public SendResult sendMQ(Message msg, MessageQueue mq) {
        org.apache.rocketmq.client.producer.SendResult metaqResult = null;
        try {
            long start = System.currentTimeMillis();
            metaqResult = this.producer.send(msg, mq);
            this.msgRTs.addData(System.currentTimeMillis() - start);
            if (this.isDebug) {
                logger.info((Object)metaqResult);
            }
            this.sendResult.setMsgId(metaqResult.getMsgId());
            this.sendResult.setSendResult(metaqResult.getSendStatus().equals((Object)SendStatus.SEND_OK));
            this.sendResult.setBrokerIp(metaqResult.getMessageQueue().getBrokerName());
            this.msgBodys.addData(new String(msg.getBody()));
            this.originMsgs.addData(msg);
            this.originMsgIndex.put(new String(msg.getBody()), metaqResult);
        }
        catch (Exception e) {
            if (this.isDebug) {
                e.printStackTrace();
            }
            this.sendResult.setSendResult(false);
            this.sendResult.setSendException(e);
            this.errorMsgs.addData(msg);
        }
        return this.sendResult;
    }

    @Override
    public void shutdown() {
        this.producer.shutdown();
    }

    @Override
    public List<MessageQueue> getMessageQueue() {
        List mqs = null;
        try {
            mqs = this.producer.fetchPublishMessageQueues(this.topic);
        }
        catch (MQClientException e) {
            e.printStackTrace();
        }
        return mqs;
    }
}

