/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.rocketmq.store.DefaultMessageStore;
import org.apache.rocketmq.store.MappedFile;
import org.apache.rocketmq.store.MappedFileQueue;
import org.apache.rocketmq.store.SelectMappedBufferResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumeQueue {
    public static final int CQ_STORE_UNIT_SIZE = 20;
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqStore");
    private static final Logger LOG_ERROR = LoggerFactory.getLogger((String)"RocketmqStoreError");
    private final DefaultMessageStore defaultMessageStore;
    private final MappedFileQueue mappedFileQueue;
    private final String topic;
    private final int queueId;
    private final ByteBuffer byteBufferIndex;
    private final String storePath;
    private final int mappedFileSize;
    private long maxPhysicOffset = -1L;
    private volatile long minLogicOffset = 0L;

    public ConsumeQueue(String topic, int queueId, String storePath, int mappedFileSize, DefaultMessageStore defaultMessageStore) {
        this.storePath = storePath;
        this.mappedFileSize = mappedFileSize;
        this.defaultMessageStore = defaultMessageStore;
        this.topic = topic;
        this.queueId = queueId;
        String queueDir = this.storePath + File.separator + topic + File.separator + queueId;
        this.mappedFileQueue = new MappedFileQueue(queueDir, mappedFileSize, null);
        this.byteBufferIndex = ByteBuffer.allocate(20);
    }

    public boolean load() {
        boolean result = this.mappedFileQueue.load();
        log.info("load consume queue " + this.topic + "-" + this.queueId + " " + (result ? "OK" : "Failed"));
        return result;
    }

    public void recover() {
        List<MappedFile> mappedFiles = this.mappedFileQueue.getMappedFiles();
        if (!mappedFiles.isEmpty()) {
            long mappedFileOffset;
            long processOffset;
            block6: {
                int index = mappedFiles.size() - 3;
                if (index < 0) {
                    index = 0;
                }
                int mappedFileSizeLogics = this.mappedFileSize;
                MappedFile mappedFile = mappedFiles.get(index);
                ByteBuffer byteBuffer = mappedFile.sliceByteBuffer();
                processOffset = mappedFile.getFileFromOffset();
                mappedFileOffset = 0L;
                while (true) {
                    for (int i = 0; i < mappedFileSizeLogics; i += 20) {
                        long offset = byteBuffer.getLong();
                        int size = byteBuffer.getInt();
                        long tagsCode = byteBuffer.getLong();
                        if (offset < 0L || size <= 0) {
                            log.info("recover current consume queue file over,  " + mappedFile.getFileName() + " " + offset + " " + size + " " + tagsCode);
                            break;
                        }
                        mappedFileOffset = i + 20;
                        this.maxPhysicOffset = offset;
                    }
                    if (mappedFileOffset != (long)mappedFileSizeLogics) break;
                    if (++index >= mappedFiles.size()) {
                        log.info("recover last consume queue file over, last maped file " + mappedFile.getFileName());
                        break block6;
                    }
                    mappedFile = mappedFiles.get(index);
                    byteBuffer = mappedFile.sliceByteBuffer();
                    processOffset = mappedFile.getFileFromOffset();
                    mappedFileOffset = 0L;
                    log.info("recover next consume queue file, " + mappedFile.getFileName());
                }
                log.info("recover current consume queue queue over " + mappedFile.getFileName() + " " + (processOffset + mappedFileOffset));
            }
            this.mappedFileQueue.setFlushedWhere(processOffset += mappedFileOffset);
            this.mappedFileQueue.setCommittedWhere(processOffset);
            this.mappedFileQueue.truncateDirtyFiles(processOffset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getOffsetInQueueByTime(long timestamp) {
        MappedFile mappedFile = this.mappedFileQueue.getMappedFileByTime(timestamp);
        if (mappedFile != null) {
            long offset = 0L;
            int low = this.minLogicOffset > mappedFile.getFileFromOffset() ? (int)(this.minLogicOffset - mappedFile.getFileFromOffset()) : 0;
            int high = 0;
            int midOffset = -1;
            int targetOffset = -1;
            int leftOffset = -1;
            int rightOffset = -1;
            long leftIndexValue = -1L;
            long rightIndexValue = -1L;
            long minPhysicOffset = this.defaultMessageStore.getMinPhyOffset();
            SelectMappedBufferResult sbr = mappedFile.selectMappedBuffer(0);
            if (null != sbr) {
                ByteBuffer byteBuffer = sbr.getByteBuffer();
                high = byteBuffer.limit() - 20;
                try {
                    while (high >= low) {
                        midOffset = (low + high) / 40 * 20;
                        byteBuffer.position(midOffset);
                        long phyOffset = byteBuffer.getLong();
                        int size = byteBuffer.getInt();
                        if (phyOffset < minPhysicOffset) {
                            low = midOffset + 20;
                            leftOffset = midOffset;
                            continue;
                        }
                        long storeTime = this.defaultMessageStore.getCommitLog().pickupStoreTimestamp(phyOffset, size);
                        if (storeTime < 0L) {
                            long l = 0L;
                            return l;
                        }
                        if (storeTime == timestamp) {
                            targetOffset = midOffset;
                            break;
                        }
                        if (storeTime > timestamp) {
                            high = midOffset - 20;
                            rightOffset = midOffset;
                            rightIndexValue = storeTime;
                            continue;
                        }
                        low = midOffset + 20;
                        leftOffset = midOffset;
                        leftIndexValue = storeTime;
                    }
                    offset = targetOffset != -1 ? (long)targetOffset : (leftIndexValue == -1L ? (long)rightOffset : (rightIndexValue == -1L ? (long)leftOffset : (Math.abs(timestamp - leftIndexValue) > Math.abs(timestamp - rightIndexValue) ? (long)rightOffset : (long)leftOffset)));
                    long l = (mappedFile.getFileFromOffset() + offset) / 20L;
                    return l;
                }
                finally {
                    sbr.release();
                }
            }
        }
        return 0L;
    }

    public void truncateDirtyLogicFiles(long phyOffet) {
        MappedFile mappedFile;
        int logicFileSize = this.mappedFileSize;
        this.maxPhysicOffset = phyOffet - 1L;
        block0: while ((mappedFile = this.mappedFileQueue.getLastMappedFile()) != null) {
            ByteBuffer byteBuffer = mappedFile.sliceByteBuffer();
            mappedFile.setWrotePosition(0);
            mappedFile.setCommittedPosition(0);
            mappedFile.setFlushedPosition(0);
            for (int i = 0; i < logicFileSize; i += 20) {
                int pos;
                long offset = byteBuffer.getLong();
                int size = byteBuffer.getInt();
                byteBuffer.getLong();
                if (0 == i) {
                    if (offset >= phyOffet) {
                        this.mappedFileQueue.deleteLastMappedFile();
                        continue block0;
                    }
                    pos = i + 20;
                    mappedFile.setWrotePosition(pos);
                    mappedFile.setCommittedPosition(pos);
                    mappedFile.setFlushedPosition(pos);
                    this.maxPhysicOffset = offset;
                    continue;
                }
                if (offset >= 0L && size > 0) {
                    if (offset >= phyOffet) {
                        return;
                    }
                    pos = i + 20;
                    mappedFile.setWrotePosition(pos);
                    mappedFile.setCommittedPosition(pos);
                    mappedFile.setFlushedPosition(pos);
                    this.maxPhysicOffset = offset;
                    if (pos != logicFileSize) continue;
                    return;
                }
                return;
            }
        }
    }

    public long getLastOffset() {
        long lastOffset = -1L;
        int logicFileSize = this.mappedFileSize;
        MappedFile mappedFile = this.mappedFileQueue.getLastMappedFile();
        if (mappedFile != null) {
            int position = mappedFile.getWrotePosition() - 20;
            if (position < 0) {
                position = 0;
            }
            ByteBuffer byteBuffer = mappedFile.sliceByteBuffer();
            byteBuffer.position(position);
            for (int i = 0; i < logicFileSize; i += 20) {
                long offset = byteBuffer.getLong();
                int size = byteBuffer.getInt();
                byteBuffer.getLong();
                if (offset < 0L || size <= 0) break;
                lastOffset = offset + (long)size;
            }
        }
        return lastOffset;
    }

    public boolean flush(int flushLeastPages) {
        return this.mappedFileQueue.flush(flushLeastPages);
    }

    public int deleteExpiredFile(long offset) {
        int cnt = this.mappedFileQueue.deleteExpiredFileByOffset(offset, 20);
        this.correctMinOffset(offset);
        return cnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void correctMinOffset(long phyMinOffset) {
        SelectMappedBufferResult result;
        MappedFile mappedFile = this.mappedFileQueue.getFirstMappedFile();
        if (mappedFile != null && (result = mappedFile.selectMappedBuffer(0)) != null) {
            try {
                for (int i = 0; i < result.getSize(); i += 20) {
                    long offsetPy = result.getByteBuffer().getLong();
                    result.getByteBuffer().getInt();
                    result.getByteBuffer().getLong();
                    if (offsetPy < phyMinOffset) continue;
                    this.minLogicOffset = result.getMappedFile().getFileFromOffset() + (long)i;
                    log.info("compute logics min offset: " + this.getMinOffsetInQueue() + ", topic: " + this.topic + ", queueId: " + this.queueId);
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                result.release();
            }
        }
    }

    public long getMinOffsetInQueue() {
        return this.minLogicOffset / 20L;
    }

    public void putMessagePositionInfoWrapper(long offset, int size, long tagsCode, long storeTimestamp, long logicOffset) {
        int maxRetries = 30;
        boolean canWrite = this.defaultMessageStore.getRunningFlags().isWriteable();
        for (int i = 0; i < 30 && canWrite; ++i) {
            boolean result = this.putMessagePositionInfo(offset, size, tagsCode, logicOffset);
            if (result) {
                this.defaultMessageStore.getStoreCheckpoint().setLogicsMsgTimestamp(storeTimestamp);
                return;
            }
            log.warn("[BUG]put commit log position info to " + this.topic + ":" + this.queueId + " " + offset + " failed, retry " + i + " times");
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                log.warn("", (Throwable)e);
            }
        }
        log.error("[BUG]consume queue can not write, {} {}", (Object)this.topic, (Object)this.queueId);
        this.defaultMessageStore.getRunningFlags().makeLogicsQueueError();
    }

    private boolean putMessagePositionInfo(long offset, int size, long tagsCode, long cqOffset) {
        if (offset <= this.maxPhysicOffset) {
            return true;
        }
        this.byteBufferIndex.flip();
        this.byteBufferIndex.limit(20);
        this.byteBufferIndex.putLong(offset);
        this.byteBufferIndex.putInt(size);
        this.byteBufferIndex.putLong(tagsCode);
        long expectLogicOffset = cqOffset * 20L;
        MappedFile mappedFile = this.mappedFileQueue.getLastMappedFile(expectLogicOffset);
        if (mappedFile != null) {
            long currentLogicOffset;
            if (mappedFile.isFirstCreateInQueue() && cqOffset != 0L && mappedFile.getWrotePosition() == 0) {
                this.minLogicOffset = expectLogicOffset;
                this.mappedFileQueue.setFlushedWhere(expectLogicOffset);
                this.mappedFileQueue.setCommittedWhere(expectLogicOffset);
                this.fillPreBlank(mappedFile, expectLogicOffset);
                log.info("fill pre blank space " + mappedFile.getFileName() + " " + expectLogicOffset + " " + mappedFile.getWrotePosition());
            }
            if (cqOffset != 0L && expectLogicOffset != (currentLogicOffset = (long)mappedFile.getWrotePosition() + mappedFile.getFileFromOffset())) {
                LOG_ERROR.warn("[BUG]logic queue order maybe wrong, expectLogicOffset: {} currentLogicOffset: {} Topic: {} QID: {} Diff: {}", new Object[]{expectLogicOffset, currentLogicOffset, this.topic, this.queueId, expectLogicOffset - currentLogicOffset});
            }
            this.maxPhysicOffset = offset;
            return mappedFile.appendMessage(this.byteBufferIndex.array());
        }
        return false;
    }

    private void fillPreBlank(MappedFile mappedFile, long untilWhere) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(20);
        byteBuffer.putLong(0L);
        byteBuffer.putInt(Integer.MAX_VALUE);
        byteBuffer.putLong(0L);
        int until = (int)(untilWhere % (long)this.mappedFileQueue.getMappedFileSize());
        for (int i = 0; i < until; i += 20) {
            mappedFile.appendMessage(byteBuffer.array());
        }
    }

    public SelectMappedBufferResult getIndexBuffer(long startIndex) {
        MappedFile mappedFile;
        int mappedFileSize = this.mappedFileSize;
        long offset = startIndex * 20L;
        if (offset >= this.getMinLogicOffset() && (mappedFile = this.mappedFileQueue.findMappedFileByOffset(offset)) != null) {
            SelectMappedBufferResult result = mappedFile.selectMappedBuffer((int)(offset % (long)mappedFileSize));
            return result;
        }
        return null;
    }

    public long getMinLogicOffset() {
        return this.minLogicOffset;
    }

    public void setMinLogicOffset(long minLogicOffset) {
        this.minLogicOffset = minLogicOffset;
    }

    public long rollNextFile(long index) {
        int mappedFileSize = this.mappedFileSize;
        int totalUnitsInFile = mappedFileSize / 20;
        return index + (long)totalUnitsInFile - index % (long)totalUnitsInFile;
    }

    public String getTopic() {
        return this.topic;
    }

    public int getQueueId() {
        return this.queueId;
    }

    public long getMaxPhysicOffset() {
        return this.maxPhysicOffset;
    }

    public void setMaxPhysicOffset(long maxPhysicOffset) {
        this.maxPhysicOffset = maxPhysicOffset;
    }

    public void destroy() {
        this.maxPhysicOffset = -1L;
        this.minLogicOffset = 0L;
        this.mappedFileQueue.destroy();
    }

    public long getMessageTotalInQueue() {
        return this.getMaxOffsetInQueue() - this.getMinOffsetInQueue();
    }

    public long getMaxOffsetInQueue() {
        return this.mappedFileQueue.getMaxOffset() / 20L;
    }

    public void checkSelf() {
        this.mappedFileQueue.checkSelf();
    }
}

