/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.srvutil;

import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.rocketmq.logging.InternalLogger;

public class ShutdownHookThread
extends Thread {
    private volatile boolean hasShutdown = false;
    private AtomicInteger shutdownTimes = new AtomicInteger(0);
    private final InternalLogger log;
    private final Callable callback;

    public ShutdownHookThread(InternalLogger log, Callable callback) {
        super("ShutdownHook");
        this.log = log;
        this.callback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ShutdownHookThread shutdownHookThread = this;
        synchronized (shutdownHookThread) {
            this.log.info("shutdown hook was invoked, " + this.shutdownTimes.incrementAndGet() + " times.");
            if (!this.hasShutdown) {
                this.hasShutdown = true;
                long beginTime = System.currentTimeMillis();
                try {
                    this.callback.call();
                }
                catch (Exception e) {
                    this.log.error("shutdown hook callback invoked failure.", (Throwable)e);
                }
                long consumingTimeTotal = System.currentTimeMillis() - beginTime;
                this.log.info("shutdown hook done, consuming time total(ms): " + consumingTimeTotal);
            }
        }
    }
}

