/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.remoting.protocol.body;

import java.util.Set;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.RemotingSerializable;
import org.apache.rocketmq.remoting.protocol.body.BrokerMemberGroup;
import org.apache.rocketmq.remoting.protocol.body.ElectMasterResponseBody;
import org.apache.rocketmq.remoting.protocol.header.controller.ElectMasterResponseHeader;

public class RoleChangeNotifyEntry {
    private final BrokerMemberGroup brokerMemberGroup;
    private final String masterAddress;
    private final Long masterBrokerId;
    private final int masterEpoch;
    private final int syncStateSetEpoch;
    private final Set<Long> syncStateSet;

    public RoleChangeNotifyEntry(BrokerMemberGroup brokerMemberGroup, String masterAddress, Long masterBrokerId, int masterEpoch, int syncStateSetEpoch, Set<Long> syncStateSet) {
        this.brokerMemberGroup = brokerMemberGroup;
        this.masterAddress = masterAddress;
        this.masterEpoch = masterEpoch;
        this.syncStateSetEpoch = syncStateSetEpoch;
        this.masterBrokerId = masterBrokerId;
        this.syncStateSet = syncStateSet;
    }

    public static RoleChangeNotifyEntry convert(RemotingCommand electMasterResponse) {
        ElectMasterResponseHeader header = (ElectMasterResponseHeader)electMasterResponse.readCustomHeader();
        BrokerMemberGroup brokerMemberGroup = null;
        Set<Long> syncStateSet = null;
        if (electMasterResponse.getBody() != null && electMasterResponse.getBody().length > 0) {
            ElectMasterResponseBody body = RemotingSerializable.decode(electMasterResponse.getBody(), ElectMasterResponseBody.class);
            brokerMemberGroup = body.getBrokerMemberGroup();
            syncStateSet = body.getSyncStateSet();
        }
        return new RoleChangeNotifyEntry(brokerMemberGroup, header.getMasterAddress(), header.getMasterBrokerId(), header.getMasterEpoch(), header.getSyncStateSetEpoch(), syncStateSet);
    }

    public BrokerMemberGroup getBrokerMemberGroup() {
        return this.brokerMemberGroup;
    }

    public String getMasterAddress() {
        return this.masterAddress;
    }

    public int getMasterEpoch() {
        return this.masterEpoch;
    }

    public int getSyncStateSetEpoch() {
        return this.syncStateSetEpoch;
    }

    public Long getMasterBrokerId() {
        return this.masterBrokerId;
    }

    public Set<Long> getSyncStateSet() {
        return this.syncStateSet;
    }
}

