/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.rocketmq.common.annotation.ImportantField;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;

public class BrokerIdentity {
    private static final String DEFAULT_CLUSTER_NAME = "DefaultCluster";
    protected static final Logger LOGGER = LoggerFactory.getLogger((String)"RocketmqCommon");
    private static String localHostName;
    public static final BrokerIdentity BROKER_CONTAINER_IDENTITY;
    @ImportantField
    private String brokerName = this.defaultBrokerName();
    @ImportantField
    private String brokerClusterName = "DefaultCluster";
    @ImportantField
    private volatile long brokerId = 0L;
    private boolean isBrokerContainer = false;
    private boolean isInBrokerContainer = false;

    public BrokerIdentity() {
    }

    public BrokerIdentity(boolean isBrokerContainer) {
        this.isBrokerContainer = isBrokerContainer;
    }

    public BrokerIdentity(String brokerClusterName, String brokerName, long brokerId) {
        this.brokerName = brokerName;
        this.brokerClusterName = brokerClusterName;
        this.brokerId = brokerId;
    }

    public BrokerIdentity(String brokerClusterName, String brokerName, long brokerId, boolean isInBrokerContainer) {
        this.brokerName = brokerName;
        this.brokerClusterName = brokerClusterName;
        this.brokerId = brokerId;
        this.isInBrokerContainer = isInBrokerContainer;
    }

    public String getBrokerName() {
        return this.brokerName;
    }

    public void setBrokerName(String brokerName) {
        this.brokerName = brokerName;
    }

    public String getBrokerClusterName() {
        return this.brokerClusterName;
    }

    public void setBrokerClusterName(String brokerClusterName) {
        this.brokerClusterName = brokerClusterName;
    }

    public long getBrokerId() {
        return this.brokerId;
    }

    public void setBrokerId(long brokerId) {
        this.brokerId = brokerId;
    }

    public boolean isInBrokerContainer() {
        return this.isInBrokerContainer;
    }

    public void setInBrokerContainer(boolean inBrokerContainer) {
        this.isInBrokerContainer = inBrokerContainer;
    }

    private String defaultBrokerName() {
        return StringUtils.isEmpty((CharSequence)localHostName) ? "DEFAULT_BROKER" : localHostName;
    }

    public String getCanonicalName() {
        return this.isBrokerContainer ? "BrokerContainer" : String.format("%s_%s_%d", this.brokerClusterName, this.brokerName, this.brokerId);
    }

    public String getIdentifier() {
        return "#" + this.getCanonicalName() + "#";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrokerIdentity identity = (BrokerIdentity)o;
        return new EqualsBuilder().append(this.brokerId, identity.brokerId).append((Object)this.brokerName, (Object)identity.brokerName).append((Object)this.brokerClusterName, (Object)identity.brokerClusterName).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.brokerName).append((Object)this.brokerClusterName).append(this.brokerId).toHashCode();
    }

    static {
        try {
            localHostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOGGER.error("Failed to obtain the host name", (Throwable)e);
        }
        BROKER_CONTAINER_IDENTITY = new BrokerIdentity(true);
    }
}

