/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common;

public class BrokerAddrInfo {
    private final String clusterName;
    private final String brokerAddr;
    private int hash;

    public BrokerAddrInfo(String clusterName, String brokerAddr) {
        this.clusterName = clusterName;
        this.brokerAddr = brokerAddr;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getBrokerAddr() {
        return this.brokerAddr;
    }

    public boolean isEmpty() {
        return this.clusterName.isEmpty() && this.brokerAddr.isEmpty();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof BrokerAddrInfo) {
            BrokerAddrInfo addr = (BrokerAddrInfo)obj;
            return this.clusterName.equals(addr.clusterName) && this.brokerAddr.equals(addr.brokerAddr);
        }
        return false;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0 && this.clusterName.length() + this.brokerAddr.length() > 0) {
            int i;
            for (i = 0; i < this.clusterName.length(); ++i) {
                h = 31 * h + this.clusterName.charAt(i);
            }
            h = 31 * h + 95;
            for (i = 0; i < this.brokerAddr.length(); ++i) {
                h = 31 * h + this.brokerAddr.charAt(i);
            }
            this.hash = h;
        }
        return h;
    }

    public String toString() {
        return "BrokerAddrInfo [clusterName=" + this.clusterName + ", brokerAddr=" + this.brokerAddr + "]";
    }
}

