/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.state;

import java.util.Map;
import java.util.Objects;
import org.apache.rocketmq.shaded.io.opentelemetry.api.common.Attributes;
import org.apache.rocketmq.shaded.io.opentelemetry.context.Context;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.data.ExemplarData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.data.MetricData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.export.CollectionInfo;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.state.BoundStorageHandle;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.state.DeltaMetricStorage;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.state.SynchronousMetricStorage;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.state.TemporalMetricStorage;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.view.AttributesProcessor;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.resources.Resource;

public final class DefaultSynchronousMetricStorage<T, U extends ExemplarData>
implements SynchronousMetricStorage {
    private final MetricDescriptor metricDescriptor;
    private final DeltaMetricStorage<T, U> deltaMetricStorage;
    private final TemporalMetricStorage<T, U> temporalMetricStorage;
    private final AttributesProcessor attributesProcessor;
    private final BoundStorageHandle lateBoundStorageHandle = new BoundStorageHandle(){

        @Override
        public void release() {
        }

        @Override
        public void recordLong(long value, Attributes attributes, Context context) {
            DefaultSynchronousMetricStorage.this.recordLong(value, attributes, context);
        }

        @Override
        public void recordDouble(double value, Attributes attributes, Context context) {
            DefaultSynchronousMetricStorage.this.recordDouble(value, attributes, context);
        }
    };

    DefaultSynchronousMetricStorage(MetricDescriptor metricDescriptor, Aggregator<T, U> aggregator, AttributesProcessor attributesProcessor) {
        this.attributesProcessor = attributesProcessor;
        this.metricDescriptor = metricDescriptor;
        this.deltaMetricStorage = new DeltaMetricStorage<T, U>(aggregator, metricDescriptor.getSourceInstrument());
        this.temporalMetricStorage = new TemporalMetricStorage<T, U>(aggregator, true);
    }

    @Override
    public BoundStorageHandle bind(Attributes attributes) {
        Objects.requireNonNull(attributes, "attributes");
        if (this.attributesProcessor.usesContext()) {
            return this.lateBoundStorageHandle;
        }
        return this.deltaMetricStorage.bind(this.attributesProcessor.process(attributes, Context.current()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordLong(long value, Attributes attributes, Context context) {
        Objects.requireNonNull(attributes, "attributes");
        attributes = this.attributesProcessor.process(attributes, context);
        BoundStorageHandle handle = this.deltaMetricStorage.bind(attributes);
        try {
            handle.recordLong(value, attributes, context);
        }
        finally {
            handle.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordDouble(double value, Attributes attributes, Context context) {
        Objects.requireNonNull(attributes, "attributes");
        attributes = this.attributesProcessor.process(attributes, context);
        BoundStorageHandle handle = this.deltaMetricStorage.bind(attributes);
        try {
            handle.recordDouble(value, attributes, context);
        }
        finally {
            handle.release();
        }
    }

    @Override
    public MetricData collectAndReset(CollectionInfo collectionInfo, Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, long startEpochNanos, long epochNanos, boolean suppressSynchronousCollection) {
        AggregationTemporality temporality = collectionInfo.getAggregationTemporality(this.getMetricDescriptor().getSourceInstrument().getType());
        Map<Attributes, T> result = this.deltaMetricStorage.collectFor(collectionInfo.getCollector(), collectionInfo.getAllCollectors(), suppressSynchronousCollection);
        return this.temporalMetricStorage.buildMetricFor(collectionInfo.getCollector(), resource, instrumentationScopeInfo, this.getMetricDescriptor(), temporality, result, startEpochNanos, epochNanos);
    }

    @Override
    public MetricDescriptor getMetricDescriptor() {
        return this.metricDescriptor;
    }
}

