/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.shaded.io.opentelemetry.sdk.logs.data;

import java.time.Instant;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.rocketmq.shaded.io.opentelemetry.api.common.Attributes;
import org.apache.rocketmq.shaded.io.opentelemetry.api.trace.Span;
import org.apache.rocketmq.shaded.io.opentelemetry.api.trace.SpanContext;
import org.apache.rocketmq.shaded.io.opentelemetry.context.Context;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.common.Clock;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.logs.data.Body;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.logs.data.LogData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.logs.data.LogDataImpl;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.logs.data.Severity;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.resources.Resource;

public final class LogDataBuilder {
    private final Resource resource;
    private final InstrumentationScopeInfo instrumentationScopeInfo;
    private long epochNanos;
    private SpanContext spanContext = SpanContext.getInvalid();
    private Severity severity = Severity.UNDEFINED_SEVERITY_NUMBER;
    @Nullable
    private String severityText;
    private Body body = Body.empty();
    private final Clock clock;
    private Attributes attributes = Attributes.empty();

    private LogDataBuilder(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, Clock clock) {
        this.resource = resource;
        this.instrumentationScopeInfo = instrumentationScopeInfo;
        this.clock = clock;
    }

    public static LogDataBuilder create(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo) {
        return LogDataBuilder.create(resource, instrumentationScopeInfo, Clock.getDefault());
    }

    public static LogDataBuilder create(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, Clock clock) {
        return new LogDataBuilder(resource, instrumentationScopeInfo, clock);
    }

    public LogDataBuilder setEpoch(long timestamp, TimeUnit unit) {
        this.epochNanos = unit.toNanos(timestamp);
        return this;
    }

    public LogDataBuilder setEpoch(Instant instant) {
        this.epochNanos = TimeUnit.SECONDS.toNanos(instant.getEpochSecond()) + (long)instant.getNano();
        return this;
    }

    public LogDataBuilder setContext(Context context) {
        return this.setSpanContext(Span.fromContext(context).getSpanContext());
    }

    public LogDataBuilder setSpanContext(SpanContext spanContext) {
        this.spanContext = spanContext == null ? SpanContext.getInvalid() : spanContext;
        return this;
    }

    public LogDataBuilder setSeverity(Severity severity) {
        this.severity = severity;
        return this;
    }

    public LogDataBuilder setSeverityText(String severityText) {
        this.severityText = severityText;
        return this;
    }

    public LogDataBuilder setBody(String body) {
        this.body = Body.string(body);
        return this;
    }

    public LogDataBuilder setAttributes(Attributes attributes) {
        this.attributes = attributes;
        return this;
    }

    public LogData build() {
        if (this.epochNanos == 0L) {
            this.epochNanos = this.clock.now();
        }
        return LogDataImpl.create(this.resource, this.instrumentationScopeInfo, this.epochNanos, this.spanContext, this.severity, this.severityText, this.body, this.attributes);
    }
}

