/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.subscription;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.BrokerPathConfigHelper;
import org.apache.rocketmq.common.ConfigManager;
import org.apache.rocketmq.common.DataVersion;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.subscription.SubscriptionGroupConfig;
import org.apache.rocketmq.remoting.protocol.RemotingSerializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionGroupManager
extends ConfigManager {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqBroker");
    private final ConcurrentHashMap<String, SubscriptionGroupConfig> subscriptionGroupTable = new ConcurrentHashMap(1024);
    private final DataVersion dataVersion = new DataVersion();
    private transient BrokerController brokerController;

    public SubscriptionGroupManager() {
        this.init();
    }

    public SubscriptionGroupManager(BrokerController brokerController) {
        this.brokerController = brokerController;
        this.init();
    }

    private void init() {
        SubscriptionGroupConfig subscriptionGroupConfig = new SubscriptionGroupConfig();
        subscriptionGroupConfig.setGroupName("TOOLS_CONSUMER");
        this.subscriptionGroupTable.put("TOOLS_CONSUMER", subscriptionGroupConfig);
        subscriptionGroupConfig = new SubscriptionGroupConfig();
        subscriptionGroupConfig.setGroupName("FILTERSRV_CONSUMER");
        this.subscriptionGroupTable.put("FILTERSRV_CONSUMER", subscriptionGroupConfig);
        subscriptionGroupConfig = new SubscriptionGroupConfig();
        subscriptionGroupConfig.setGroupName("SELF_TEST_C_GROUP");
        this.subscriptionGroupTable.put("SELF_TEST_C_GROUP", subscriptionGroupConfig);
        subscriptionGroupConfig = new SubscriptionGroupConfig();
        subscriptionGroupConfig.setGroupName("CID_ONS-HTTP-PROXY");
        subscriptionGroupConfig.setConsumeBroadcastEnable(true);
        this.subscriptionGroupTable.put("CID_ONS-HTTP-PROXY", subscriptionGroupConfig);
        subscriptionGroupConfig = new SubscriptionGroupConfig();
        subscriptionGroupConfig.setGroupName("CID_ONSAPI_PULL");
        subscriptionGroupConfig.setConsumeBroadcastEnable(true);
        this.subscriptionGroupTable.put("CID_ONSAPI_PULL", subscriptionGroupConfig);
        subscriptionGroupConfig = new SubscriptionGroupConfig();
        subscriptionGroupConfig.setGroupName("CID_ONSAPI_PERMISSION");
        subscriptionGroupConfig.setConsumeBroadcastEnable(true);
        this.subscriptionGroupTable.put("CID_ONSAPI_PERMISSION", subscriptionGroupConfig);
        subscriptionGroupConfig = new SubscriptionGroupConfig();
        subscriptionGroupConfig.setGroupName("CID_ONSAPI_OWNER");
        subscriptionGroupConfig.setConsumeBroadcastEnable(true);
        this.subscriptionGroupTable.put("CID_ONSAPI_OWNER", subscriptionGroupConfig);
    }

    public void updateSubscriptionGroupConfig(SubscriptionGroupConfig config) {
        SubscriptionGroupConfig old = this.subscriptionGroupTable.put(config.getGroupName(), config);
        if (old != null) {
            log.info("update subscription group config, old: {} new: {}", (Object)old, (Object)config);
        } else {
            log.info("create new subscription group, {}", (Object)config);
        }
        this.dataVersion.nextVersion();
        this.persist();
    }

    public void disableConsume(String groupName) {
        SubscriptionGroupConfig old = this.subscriptionGroupTable.get(groupName);
        if (old != null) {
            old.setConsumeEnable(false);
            this.dataVersion.nextVersion();
        }
    }

    public SubscriptionGroupConfig findSubscriptionGroupConfig(String group) {
        SubscriptionGroupConfig subscriptionGroupConfig = this.subscriptionGroupTable.get(group);
        if (null == subscriptionGroupConfig && (this.brokerController.getBrokerConfig().isAutoCreateSubscriptionGroup() || MixAll.isSysConsumerGroup((String)group))) {
            subscriptionGroupConfig = new SubscriptionGroupConfig();
            subscriptionGroupConfig.setGroupName(group);
            SubscriptionGroupConfig preConfig = this.subscriptionGroupTable.putIfAbsent(group, subscriptionGroupConfig);
            if (null == preConfig) {
                log.info("auto create a subscription group, {}", (Object)subscriptionGroupConfig.toString());
            }
            this.dataVersion.nextVersion();
            this.persist();
        }
        return subscriptionGroupConfig;
    }

    public String encode() {
        return this.encode(false);
    }

    public String configFilePath() {
        return BrokerPathConfigHelper.getSubscriptionGroupPath(this.brokerController.getMessageStoreConfig().getStorePathRootDir());
    }

    public void decode(String jsonString) {
        SubscriptionGroupManager obj;
        if (jsonString != null && (obj = (SubscriptionGroupManager)((Object)RemotingSerializable.fromJson((String)jsonString, SubscriptionGroupManager.class))) != null) {
            this.subscriptionGroupTable.putAll(obj.subscriptionGroupTable);
            this.dataVersion.assignNewOne(obj.dataVersion);
            this.printLoadDataWhenFirstBoot(obj);
        }
    }

    public String encode(boolean prettyFormat) {
        return RemotingSerializable.toJson((Object)((Object)this), (boolean)prettyFormat);
    }

    private void printLoadDataWhenFirstBoot(SubscriptionGroupManager sgm) {
        for (Map.Entry<String, SubscriptionGroupConfig> next : sgm.getSubscriptionGroupTable().entrySet()) {
            log.info("load exist subscription group, {}", (Object)next.getValue().toString());
        }
    }

    public ConcurrentHashMap<String, SubscriptionGroupConfig> getSubscriptionGroupTable() {
        return this.subscriptionGroupTable;
    }

    public DataVersion getDataVersion() {
        return this.dataVersion;
    }

    public void deleteSubscriptionGroupConfig(String groupName) {
        SubscriptionGroupConfig old = this.subscriptionGroupTable.remove(groupName);
        if (old != null) {
            log.info("delete subscription group OK, subscription group:{}", (Object)old);
            this.dataVersion.nextVersion();
            this.persist();
        } else {
            log.warn("delete subscription group failed, subscription groupName: {} not exist", (Object)groupName);
        }
    }
}

