/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.processor;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.util.Map;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.common.TopicFilterType;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageAccessor;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.protocol.header.EndTransactionRequestHeader;
import org.apache.rocketmq.common.sysflag.MessageSysFlag;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.store.MessageExtBrokerInner;
import org.apache.rocketmq.store.MessageStore;
import org.apache.rocketmq.store.PutMessageResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndTransactionProcessor
implements NettyRequestProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RocketmqTransaction");
    private final BrokerController brokerController;

    public EndTransactionProcessor(BrokerController brokerController) {
        this.brokerController = brokerController;
    }

    public RemotingCommand processRequest(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        EndTransactionRequestHeader requestHeader;
        RemotingCommand response;
        block26: {
            block25: {
                response = RemotingCommand.createResponseCommand(null);
                requestHeader = (EndTransactionRequestHeader)request.decodeCommandCustomHeader(EndTransactionRequestHeader.class);
                if (!requestHeader.getFromTransactionCheck().booleanValue()) break block25;
                switch (requestHeader.getCommitOrRollback()) {
                    case 0: {
                        LOGGER.warn("check producer[{}] transaction state, but it's pending status.RequestHeader: {} Remark: {}", new Object[]{RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()), requestHeader.toString(), request.getRemark()});
                        return null;
                    }
                    case 8: {
                        LOGGER.warn("check producer[{}] transaction state, the producer commit the message.RequestHeader: {} Remark: {}", new Object[]{RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()), requestHeader.toString(), request.getRemark()});
                        break block26;
                    }
                    case 12: {
                        LOGGER.warn("check producer[{}] transaction state, the producer rollback the message.RequestHeader: {} Remark: {}", new Object[]{RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()), requestHeader.toString(), request.getRemark()});
                        break block26;
                    }
                    default: {
                        return null;
                    }
                }
            }
            switch (requestHeader.getCommitOrRollback()) {
                case 0: {
                    LOGGER.warn("the producer[{}] end transaction in sending message,  and it's pending status.RequestHeader: {} Remark: {}", new Object[]{RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()), requestHeader.toString(), request.getRemark()});
                    return null;
                }
                case 8: {
                    break;
                }
                case 12: {
                    LOGGER.warn("the producer[{}] end transaction in sending message, rollback the message.RequestHeader: {} Remark: {}", new Object[]{RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()), requestHeader.toString(), request.getRemark()});
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        MessageExt msgExt = this.brokerController.getMessageStore().lookMessageByOffset(requestHeader.getCommitLogOffset().longValue());
        if (msgExt != null) {
            MessageStore messageStore;
            PutMessageResult putMessageResult;
            String pgroupRead = msgExt.getProperty("PGROUP");
            if (!pgroupRead.equals(requestHeader.getProducerGroup())) {
                response.setCode(1);
                response.setRemark("the producer group wrong");
                return response;
            }
            if (msgExt.getQueueOffset() != requestHeader.getTranStateTableOffset().longValue()) {
                response.setCode(1);
                response.setRemark("the transaction state table offset wrong");
                return response;
            }
            if (msgExt.getCommitLogOffset() != requestHeader.getCommitLogOffset().longValue()) {
                response.setCode(1);
                response.setRemark("the commit log offset wrong");
                return response;
            }
            MessageExtBrokerInner msgInner = this.endMessageTransaction(msgExt);
            msgInner.setSysFlag(MessageSysFlag.resetTransactionValue((int)msgInner.getSysFlag(), (int)requestHeader.getCommitOrRollback()));
            msgInner.setQueueOffset(requestHeader.getTranStateTableOffset().longValue());
            msgInner.setPreparedTransactionOffset(requestHeader.getCommitLogOffset().longValue());
            msgInner.setStoreTimestamp(msgExt.getStoreTimestamp());
            if (12 == requestHeader.getCommitOrRollback()) {
                msgInner.setBody(null);
            }
            if ((putMessageResult = (messageStore = this.brokerController.getMessageStore()).putMessage(msgInner)) != null) {
                switch (putMessageResult.getPutMessageStatus()) {
                    case PUT_OK: 
                    case FLUSH_DISK_TIMEOUT: 
                    case FLUSH_SLAVE_TIMEOUT: 
                    case SLAVE_NOT_AVAILABLE: {
                        response.setCode(0);
                        response.setRemark(null);
                        break;
                    }
                    case CREATE_MAPEDFILE_FAILED: {
                        response.setCode(1);
                        response.setRemark("create maped file failed.");
                        break;
                    }
                    case MESSAGE_ILLEGAL: 
                    case PROPERTIES_SIZE_EXCEEDED: {
                        response.setCode(13);
                        response.setRemark("the message is illegal, maybe msg body or properties length not matched. msg body length limit 128k, msg properties length limit 32k.");
                        break;
                    }
                    case SERVICE_NOT_AVAILABLE: {
                        response.setCode(14);
                        response.setRemark("service not available now.");
                        break;
                    }
                    case OS_PAGECACHE_BUSY: {
                        response.setCode(1);
                        response.setRemark("OS page cache busy, please try another machine");
                        break;
                    }
                    case UNKNOWN_ERROR: {
                        response.setCode(1);
                        response.setRemark("UNKNOWN_ERROR");
                        break;
                    }
                    default: {
                        response.setCode(1);
                        response.setRemark("UNKNOWN_ERROR DEFAULT");
                    }
                }
                return response;
            }
        } else {
            response.setCode(1);
            response.setRemark("find prepared transaction message failed");
            return response;
        }
        response.setCode(1);
        response.setRemark("store putMessage return null");
        return response;
    }

    public boolean rejectRequest() {
        return false;
    }

    private MessageExtBrokerInner endMessageTransaction(MessageExt msgExt) {
        MessageExtBrokerInner msgInner = new MessageExtBrokerInner();
        msgInner.setBody(msgExt.getBody());
        msgInner.setFlag(msgExt.getFlag());
        MessageAccessor.setProperties((Message)msgInner, (Map)msgExt.getProperties());
        TopicFilterType topicFilterType = (msgInner.getSysFlag() & 2) == 2 ? TopicFilterType.MULTI_TAG : TopicFilterType.SINGLE_TAG;
        long tagsCodeValue = MessageExtBrokerInner.tagsString2tagsCode((TopicFilterType)topicFilterType, (String)msgInner.getTags());
        msgInner.setTagsCode(tagsCodeValue);
        msgInner.setPropertiesString(MessageDecoder.messageProperties2String((Map)msgExt.getProperties()));
        msgInner.setSysFlag(msgExt.getSysFlag());
        msgInner.setBornTimestamp(msgExt.getBornTimestamp());
        msgInner.setBornHost(msgExt.getBornHost());
        msgInner.setStoreHost(msgExt.getStoreHost());
        msgInner.setReconsumeTimes(msgExt.getReconsumeTimes());
        msgInner.setWaitStoreMsgOK(false);
        MessageAccessor.clearProperty((Message)msgInner, (String)"DELAY");
        msgInner.setTopic(msgExt.getTopic());
        msgInner.setQueueId(msgExt.getQueueId());
        return msgInner;
    }
}

