/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.offset;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.BrokerPathConfigHelper;
import org.apache.rocketmq.common.ConfigManager;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.remoting.protocol.RemotingSerializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerOffsetManager
extends ConfigManager {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqBroker");
    private static final String TOPIC_GROUP_SEPARATOR = "@";
    private ConcurrentHashMap<String, ConcurrentHashMap<Integer, Long>> offsetTable = new ConcurrentHashMap(512);
    private transient BrokerController brokerController;

    public ConsumerOffsetManager() {
    }

    public ConsumerOffsetManager(BrokerController brokerController) {
        this.brokerController = brokerController;
    }

    public void scanUnsubscribedTopic() {
        Iterator<Map.Entry<String, ConcurrentHashMap<Integer, Long>>> it = this.offsetTable.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, ConcurrentHashMap<Integer, Long>> next = it.next();
            String topicAtGroup = next.getKey();
            String[] arrays = topicAtGroup.split(TOPIC_GROUP_SEPARATOR);
            if (arrays.length != 2) continue;
            String topic = arrays[0];
            String group = arrays[1];
            if (null != this.brokerController.getConsumerManager().findSubscriptionData(group, topic) || !this.offsetBehindMuchThanData(topic, next.getValue())) continue;
            it.remove();
            log.warn("remove topic offset, {}", (Object)topicAtGroup);
        }
    }

    private boolean offsetBehindMuchThanData(String topic, ConcurrentHashMap<Integer, Long> table) {
        boolean result;
        Iterator<Map.Entry<Integer, Long>> it = table.entrySet().iterator();
        boolean bl = result = !table.isEmpty();
        while (it.hasNext() && result) {
            Map.Entry<Integer, Long> next = it.next();
            long minOffsetInStore = this.brokerController.getMessageStore().getMinOffsetInQuque(topic, next.getKey().intValue());
            long offsetInPersist = next.getValue();
            result = offsetInPersist <= minOffsetInStore;
        }
        return result;
    }

    public Set<String> whichTopicByConsumer(String group) {
        HashSet<String> topics = new HashSet<String>();
        for (Map.Entry<String, ConcurrentHashMap<Integer, Long>> next : this.offsetTable.entrySet()) {
            String topicAtGroup = next.getKey();
            String[] arrays = topicAtGroup.split(TOPIC_GROUP_SEPARATOR);
            if (arrays.length != 2 || !group.equals(arrays[1])) continue;
            topics.add(arrays[0]);
        }
        return topics;
    }

    public Set<String> whichGroupByTopic(String topic) {
        HashSet<String> groups = new HashSet<String>();
        for (Map.Entry<String, ConcurrentHashMap<Integer, Long>> next : this.offsetTable.entrySet()) {
            String topicAtGroup = next.getKey();
            String[] arrays = topicAtGroup.split(TOPIC_GROUP_SEPARATOR);
            if (arrays.length != 2 || !topic.equals(arrays[0])) continue;
            groups.add(arrays[1]);
        }
        return groups;
    }

    public void commitOffset(String clientHost, String group, String topic, int queueId, long offset) {
        String key = topic + TOPIC_GROUP_SEPARATOR + group;
        this.commitOffset(clientHost, key, queueId, offset);
    }

    private void commitOffset(String clientHost, String key, int queueId, long offset) {
        ConcurrentHashMap<Integer, Long> map = this.offsetTable.get(key);
        if (null == map) {
            map = new ConcurrentHashMap(32);
            map.put(queueId, offset);
            this.offsetTable.put(key, map);
        } else {
            Long storeOffset = map.put(queueId, offset);
            if (storeOffset != null && offset < storeOffset) {
                log.warn("[NOTIFYME]update consumer offset less than store. clientHost={}, key={}, queueId={}, requestOffset={}, storeOffset={}", new Object[]{clientHost, key, queueId, offset, storeOffset});
            }
        }
    }

    public long queryOffset(String group, String topic, int queueId) {
        Long offset;
        String key = topic + TOPIC_GROUP_SEPARATOR + group;
        ConcurrentHashMap<Integer, Long> map = this.offsetTable.get(key);
        if (null != map && (offset = map.get(queueId)) != null) {
            return offset;
        }
        return -1L;
    }

    public String encode() {
        return this.encode(false);
    }

    public String configFilePath() {
        return BrokerPathConfigHelper.getConsumerOffsetPath(this.brokerController.getMessageStoreConfig().getStorePathRootDir());
    }

    public void decode(String jsonString) {
        ConsumerOffsetManager obj;
        if (jsonString != null && (obj = (ConsumerOffsetManager)((Object)RemotingSerializable.fromJson((String)jsonString, ConsumerOffsetManager.class))) != null) {
            this.offsetTable = obj.offsetTable;
        }
    }

    public String encode(boolean prettyFormat) {
        return RemotingSerializable.toJson((Object)((Object)this), (boolean)prettyFormat);
    }

    public ConcurrentHashMap<String, ConcurrentHashMap<Integer, Long>> getOffsetTable() {
        return this.offsetTable;
    }

    public void setOffsetTable(ConcurrentHashMap<String, ConcurrentHashMap<Integer, Long>> offsetTable) {
        this.offsetTable = offsetTable;
    }

    public Map<Integer, Long> queryMinOffsetInAllGroup(String topic, String filterGroups) {
        HashMap<Integer, Long> queueMinOffset = new HashMap<Integer, Long>();
        Set topicGroups = this.offsetTable.keySet();
        if (!UtilAll.isBlank((String)filterGroups)) {
            for (String group : filterGroups.split(",")) {
                Iterator it = topicGroups.iterator();
                while (it.hasNext()) {
                    if (!group.equals(((String)it.next()).split(TOPIC_GROUP_SEPARATOR)[1])) continue;
                    it.remove();
                }
            }
        }
        for (Map.Entry<String, ConcurrentHashMap<Integer, Long>> offSetEntry : this.offsetTable.entrySet()) {
            String topicGroup = offSetEntry.getKey();
            String[] topicGroupArr = topicGroup.split(TOPIC_GROUP_SEPARATOR);
            if (!topic.equals(topicGroupArr[0])) continue;
            for (Map.Entry<Integer, Long> entry : offSetEntry.getValue().entrySet()) {
                long minOffset = this.brokerController.getMessageStore().getMinOffsetInQuque(topic, entry.getKey().intValue());
                if (entry.getValue() < minOffset) continue;
                Long offset = (Long)queueMinOffset.get(entry.getKey());
                if (offset == null) {
                    queueMinOffset.put(entry.getKey(), Math.min(Long.MAX_VALUE, entry.getValue()));
                    continue;
                }
                queueMinOffset.put(entry.getKey(), Math.min(entry.getValue(), offset));
            }
        }
        return queueMinOffset;
    }

    public Map<Integer, Long> queryOffset(String group, String topic) {
        String key = topic + TOPIC_GROUP_SEPARATOR + group;
        return this.offsetTable.get(key);
    }

    public void cloneOffset(String srcGroup, String destGroup, String topic) {
        ConcurrentHashMap<Integer, Long> offsets = this.offsetTable.get(topic + TOPIC_GROUP_SEPARATOR + srcGroup);
        if (offsets != null) {
            this.offsetTable.put(topic + TOPIC_GROUP_SEPARATOR + destGroup, new ConcurrentHashMap<Integer, Long>(offsets));
        }
    }
}

