/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.latency;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.latency.FutureTaskExt;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.remoting.netty.RequestTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerFastFailure {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqBroker");
    private final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new ThreadFactoryImpl("BrokerFastFailureScheduledThread"));
    private final BrokerController brokerController;

    public BrokerFastFailure(BrokerController brokerController) {
        this.brokerController = brokerController;
    }

    public static RequestTask castRunnable(Runnable runnable) {
        try {
            FutureTaskExt object = (FutureTaskExt)runnable;
            return (RequestTask)object.getRunnable();
        }
        catch (Throwable e) {
            log.error(String.format("castRunnable exception, %s", runnable.getClass().getName()), e);
            return null;
        }
    }

    public void start() {
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                BrokerFastFailure.this.cleanExpiredRequest();
            }
        }, 1000L, 10L, TimeUnit.MILLISECONDS);
    }

    private void cleanExpiredRequest() {
        RequestTask rt;
        Runnable runnable;
        while (this.brokerController.getMessageStore().isOSPageCacheBusy()) {
            try {
                if (this.brokerController.getSendThreadPoolQueue().isEmpty() || null == (runnable = this.brokerController.getSendThreadPoolQueue().poll(0L, TimeUnit.SECONDS))) break;
                rt = BrokerFastFailure.castRunnable(runnable);
                rt.returnResponse(2, String.format("[PCBUSY_CLEAN_QUEUE]broker busy, start flow control for a while, period in queue: %sms, size of queue: %d", System.currentTimeMillis() - rt.getCreateTimestamp(), this.brokerController.getSendThreadPoolQueue().size()));
            }
            catch (Throwable ignored) {}
        }
        while (true) {
            try {
                long behind;
                while (!this.brokerController.getSendThreadPoolQueue().isEmpty() && null != (runnable = (Runnable)this.brokerController.getSendThreadPoolQueue().peek()) && (rt = BrokerFastFailure.castRunnable(runnable)) != null && !rt.isStopRun() && (behind = System.currentTimeMillis() - rt.getCreateTimestamp()) >= this.brokerController.getBrokerConfig().getWaitTimeMillsInSendQueue()) {
                    if (!this.brokerController.getSendThreadPoolQueue().remove(runnable)) continue;
                    rt.setStopRun(true);
                    rt.returnResponse(2, String.format("[TIMEOUT_CLEAN_QUEUE]broker busy, start flow control for a while, period in queue: %sms, size of queue: %d", behind, this.brokerController.getSendThreadPoolQueue().size()));
                }
            }
            catch (Throwable throwable) {
                continue;
            }
            break;
        }
    }

    public void shutdown() {
        this.scheduledExecutorService.shutdown();
    }
}

