/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.acl.common;

import com.alibaba.fastjson.JSONObject;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Map;
import java.util.SortedMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.acl.common.AclClientRPCHook;
import org.apache.rocketmq.acl.common.AclException;
import org.apache.rocketmq.acl.common.AclSigner;
import org.apache.rocketmq.acl.common.SessionCredentials;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.yaml.snakeyaml.Yaml;

public class AclUtils {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqCommon");

    public static byte[] combineRequestContent(RemotingCommand request, SortedMap<String, String> fieldsMap) {
        try {
            StringBuilder sb = new StringBuilder("");
            for (Map.Entry<String, String> entry : fieldsMap.entrySet()) {
                if ("Signature".equals(entry.getKey())) continue;
                sb.append(entry.getValue());
            }
            return AclUtils.combineBytes(sb.toString().getBytes(SessionCredentials.CHARSET), request.getBody());
        }
        catch (Exception e) {
            throw new RuntimeException("Incompatible exception.", e);
        }
    }

    public static byte[] combineBytes(byte[] b1, byte[] b2) {
        if (b1 == null || b1.length == 0) {
            return b2;
        }
        if (b2 == null || b2.length == 0) {
            return b1;
        }
        byte[] total = new byte[b1.length + b2.length];
        System.arraycopy(b1, 0, total, 0, b1.length);
        System.arraycopy(b2, 0, total, b1.length, b2.length);
        return total;
    }

    public static String calSignature(byte[] data, String secretKey) {
        String signature = AclSigner.calSignature(data, secretKey);
        return signature;
    }

    public static void IPv6AddressCheck(String netAddress) {
        if (AclUtils.isAsterisk(netAddress) || AclUtils.isMinus(netAddress)) {
            int asterisk = netAddress.indexOf("*");
            int minus = netAddress.indexOf("-");
            if (asterisk > -1 && asterisk != netAddress.length() - 1) {
                throw new AclException(String.format("NetAddress examine scope Exception netAddress is %s", netAddress));
            }
            if (minus > -1 && (asterisk == -1 ? minus <= netAddress.lastIndexOf(":") : minus <= netAddress.lastIndexOf(":", netAddress.lastIndexOf(":") - 1))) {
                throw new AclException(String.format("NetAddress examine scope Exception netAddress is %s", netAddress));
            }
        }
    }

    public static String v6ipProcess(String netAddress) {
        String subAddress;
        int part;
        boolean isAsterisk = AclUtils.isAsterisk(netAddress);
        boolean isMinus = AclUtils.isMinus(netAddress);
        if (isAsterisk && isMinus) {
            part = 6;
            int lastColon = netAddress.lastIndexOf(58);
            int secondLastColon = netAddress.substring(0, lastColon).lastIndexOf(58);
            subAddress = netAddress.substring(0, secondLastColon);
        } else if (!isAsterisk && !isMinus) {
            part = 8;
            subAddress = netAddress;
        } else {
            part = 7;
            subAddress = netAddress.substring(0, netAddress.lastIndexOf(58));
        }
        return AclUtils.expandIP(subAddress, part);
    }

    public static void verify(String netAddress, int index) {
        if (!AclUtils.isScope(netAddress, index)) {
            throw new AclException(String.format("NetAddress examine scope Exception netAddress is %s", netAddress));
        }
    }

    public static String[] getAddresses(String netAddress, String partialAddress) {
        String[] parAddStrArray = StringUtils.split((String)partialAddress.substring(1, partialAddress.length() - 1), (String)",");
        String address = netAddress.substring(0, netAddress.indexOf("{"));
        String[] addressStrArray = new String[parAddStrArray.length];
        for (int i = 0; i < parAddStrArray.length; ++i) {
            addressStrArray[i] = address + parAddStrArray[i];
        }
        return addressStrArray;
    }

    public static boolean isScope(String netAddress, int index) {
        if (AclUtils.isColon(netAddress)) {
            netAddress = AclUtils.expandIP(netAddress, 8);
            String[] strArray = StringUtils.split((String)netAddress, (String)":");
            return AclUtils.isIPv6Scope(strArray, index);
        }
        String[] strArray = StringUtils.split((String)netAddress, (String)".");
        if (strArray.length != 4) {
            return false;
        }
        return AclUtils.isScope(strArray, index);
    }

    public static boolean isScope(String[] num, int index) {
        for (int i = 0; i < index; ++i) {
            if (AclUtils.isScope(num[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isColon(String netAddress) {
        return netAddress.indexOf(58) > -1;
    }

    public static boolean isScope(String num) {
        return AclUtils.isScope(Integer.parseInt(num.trim()));
    }

    public static boolean isScope(int num) {
        return num >= 0 && num <= 255;
    }

    public static boolean isAsterisk(String asterisk) {
        return asterisk.indexOf(42) > -1;
    }

    public static boolean isComma(String colon) {
        return colon.indexOf(44) > -1;
    }

    public static boolean isMinus(String minus) {
        return minus.indexOf(45) > -1;
    }

    public static boolean isIPv6Scope(String[] num, int index) {
        for (int i = 0; i < index; ++i) {
            int value;
            try {
                value = Integer.parseInt(num[i], 16);
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (AclUtils.isIPv6Scope(value)) continue;
            return false;
        }
        return true;
    }

    public static boolean isIPv6Scope(int num) {
        int min = Integer.parseInt("0", 16);
        int max = Integer.parseInt("ffff", 16);
        return num >= min && num <= max;
    }

    public static String expandIP(String netAddress, int part) {
        int i;
        int separatorCount = StringUtils.countMatches((CharSequence)(netAddress = netAddress.toUpperCase()), (CharSequence)":");
        int padCount = part - separatorCount;
        if (padCount > 0) {
            StringBuilder padStr = new StringBuilder(":");
            for (i = 0; i < padCount; ++i) {
                padStr.append(":");
            }
            netAddress = StringUtils.replace((String)netAddress, (String)"::", (String)padStr.toString());
        }
        String[] strArray = StringUtils.splitPreserveAllTokens((String)netAddress, (String)":");
        for (i = 0; i < strArray.length; ++i) {
            if (strArray[i].length() >= 4) continue;
            strArray[i] = StringUtils.leftPad((String)strArray[i], (int)4, (char)'0');
        }
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < strArray.length; ++i2) {
            sb.append(strArray[i2]);
            if (i2 == strArray.length - 1) continue;
            sb.append(":");
        }
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T getYamlDataObject(String path, Class<T> clazz) {
        try (FileInputStream fis = new FileInputStream(path);){
            T t = AclUtils.getYamlDataObject(fis, clazz);
            return t;
        }
        catch (FileNotFoundException ignore) {
            return null;
        }
        catch (Exception e) {
            throw new AclException(e.getMessage(), e);
        }
    }

    public static <T> T getYamlDataObject(InputStream fis, Class<T> clazz) {
        Yaml yaml = new Yaml();
        try {
            return (T)yaml.loadAs(fis, clazz);
        }
        catch (Exception e) {
            throw new AclException(e.getMessage(), e);
        }
    }

    public static boolean writeDataObject(String path, Object dataMap) {
        Yaml yaml = new Yaml();
        try (PrintWriter pw = new PrintWriter(path, "UTF-8");){
            String dumpAsMap = yaml.dumpAsMap(dataMap);
            pw.print(dumpAsMap);
            pw.flush();
        }
        catch (Exception e) {
            throw new AclException(e.getMessage(), e);
        }
        return true;
    }

    public static RPCHook getAclRPCHook(String fileName) {
        JSONObject yamlDataObject;
        try {
            yamlDataObject = AclUtils.getYamlDataObject(fileName, JSONObject.class);
        }
        catch (Exception e) {
            log.error("Convert yaml file to data object error, ", (Throwable)e);
            return null;
        }
        return AclUtils.buildRpcHook(yamlDataObject);
    }

    public static RPCHook getAclRPCHook(InputStream inputStream) {
        JSONObject yamlDataObject = null;
        try {
            yamlDataObject = AclUtils.getYamlDataObject(inputStream, JSONObject.class);
        }
        catch (Exception e) {
            log.error("Convert yaml file to data object error, ", (Throwable)e);
            return null;
        }
        return AclUtils.buildRpcHook(yamlDataObject);
    }

    private static RPCHook buildRpcHook(JSONObject yamlDataObject) {
        if (yamlDataObject == null || yamlDataObject.isEmpty()) {
            log.warn("Failed to parse configuration to enable ACL.");
            return null;
        }
        String accessKey = yamlDataObject.getString("accessKey");
        String secretKey = yamlDataObject.getString("secretKey");
        if (StringUtils.isBlank((CharSequence)accessKey) || StringUtils.isBlank((CharSequence)secretKey)) {
            log.warn("Failed to enable ACL. Either AccessKey or secretKey is blank");
            return null;
        }
        return new AclClientRPCHook(new SessionCredentials(accessKey, secretKey));
    }
}

