/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.acl.plain;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.apache.rocketmq.acl.common.AclException;
import org.apache.rocketmq.acl.common.AclUtils;
import org.apache.rocketmq.acl.plain.PlainAccessResource;
import org.apache.rocketmq.acl.plain.RemoteAddressStrategy;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;

public class RemoteAddressStrategyFactory {
    private static final InternalLogger log = InternalLoggerFactory.getLogger((String)"RocketmqCommon");
    public static final NullRemoteAddressStrategy NULL_NET_ADDRESS_STRATEGY = new NullRemoteAddressStrategy();
    public static final BlankRemoteAddressStrategy BLANK_NET_ADDRESS_STRATEGY = new BlankRemoteAddressStrategy();

    public RemoteAddressStrategy getRemoteAddressStrategy(PlainAccessResource plainAccessResource) {
        return this.getRemoteAddressStrategy(plainAccessResource.getWhiteRemoteAddress());
    }

    public RemoteAddressStrategy getRemoteAddressStrategy(String remoteAddr) {
        if (StringUtils.isBlank((CharSequence)remoteAddr)) {
            return BLANK_NET_ADDRESS_STRATEGY;
        }
        if ("*".equals(remoteAddr) || "*.*.*.*".equals(remoteAddr) || "*:*:*:*:*:*:*:*".equals(remoteAddr)) {
            return NULL_NET_ADDRESS_STRATEGY;
        }
        if (remoteAddr.endsWith("}")) {
            if (AclUtils.isColon(remoteAddr)) {
                String[] strArray = StringUtils.split((String)remoteAddr, (String)":");
                String last = strArray[strArray.length - 1];
                if (!last.startsWith("{")) {
                    throw new AclException(String.format("MultipleRemoteAddressStrategy netaddress examine scope Exception netaddress", remoteAddr));
                }
                return new MultipleRemoteAddressStrategy(AclUtils.getAddresses(remoteAddr, last));
            }
            String[] strArray = StringUtils.split((String)remoteAddr, (String)".");
            if (strArray.length < 4) {
                throw new AclException(String.format("MultipleRemoteAddressStrategy has got a/some wrong format IP(s) ", remoteAddr));
            }
            String lastStr = strArray[strArray.length - 1];
            if (!lastStr.startsWith("{")) {
                throw new AclException(String.format("MultipleRemoteAddressStrategy netaddress examine scope Exception netaddress", remoteAddr));
            }
            return new MultipleRemoteAddressStrategy(AclUtils.getAddresses(remoteAddr, lastStr));
        }
        if (AclUtils.isComma(remoteAddr)) {
            return new MultipleRemoteAddressStrategy(StringUtils.split((String)remoteAddr, (String)","));
        }
        if (AclUtils.isAsterisk(remoteAddr) || AclUtils.isMinus(remoteAddr)) {
            return new RangeRemoteAddressStrategy(remoteAddr);
        }
        return new OneRemoteAddressStrategy(remoteAddr);
    }

    public static class RangeRemoteAddressStrategy
    implements RemoteAddressStrategy {
        private String head;
        private int start;
        private int end;
        private int index;

        public RangeRemoteAddressStrategy(String remoteAddr) {
            if (AclUtils.isColon(remoteAddr)) {
                AclUtils.IPv6AddressCheck(remoteAddr);
                String[] strArray = StringUtils.split((String)remoteAddr, (String)":");
                for (int i = 1; i < strArray.length; ++i) {
                    if (!this.ipv6Analysis(strArray, i)) continue;
                    AclUtils.verify(remoteAddr, this.index - 1);
                    String preAddress = AclUtils.v6ipProcess(remoteAddr);
                    this.index = StringUtils.split((String)preAddress, (String)":").length;
                    this.head = preAddress;
                    break;
                }
            } else {
                String[] strArray = StringUtils.split((String)remoteAddr, (String)".");
                if (this.analysis(strArray, 1) || this.analysis(strArray, 2) || this.analysis(strArray, 3)) {
                    AclUtils.verify(remoteAddr, this.index - 1);
                    StringBuffer sb = new StringBuffer();
                    for (int j = 0; j < this.index; ++j) {
                        sb.append(strArray[j].trim()).append(".");
                    }
                    this.head = sb.toString();
                }
            }
        }

        private boolean analysis(String[] strArray, int index) {
            String value = strArray[index].trim();
            this.index = index;
            if ("*".equals(value)) {
                this.setValue(0, 255);
            } else if (AclUtils.isMinus(value)) {
                if (value.indexOf("-") == 0) {
                    throw new AclException(String.format("RangeRemoteAddressStrategy netaddress examine scope Exception value %s ", value));
                }
                String[] valueArray = StringUtils.split((String)value, (String)"-");
                this.start = Integer.valueOf(valueArray[0]);
                this.end = Integer.valueOf(valueArray[1]);
                if (!AclUtils.isScope(this.end) || !AclUtils.isScope(this.start) || this.start > this.end) {
                    throw new AclException(String.format("RangeRemoteAddressStrategy netaddress examine scope Exception start is %s , end is %s", this.start, this.end));
                }
            }
            return this.end > 0;
        }

        private boolean ipv6Analysis(String[] strArray, int index) {
            String value = strArray[index].trim();
            this.index = index;
            if ("*".equals(value)) {
                int min = Integer.parseInt("0", 16);
                int max = Integer.parseInt("ffff", 16);
                this.setValue(min, max);
            } else if (AclUtils.isMinus(value)) {
                if (value.indexOf("-") == 0) {
                    throw new AclException(String.format("RangeRemoteAddressStrategy netaddress examine scope Exception value %s ", value));
                }
                String[] valueArray = StringUtils.split((String)value, (String)"-");
                this.start = Integer.parseInt(valueArray[0], 16);
                this.end = Integer.parseInt(valueArray[1], 16);
                if (!AclUtils.isIPv6Scope(this.end) || !AclUtils.isIPv6Scope(this.start) || this.start > this.end) {
                    throw new AclException(String.format("RangeRemoteAddressStrategy netaddress examine scope Exception start is %s , end is %s", this.start, this.end));
                }
            }
            return this.end > 0;
        }

        private void setValue(int start, int end) {
            this.start = start;
            this.end = end;
        }

        @Override
        public boolean match(PlainAccessResource plainAccessResource) {
            String value;
            Integer address;
            String netAddress = plainAccessResource.getWhiteRemoteAddress();
            InetAddressValidator validator = InetAddressValidator.getInstance();
            return validator.isValidInet4Address(netAddress) ? netAddress.startsWith(this.head) && (address = Integer.valueOf(value = this.index == 3 ? netAddress.substring(this.head.length()) : (this.index == 2 ? netAddress.substring(this.head.length(), netAddress.lastIndexOf(46)) : netAddress.substring(this.head.length(), netAddress.lastIndexOf(46, netAddress.lastIndexOf(46) - 1))))) >= this.start && address <= this.end : validator.isValidInet6Address(netAddress) && (netAddress = AclUtils.expandIP(netAddress, 8).toUpperCase()).startsWith(this.head) && (address = Integer.valueOf(Integer.parseInt(value = netAddress.substring(5 * this.index, 5 * this.index + 4), 16))) >= this.start && address <= this.end;
        }
    }

    public static class OneRemoteAddressStrategy
    implements RemoteAddressStrategy {
        private String netaddress;

        public OneRemoteAddressStrategy(String netaddress) {
            this.netaddress = netaddress;
            InetAddressValidator validator = InetAddressValidator.getInstance();
            if (!validator.isValidInet4Address(netaddress) && !validator.isValidInet6Address(netaddress)) {
                throw new AclException(String.format("Netaddress examine Exception netaddress is %s", netaddress));
            }
        }

        @Override
        public boolean match(PlainAccessResource plainAccessResource) {
            String writeRemoteAddress = AclUtils.expandIP(plainAccessResource.getWhiteRemoteAddress(), 8).toUpperCase();
            return AclUtils.expandIP(this.netaddress, 8).toUpperCase().equals(writeRemoteAddress);
        }
    }

    public static class MultipleRemoteAddressStrategy
    implements RemoteAddressStrategy {
        private final Set<String> multipleSet = new HashSet<String>();

        public MultipleRemoteAddressStrategy(String[] strArray) {
            InetAddressValidator validator = InetAddressValidator.getInstance();
            for (String netaddress : strArray) {
                if (validator.isValidInet4Address(netaddress)) {
                    this.multipleSet.add(netaddress);
                    continue;
                }
                if (validator.isValidInet6Address(netaddress)) {
                    this.multipleSet.add(AclUtils.expandIP(netaddress, 8));
                    continue;
                }
                throw new AclException(String.format("Netaddress examine Exception netaddress is %s", netaddress));
            }
        }

        @Override
        public boolean match(PlainAccessResource plainAccessResource) {
            String whiteRemoteAddress;
            InetAddressValidator validator = InetAddressValidator.getInstance();
            if (validator.isValidInet6Address(whiteRemoteAddress = plainAccessResource.getWhiteRemoteAddress())) {
                whiteRemoteAddress = AclUtils.expandIP(whiteRemoteAddress, 8);
            }
            return this.multipleSet.contains(whiteRemoteAddress);
        }
    }

    public static class BlankRemoteAddressStrategy
    implements RemoteAddressStrategy {
        @Override
        public boolean match(PlainAccessResource plainAccessResource) {
            return false;
        }
    }

    public static class NullRemoteAddressStrategy
    implements RemoteAddressStrategy {
        @Override
        public boolean match(PlainAccessResource plainAccessResource) {
            return true;
        }
    }
}

