/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.transaction.impl.common;

import com.google.common.annotations.Beta;

@Beta
public enum TxnStatus {
    OPEN,
    COMMITTING,
    COMMITTED,
    ABORTING,
    ABORTED;


    public boolean canTransitionTo(TxnStatus newStatus) {
        TxnStatus currentStatus = this;
        switch (currentStatus) {
            case OPEN: {
                return newStatus != COMMITTED && newStatus != ABORTED;
            }
            case COMMITTING: {
                return newStatus == COMMITTING || newStatus == COMMITTED;
            }
            case COMMITTED: {
                return newStatus == COMMITTED;
            }
            case ABORTING: {
                return newStatus == ABORTING || newStatus == ABORTED;
            }
            case ABORTED: {
                return newStatus == ABORTED;
            }
        }
        throw new IllegalArgumentException("Unknown txn status : " + (Object)((Object)newStatus));
    }
}

