/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker.service;

import java.io.IOException;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.authentication.AuthenticationService;
import org.apache.pulsar.broker.authorization.AuthorizationService;
import org.apache.pulsar.broker.cache.ConfigurationCacheService;
import org.apache.pulsar.broker.resources.PulsarResources;
import org.apache.pulsar.common.conf.InternalConfigurationData;
import org.apache.pulsar.common.nar.NarClassLoader;
import org.apache.pulsar.common.util.SimpleTextOutputStream;
import org.apache.pulsar.functions.worker.ErrorNotifier;
import org.apache.pulsar.functions.worker.WorkerConfig;
import org.apache.pulsar.functions.worker.WorkerService;
import org.apache.pulsar.functions.worker.service.api.Functions;
import org.apache.pulsar.functions.worker.service.api.FunctionsV2;
import org.apache.pulsar.functions.worker.service.api.Sinks;
import org.apache.pulsar.functions.worker.service.api.Sources;
import org.apache.pulsar.functions.worker.service.api.Workers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerServiceWithClassLoader
implements WorkerService {
    private static final Logger log = LoggerFactory.getLogger(WorkerServiceWithClassLoader.class);
    private final WorkerService service;
    private final NarClassLoader classLoader;

    @Override
    public WorkerConfig getWorkerConfig() {
        return this.service.getWorkerConfig();
    }

    @Override
    public void initAsStandalone(WorkerConfig workerConfig) throws Exception {
        this.service.initAsStandalone(workerConfig);
    }

    @Override
    public void initInBroker(ServiceConfiguration brokerConfig, WorkerConfig workerConfig, PulsarResources pulsarResources, ConfigurationCacheService configurationCacheService, InternalConfigurationData internalConf) throws Exception {
        this.service.initInBroker(brokerConfig, workerConfig, pulsarResources, configurationCacheService, internalConf);
    }

    @Override
    public void start(AuthenticationService authenticationService, AuthorizationService authorizationService, ErrorNotifier errorNotifier) throws Exception {
        this.service.start(authenticationService, authorizationService, errorNotifier);
    }

    @Override
    public void stop() {
        this.service.stop();
        try {
            this.classLoader.close();
        }
        catch (IOException e) {
            log.warn("Failed to close the worker service class loader", (Throwable)e);
        }
    }

    @Override
    public boolean isInitialized() {
        return this.service.isInitialized();
    }

    @Override
    public Functions<? extends WorkerService> getFunctions() {
        return this.service.getFunctions();
    }

    @Override
    public FunctionsV2<? extends WorkerService> getFunctionsV2() {
        return this.service.getFunctionsV2();
    }

    @Override
    public Sinks<? extends WorkerService> getSinks() {
        return this.service.getSinks();
    }

    @Override
    public Sources<? extends WorkerService> getSources() {
        return this.service.getSources();
    }

    @Override
    public Workers<? extends WorkerService> getWorkers() {
        return this.service.getWorkers();
    }

    @Override
    public void generateFunctionsStats(SimpleTextOutputStream out) {
        this.service.generateFunctionsStats(out);
    }

    public WorkerService getService() {
        return this.service;
    }

    public NarClassLoader getClassLoader() {
        return this.classLoader;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkerServiceWithClassLoader)) {
            return false;
        }
        WorkerServiceWithClassLoader other = (WorkerServiceWithClassLoader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        WorkerService this$service = this.getService();
        WorkerService other$service = other.getService();
        if (this$service == null ? other$service != null : !this$service.equals(other$service)) {
            return false;
        }
        NarClassLoader this$classLoader = this.getClassLoader();
        NarClassLoader other$classLoader = other.getClassLoader();
        return !(this$classLoader == null ? other$classLoader != null : !this$classLoader.equals(other$classLoader));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WorkerServiceWithClassLoader;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        WorkerService $service = this.getService();
        result = result * 59 + ($service == null ? 43 : $service.hashCode());
        NarClassLoader $classLoader = this.getClassLoader();
        result = result * 59 + ($classLoader == null ? 43 : $classLoader.hashCode());
        return result;
    }

    public String toString() {
        return "WorkerServiceWithClassLoader(service=" + this.getService() + ", classLoader=" + this.getClassLoader() + ")";
    }

    public WorkerServiceWithClassLoader(WorkerService service, NarClassLoader classLoader) {
        this.service = service;
        this.classLoader = classLoader;
    }
}

