/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.yahoo.sketches;

import java.nio.charset.StandardCharsets;
import org.apache.pulsar.shade.com.yahoo.memory.Memory;
import org.apache.pulsar.shade.com.yahoo.memory.NativeMemory;
import org.apache.pulsar.shade.com.yahoo.memory.UnsafeUtil;
import org.apache.pulsar.shade.com.yahoo.sketches.ArrayOfItemsSerDe;

public class ArrayOfStringsSerDe
extends ArrayOfItemsSerDe<String> {
    public byte[] serializeToByteArray(String[] items) {
        int length = 0;
        byte[][] itemsBytes = new byte[items.length][];
        for (int i = 0; i < items.length; ++i) {
            itemsBytes[i] = items[i].getBytes(StandardCharsets.UTF_8);
            length += itemsBytes[i].length + 4;
        }
        byte[] bytes = new byte[length];
        NativeMemory mem = new NativeMemory(bytes);
        long offsetBytes = 0L;
        for (int i = 0; i < items.length; ++i) {
            mem.putInt(offsetBytes, itemsBytes[i].length);
            mem.putByteArray(offsetBytes += 4L, itemsBytes[i], 0, itemsBytes[i].length);
            offsetBytes += (long)itemsBytes[i].length;
        }
        return bytes;
    }

    public String[] deserializeFromMemory(Memory mem, int numItems) {
        String[] array = new String[numItems];
        long offsetBytes = 0L;
        for (int i = 0; i < numItems; ++i) {
            UnsafeUtil.checkBounds(offsetBytes, 4L, mem.getCapacity());
            int strLength = mem.getInt(offsetBytes);
            byte[] bytes = new byte[strLength];
            UnsafeUtil.checkBounds(offsetBytes += 4L, strLength, mem.getCapacity());
            mem.getByteArray(offsetBytes, bytes, 0, strLength);
            offsetBytes += (long)strLength;
            array[i] = new String(bytes, StandardCharsets.UTF_8);
        }
        return array;
    }
}

