/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.conf;

import java.io.Serializable;
import java.time.Clock;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.ServiceUrlProvider;
import org.apache.pulsar.client.impl.auth.AuthenticationDisabled;
import org.apache.pulsar.shade.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.pulsar.shade.com.google.common.collect.Sets;

public class ClientConfigurationData
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private String serviceUrl;
    @JsonIgnore
    private transient ServiceUrlProvider serviceUrlProvider;
    @JsonIgnore
    private transient Authentication authentication = new AuthenticationDisabled();
    private String authPluginClassName;
    private String authParams;
    private long operationTimeoutMs = 30000L;
    private long statsIntervalSeconds = 60L;
    private int numIoThreads = 1;
    private int numListenerThreads = 1;
    private int connectionsPerBroker = 1;
    private boolean useTcpNoDelay = true;
    private boolean useTls = false;
    private String tlsTrustCertsFilePath = "";
    private boolean tlsAllowInsecureConnection = false;
    private boolean tlsHostnameVerificationEnable = false;
    private int concurrentLookupRequest = 5000;
    private int maxLookupRequest = 50000;
    private int maxNumberOfRejectedRequestPerConnection = 50;
    private int keepAliveIntervalSeconds = 30;
    private int connectionTimeoutMs = 10000;
    private int requestTimeoutMs = 60000;
    private long initialBackoffIntervalNanos = TimeUnit.MILLISECONDS.toNanos(100L);
    private long maxBackoffIntervalNanos = TimeUnit.SECONDS.toNanos(60L);
    private boolean useKeyStoreTls = false;
    private String sslProvider = null;
    private String tlsTrustStoreType = "JKS";
    private String tlsTrustStorePath = null;
    private String tlsTrustStorePassword = null;
    private Set<String> tlsCiphers = Sets.newTreeSet();
    private Set<String> tlsProtocols = Sets.newTreeSet();
    @JsonIgnore
    private Clock clock = Clock.systemDefaultZone();

    public Authentication getAuthentication() {
        if (this.authentication == null) {
            this.authentication = new AuthenticationDisabled();
        }
        return this.authentication;
    }

    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    public boolean isUseTls() {
        if (this.useTls) {
            return true;
        }
        if (this.getServiceUrl() != null && (this.getServiceUrl().startsWith("pulsar+ssl") || this.getServiceUrl().startsWith("https"))) {
            this.useTls = true;
            return true;
        }
        return false;
    }

    public ClientConfigurationData clone() {
        try {
            return (ClientConfigurationData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Failed to clone ClientConfigurationData");
        }
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public ServiceUrlProvider getServiceUrlProvider() {
        return this.serviceUrlProvider;
    }

    public String getAuthPluginClassName() {
        return this.authPluginClassName;
    }

    public String getAuthParams() {
        return this.authParams;
    }

    public long getOperationTimeoutMs() {
        return this.operationTimeoutMs;
    }

    public long getStatsIntervalSeconds() {
        return this.statsIntervalSeconds;
    }

    public int getNumIoThreads() {
        return this.numIoThreads;
    }

    public int getNumListenerThreads() {
        return this.numListenerThreads;
    }

    public int getConnectionsPerBroker() {
        return this.connectionsPerBroker;
    }

    public boolean isUseTcpNoDelay() {
        return this.useTcpNoDelay;
    }

    public String getTlsTrustCertsFilePath() {
        return this.tlsTrustCertsFilePath;
    }

    public boolean isTlsAllowInsecureConnection() {
        return this.tlsAllowInsecureConnection;
    }

    public boolean isTlsHostnameVerificationEnable() {
        return this.tlsHostnameVerificationEnable;
    }

    public int getConcurrentLookupRequest() {
        return this.concurrentLookupRequest;
    }

    public int getMaxLookupRequest() {
        return this.maxLookupRequest;
    }

    public int getMaxNumberOfRejectedRequestPerConnection() {
        return this.maxNumberOfRejectedRequestPerConnection;
    }

    public int getKeepAliveIntervalSeconds() {
        return this.keepAliveIntervalSeconds;
    }

    public int getConnectionTimeoutMs() {
        return this.connectionTimeoutMs;
    }

    public int getRequestTimeoutMs() {
        return this.requestTimeoutMs;
    }

    public long getInitialBackoffIntervalNanos() {
        return this.initialBackoffIntervalNanos;
    }

    public long getMaxBackoffIntervalNanos() {
        return this.maxBackoffIntervalNanos;
    }

    public boolean isUseKeyStoreTls() {
        return this.useKeyStoreTls;
    }

    public String getSslProvider() {
        return this.sslProvider;
    }

    public String getTlsTrustStoreType() {
        return this.tlsTrustStoreType;
    }

    public String getTlsTrustStorePath() {
        return this.tlsTrustStorePath;
    }

    public String getTlsTrustStorePassword() {
        return this.tlsTrustStorePassword;
    }

    public Set<String> getTlsCiphers() {
        return this.tlsCiphers;
    }

    public Set<String> getTlsProtocols() {
        return this.tlsProtocols;
    }

    public Clock getClock() {
        return this.clock;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public void setServiceUrlProvider(ServiceUrlProvider serviceUrlProvider) {
        this.serviceUrlProvider = serviceUrlProvider;
    }

    public void setAuthPluginClassName(String authPluginClassName) {
        this.authPluginClassName = authPluginClassName;
    }

    public void setAuthParams(String authParams) {
        this.authParams = authParams;
    }

    public void setOperationTimeoutMs(long operationTimeoutMs) {
        this.operationTimeoutMs = operationTimeoutMs;
    }

    public void setStatsIntervalSeconds(long statsIntervalSeconds) {
        this.statsIntervalSeconds = statsIntervalSeconds;
    }

    public void setNumIoThreads(int numIoThreads) {
        this.numIoThreads = numIoThreads;
    }

    public void setNumListenerThreads(int numListenerThreads) {
        this.numListenerThreads = numListenerThreads;
    }

    public void setConnectionsPerBroker(int connectionsPerBroker) {
        this.connectionsPerBroker = connectionsPerBroker;
    }

    public void setUseTcpNoDelay(boolean useTcpNoDelay) {
        this.useTcpNoDelay = useTcpNoDelay;
    }

    public void setUseTls(boolean useTls) {
        this.useTls = useTls;
    }

    public void setTlsTrustCertsFilePath(String tlsTrustCertsFilePath) {
        this.tlsTrustCertsFilePath = tlsTrustCertsFilePath;
    }

    public void setTlsAllowInsecureConnection(boolean tlsAllowInsecureConnection) {
        this.tlsAllowInsecureConnection = tlsAllowInsecureConnection;
    }

    public void setTlsHostnameVerificationEnable(boolean tlsHostnameVerificationEnable) {
        this.tlsHostnameVerificationEnable = tlsHostnameVerificationEnable;
    }

    public void setConcurrentLookupRequest(int concurrentLookupRequest) {
        this.concurrentLookupRequest = concurrentLookupRequest;
    }

    public void setMaxLookupRequest(int maxLookupRequest) {
        this.maxLookupRequest = maxLookupRequest;
    }

    public void setMaxNumberOfRejectedRequestPerConnection(int maxNumberOfRejectedRequestPerConnection) {
        this.maxNumberOfRejectedRequestPerConnection = maxNumberOfRejectedRequestPerConnection;
    }

    public void setKeepAliveIntervalSeconds(int keepAliveIntervalSeconds) {
        this.keepAliveIntervalSeconds = keepAliveIntervalSeconds;
    }

    public void setConnectionTimeoutMs(int connectionTimeoutMs) {
        this.connectionTimeoutMs = connectionTimeoutMs;
    }

    public void setRequestTimeoutMs(int requestTimeoutMs) {
        this.requestTimeoutMs = requestTimeoutMs;
    }

    public void setInitialBackoffIntervalNanos(long initialBackoffIntervalNanos) {
        this.initialBackoffIntervalNanos = initialBackoffIntervalNanos;
    }

    public void setMaxBackoffIntervalNanos(long maxBackoffIntervalNanos) {
        this.maxBackoffIntervalNanos = maxBackoffIntervalNanos;
    }

    public void setUseKeyStoreTls(boolean useKeyStoreTls) {
        this.useKeyStoreTls = useKeyStoreTls;
    }

    public void setSslProvider(String sslProvider) {
        this.sslProvider = sslProvider;
    }

    public void setTlsTrustStoreType(String tlsTrustStoreType) {
        this.tlsTrustStoreType = tlsTrustStoreType;
    }

    public void setTlsTrustStorePath(String tlsTrustStorePath) {
        this.tlsTrustStorePath = tlsTrustStorePath;
    }

    public void setTlsTrustStorePassword(String tlsTrustStorePassword) {
        this.tlsTrustStorePassword = tlsTrustStorePassword;
    }

    public void setTlsCiphers(Set<String> tlsCiphers) {
        this.tlsCiphers = tlsCiphers;
    }

    public void setTlsProtocols(Set<String> tlsProtocols) {
        this.tlsProtocols = tlsProtocols;
    }

    public void setClock(Clock clock) {
        this.clock = clock;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientConfigurationData)) {
            return false;
        }
        ClientConfigurationData other = (ClientConfigurationData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$serviceUrl = this.getServiceUrl();
        String other$serviceUrl = other.getServiceUrl();
        if (this$serviceUrl == null ? other$serviceUrl != null : !this$serviceUrl.equals(other$serviceUrl)) {
            return false;
        }
        String this$authPluginClassName = this.getAuthPluginClassName();
        String other$authPluginClassName = other.getAuthPluginClassName();
        if (this$authPluginClassName == null ? other$authPluginClassName != null : !this$authPluginClassName.equals(other$authPluginClassName)) {
            return false;
        }
        String this$authParams = this.getAuthParams();
        String other$authParams = other.getAuthParams();
        if (this$authParams == null ? other$authParams != null : !this$authParams.equals(other$authParams)) {
            return false;
        }
        if (this.getOperationTimeoutMs() != other.getOperationTimeoutMs()) {
            return false;
        }
        if (this.getStatsIntervalSeconds() != other.getStatsIntervalSeconds()) {
            return false;
        }
        if (this.getNumIoThreads() != other.getNumIoThreads()) {
            return false;
        }
        if (this.getNumListenerThreads() != other.getNumListenerThreads()) {
            return false;
        }
        if (this.getConnectionsPerBroker() != other.getConnectionsPerBroker()) {
            return false;
        }
        if (this.isUseTcpNoDelay() != other.isUseTcpNoDelay()) {
            return false;
        }
        if (this.isUseTls() != other.isUseTls()) {
            return false;
        }
        String this$tlsTrustCertsFilePath = this.getTlsTrustCertsFilePath();
        String other$tlsTrustCertsFilePath = other.getTlsTrustCertsFilePath();
        if (this$tlsTrustCertsFilePath == null ? other$tlsTrustCertsFilePath != null : !this$tlsTrustCertsFilePath.equals(other$tlsTrustCertsFilePath)) {
            return false;
        }
        if (this.isTlsAllowInsecureConnection() != other.isTlsAllowInsecureConnection()) {
            return false;
        }
        if (this.isTlsHostnameVerificationEnable() != other.isTlsHostnameVerificationEnable()) {
            return false;
        }
        if (this.getConcurrentLookupRequest() != other.getConcurrentLookupRequest()) {
            return false;
        }
        if (this.getMaxLookupRequest() != other.getMaxLookupRequest()) {
            return false;
        }
        if (this.getMaxNumberOfRejectedRequestPerConnection() != other.getMaxNumberOfRejectedRequestPerConnection()) {
            return false;
        }
        if (this.getKeepAliveIntervalSeconds() != other.getKeepAliveIntervalSeconds()) {
            return false;
        }
        if (this.getConnectionTimeoutMs() != other.getConnectionTimeoutMs()) {
            return false;
        }
        if (this.getRequestTimeoutMs() != other.getRequestTimeoutMs()) {
            return false;
        }
        if (this.getInitialBackoffIntervalNanos() != other.getInitialBackoffIntervalNanos()) {
            return false;
        }
        if (this.getMaxBackoffIntervalNanos() != other.getMaxBackoffIntervalNanos()) {
            return false;
        }
        if (this.isUseKeyStoreTls() != other.isUseKeyStoreTls()) {
            return false;
        }
        String this$sslProvider = this.getSslProvider();
        String other$sslProvider = other.getSslProvider();
        if (this$sslProvider == null ? other$sslProvider != null : !this$sslProvider.equals(other$sslProvider)) {
            return false;
        }
        String this$tlsTrustStoreType = this.getTlsTrustStoreType();
        String other$tlsTrustStoreType = other.getTlsTrustStoreType();
        if (this$tlsTrustStoreType == null ? other$tlsTrustStoreType != null : !this$tlsTrustStoreType.equals(other$tlsTrustStoreType)) {
            return false;
        }
        String this$tlsTrustStorePath = this.getTlsTrustStorePath();
        String other$tlsTrustStorePath = other.getTlsTrustStorePath();
        if (this$tlsTrustStorePath == null ? other$tlsTrustStorePath != null : !this$tlsTrustStorePath.equals(other$tlsTrustStorePath)) {
            return false;
        }
        String this$tlsTrustStorePassword = this.getTlsTrustStorePassword();
        String other$tlsTrustStorePassword = other.getTlsTrustStorePassword();
        if (this$tlsTrustStorePassword == null ? other$tlsTrustStorePassword != null : !this$tlsTrustStorePassword.equals(other$tlsTrustStorePassword)) {
            return false;
        }
        Set<String> this$tlsCiphers = this.getTlsCiphers();
        Set<String> other$tlsCiphers = other.getTlsCiphers();
        if (this$tlsCiphers == null ? other$tlsCiphers != null : !((Object)this$tlsCiphers).equals(other$tlsCiphers)) {
            return false;
        }
        Set<String> this$tlsProtocols = this.getTlsProtocols();
        Set<String> other$tlsProtocols = other.getTlsProtocols();
        if (this$tlsProtocols == null ? other$tlsProtocols != null : !((Object)this$tlsProtocols).equals(other$tlsProtocols)) {
            return false;
        }
        Clock this$clock = this.getClock();
        Clock other$clock = other.getClock();
        return !(this$clock == null ? other$clock != null : !((Object)this$clock).equals(other$clock));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientConfigurationData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $serviceUrl = this.getServiceUrl();
        result = result * 59 + ($serviceUrl == null ? 43 : $serviceUrl.hashCode());
        String $authPluginClassName = this.getAuthPluginClassName();
        result = result * 59 + ($authPluginClassName == null ? 43 : $authPluginClassName.hashCode());
        String $authParams = this.getAuthParams();
        result = result * 59 + ($authParams == null ? 43 : $authParams.hashCode());
        long $operationTimeoutMs = this.getOperationTimeoutMs();
        result = result * 59 + (int)($operationTimeoutMs >>> 32 ^ $operationTimeoutMs);
        long $statsIntervalSeconds = this.getStatsIntervalSeconds();
        result = result * 59 + (int)($statsIntervalSeconds >>> 32 ^ $statsIntervalSeconds);
        result = result * 59 + this.getNumIoThreads();
        result = result * 59 + this.getNumListenerThreads();
        result = result * 59 + this.getConnectionsPerBroker();
        result = result * 59 + (this.isUseTcpNoDelay() ? 79 : 97);
        result = result * 59 + (this.isUseTls() ? 79 : 97);
        String $tlsTrustCertsFilePath = this.getTlsTrustCertsFilePath();
        result = result * 59 + ($tlsTrustCertsFilePath == null ? 43 : $tlsTrustCertsFilePath.hashCode());
        result = result * 59 + (this.isTlsAllowInsecureConnection() ? 79 : 97);
        result = result * 59 + (this.isTlsHostnameVerificationEnable() ? 79 : 97);
        result = result * 59 + this.getConcurrentLookupRequest();
        result = result * 59 + this.getMaxLookupRequest();
        result = result * 59 + this.getMaxNumberOfRejectedRequestPerConnection();
        result = result * 59 + this.getKeepAliveIntervalSeconds();
        result = result * 59 + this.getConnectionTimeoutMs();
        result = result * 59 + this.getRequestTimeoutMs();
        long $initialBackoffIntervalNanos = this.getInitialBackoffIntervalNanos();
        result = result * 59 + (int)($initialBackoffIntervalNanos >>> 32 ^ $initialBackoffIntervalNanos);
        long $maxBackoffIntervalNanos = this.getMaxBackoffIntervalNanos();
        result = result * 59 + (int)($maxBackoffIntervalNanos >>> 32 ^ $maxBackoffIntervalNanos);
        result = result * 59 + (this.isUseKeyStoreTls() ? 79 : 97);
        String $sslProvider = this.getSslProvider();
        result = result * 59 + ($sslProvider == null ? 43 : $sslProvider.hashCode());
        String $tlsTrustStoreType = this.getTlsTrustStoreType();
        result = result * 59 + ($tlsTrustStoreType == null ? 43 : $tlsTrustStoreType.hashCode());
        String $tlsTrustStorePath = this.getTlsTrustStorePath();
        result = result * 59 + ($tlsTrustStorePath == null ? 43 : $tlsTrustStorePath.hashCode());
        String $tlsTrustStorePassword = this.getTlsTrustStorePassword();
        result = result * 59 + ($tlsTrustStorePassword == null ? 43 : $tlsTrustStorePassword.hashCode());
        Set<String> $tlsCiphers = this.getTlsCiphers();
        result = result * 59 + ($tlsCiphers == null ? 43 : ((Object)$tlsCiphers).hashCode());
        Set<String> $tlsProtocols = this.getTlsProtocols();
        result = result * 59 + ($tlsProtocols == null ? 43 : ((Object)$tlsProtocols).hashCode());
        Clock $clock = this.getClock();
        result = result * 59 + ($clock == null ? 43 : ((Object)$clock).hashCode());
        return result;
    }

    public String toString() {
        return "ClientConfigurationData(serviceUrl=" + this.getServiceUrl() + ", serviceUrlProvider=" + this.getServiceUrlProvider() + ", authentication=" + this.getAuthentication() + ", authPluginClassName=" + this.getAuthPluginClassName() + ", authParams=" + this.getAuthParams() + ", operationTimeoutMs=" + this.getOperationTimeoutMs() + ", statsIntervalSeconds=" + this.getStatsIntervalSeconds() + ", numIoThreads=" + this.getNumIoThreads() + ", numListenerThreads=" + this.getNumListenerThreads() + ", connectionsPerBroker=" + this.getConnectionsPerBroker() + ", useTcpNoDelay=" + this.isUseTcpNoDelay() + ", useTls=" + this.isUseTls() + ", tlsTrustCertsFilePath=" + this.getTlsTrustCertsFilePath() + ", tlsAllowInsecureConnection=" + this.isTlsAllowInsecureConnection() + ", tlsHostnameVerificationEnable=" + this.isTlsHostnameVerificationEnable() + ", concurrentLookupRequest=" + this.getConcurrentLookupRequest() + ", maxLookupRequest=" + this.getMaxLookupRequest() + ", maxNumberOfRejectedRequestPerConnection=" + this.getMaxNumberOfRejectedRequestPerConnection() + ", keepAliveIntervalSeconds=" + this.getKeepAliveIntervalSeconds() + ", connectionTimeoutMs=" + this.getConnectionTimeoutMs() + ", requestTimeoutMs=" + this.getRequestTimeoutMs() + ", initialBackoffIntervalNanos=" + this.getInitialBackoffIntervalNanos() + ", maxBackoffIntervalNanos=" + this.getMaxBackoffIntervalNanos() + ", useKeyStoreTls=" + this.isUseKeyStoreTls() + ", sslProvider=" + this.getSslProvider() + ", tlsTrustStoreType=" + this.getTlsTrustStoreType() + ", tlsTrustStorePath=" + this.getTlsTrustStorePath() + ", tlsTrustStorePassword=" + this.getTlsTrustStorePassword() + ", tlsCiphers=" + this.getTlsCiphers() + ", tlsProtocols=" + this.getTlsProtocols() + ", clock=" + this.getClock() + ")";
    }

    public ClientConfigurationData() {
    }

    public ClientConfigurationData(String serviceUrl, ServiceUrlProvider serviceUrlProvider, Authentication authentication, String authPluginClassName, String authParams, long operationTimeoutMs, long statsIntervalSeconds, int numIoThreads, int numListenerThreads, int connectionsPerBroker, boolean useTcpNoDelay, boolean useTls, String tlsTrustCertsFilePath, boolean tlsAllowInsecureConnection, boolean tlsHostnameVerificationEnable, int concurrentLookupRequest, int maxLookupRequest, int maxNumberOfRejectedRequestPerConnection, int keepAliveIntervalSeconds, int connectionTimeoutMs, int requestTimeoutMs, long initialBackoffIntervalNanos, long maxBackoffIntervalNanos, boolean useKeyStoreTls, String sslProvider, String tlsTrustStoreType, String tlsTrustStorePath, String tlsTrustStorePassword, Set<String> tlsCiphers, Set<String> tlsProtocols, Clock clock) {
        this.serviceUrl = serviceUrl;
        this.serviceUrlProvider = serviceUrlProvider;
        this.authentication = authentication;
        this.authPluginClassName = authPluginClassName;
        this.authParams = authParams;
        this.operationTimeoutMs = operationTimeoutMs;
        this.statsIntervalSeconds = statsIntervalSeconds;
        this.numIoThreads = numIoThreads;
        this.numListenerThreads = numListenerThreads;
        this.connectionsPerBroker = connectionsPerBroker;
        this.useTcpNoDelay = useTcpNoDelay;
        this.useTls = useTls;
        this.tlsTrustCertsFilePath = tlsTrustCertsFilePath;
        this.tlsAllowInsecureConnection = tlsAllowInsecureConnection;
        this.tlsHostnameVerificationEnable = tlsHostnameVerificationEnable;
        this.concurrentLookupRequest = concurrentLookupRequest;
        this.maxLookupRequest = maxLookupRequest;
        this.maxNumberOfRejectedRequestPerConnection = maxNumberOfRejectedRequestPerConnection;
        this.keepAliveIntervalSeconds = keepAliveIntervalSeconds;
        this.connectionTimeoutMs = connectionTimeoutMs;
        this.requestTimeoutMs = requestTimeoutMs;
        this.initialBackoffIntervalNanos = initialBackoffIntervalNanos;
        this.maxBackoffIntervalNanos = maxBackoffIntervalNanos;
        this.useKeyStoreTls = useKeyStoreTls;
        this.sslProvider = sslProvider;
        this.tlsTrustStoreType = tlsTrustStoreType;
        this.tlsTrustStorePath = tlsTrustStorePath;
        this.tlsTrustStorePassword = tlsTrustStorePassword;
        this.tlsCiphers = tlsCiphers;
        this.tlsProtocols = tlsProtocols;
        this.clock = clock;
    }
}

