/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.authorization;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.nifi.registry.authorization.AccessPolicySummary;
import org.apache.nifi.registry.authorization.ResourcePermissions;

@ApiModel(value="tenant")
public class Tenant {
    private String identifier;
    private String identity;
    private Boolean configurable;
    private ResourcePermissions resourcePermissions;
    private Set<AccessPolicySummary> accessPolicies;

    public Tenant() {
    }

    public Tenant(String identifier, String identity) {
        this.identifier = identifier;
        this.identity = identity;
    }

    @ApiModelProperty(value="The computer-generated identifier of the tenant.", readOnly=true)
    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @ApiModelProperty(value="The human-facing identity of the tenant. This can only be changed if the tenant is configurable.")
    public String getIdentity() {
        return this.identity;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    @ApiModelProperty(value="Indicates if this tenant is configurable, based on which UserGroupProvider has been configured to manage it.", readOnly=true)
    public Boolean getConfigurable() {
        return this.configurable;
    }

    public void setConfigurable(Boolean configurable) {
        this.configurable = configurable;
    }

    @ApiModelProperty(value="A summary top-level resource access policies granted to this tenant.", readOnly=true)
    public ResourcePermissions getResourcePermissions() {
        return this.resourcePermissions;
    }

    public void setResourcePermissions(ResourcePermissions resourcePermissions) {
        this.resourcePermissions = resourcePermissions;
    }

    @ApiModelProperty(value="The access policies granted to this tenant.", readOnly=true)
    public Set<AccessPolicySummary> getAccessPolicies() {
        return this.accessPolicies;
    }

    public void setAccessPolicies(Set<AccessPolicySummary> accessPolicies) {
        this.accessPolicies = accessPolicies;
    }

    public void addAccessPolicies(Collection<AccessPolicySummary> accessPolicies) {
        if (accessPolicies != null) {
            if (this.accessPolicies == null) {
                this.accessPolicies = new HashSet<AccessPolicySummary>();
            }
            this.accessPolicies.addAll(accessPolicies);
        }
    }
}

