/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.compiler;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.lang.model.SourceVersion;
import javax.tools.JavaFileObject;
import org.apache.maven.api.Language;
import org.apache.maven.api.SourceRoot;
import org.apache.maven.api.Version;
import org.apache.maven.plugin.compiler.UnsupportedVersionException;

final class SourceDirectory {
    static final String MODULE_INFO = "module-info";
    static final String JAVA_FILE_SUFFIX = ".java";
    static final String CLASS_FILE_SUFFIX = ".class";
    final Path root;
    final List<String> includes;
    final List<String> excludes;
    final JavaFileObject.Kind fileKind;
    final String moduleName;
    private Path moduleInfo;
    final SourceVersion release;
    private boolean isVersioned;
    private Path outputDirectory;
    final JavaFileObject.Kind outputFileKind;

    private SourceDirectory(Path root, List<String> includes, List<String> excludes, JavaFileObject.Kind fileKind, String moduleName, SourceVersion release, Path outputDirectory, JavaFileObject.Kind outputFileKind) {
        this.root = Objects.requireNonNull(root);
        this.includes = Objects.requireNonNull(includes);
        this.excludes = Objects.requireNonNull(excludes);
        this.fileKind = Objects.requireNonNull(fileKind);
        this.moduleName = moduleName;
        this.release = release;
        if (moduleName != null) {
            outputDirectory = outputDirectory.resolve(moduleName);
        }
        this.outputDirectory = outputDirectory;
        this.outputFileKind = outputFileKind;
    }

    private void completeIfVersioned(SourceVersion baseVersion) {
        SourceVersion release = this.release;
        boolean bl = this.isVersioned = release != baseVersion;
        if (this.isVersioned) {
            if (release == null) {
                release = SourceVersion.latestSupported();
            }
            this.outputDirectory = SourceDirectory.outputDirectoryForReleases(this.outputDirectory, release);
        }
    }

    static Path outputDirectoryForReleases(Path outputDirectory, SourceVersion release) {
        if (release == null) {
            release = SourceVersion.latestSupported();
        }
        String version = release.name();
        version = version.substring(version.lastIndexOf(95) + 1);
        return SourceDirectory.outputDirectoryForReleases(outputDirectory).resolve(version);
    }

    static Path outputDirectoryForReleases(Path outputDirectory) {
        return outputDirectory.resolve("META-INF").resolve("versions");
    }

    static Optional<SourceVersion> targetVersion(SourceRoot root) {
        return root.targetVersion().map(Version::toString).map(SourceDirectory::parse);
    }

    private static SourceVersion parse(String version) {
        if (version == null || version.isBlank()) {
            return null;
        }
        try {
            Runtime.Version parsed = Runtime.Version.parse(version);
            return SourceVersion.valueOf("RELEASE_" + parsed.feature());
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedVersionException("Illegal version number: \"" + version + "\"", e);
        }
    }

    static List<SourceDirectory> fromProject(Stream<SourceRoot> compileSourceRoots, String defaultRelease, Path outputDirectory) {
        SourceVersion release = SourceDirectory.parse(defaultRelease);
        ArrayList<SourceDirectory> roots = new ArrayList<SourceDirectory>();
        compileSourceRoots.forEach(source -> {
            Path directory = source.directory();
            if (Files.exists(directory, new LinkOption[0])) {
                JavaFileObject.Kind fileKind = JavaFileObject.Kind.OTHER;
                JavaFileObject.Kind outputFileKind = JavaFileObject.Kind.OTHER;
                if (Language.JAVA_FAMILY.equals((Object)source.language())) {
                    fileKind = JavaFileObject.Kind.SOURCE;
                    outputFileKind = JavaFileObject.Kind.CLASS;
                }
                roots.add(new SourceDirectory(directory, source.includes(), source.excludes(), fileKind, source.module().orElse(null), SourceDirectory.targetVersion(source).orElse(release), outputDirectory, outputFileKind));
            }
        });
        roots.stream().map(dir -> dir.release).filter(Objects::nonNull).min(Enum::compareTo).ifPresent(baseVersion -> roots.forEach(dir -> dir.completeIfVersioned((SourceVersion)((Object)baseVersion))));
        return roots;
    }

    static List<SourceDirectory> fromPluginConfiguration(List<String> compileSourceRoots, String moduleName, String defaultRelease, Path outputDirectory) {
        SourceVersion release = SourceDirectory.parse(defaultRelease);
        ArrayList<SourceDirectory> roots = new ArrayList<SourceDirectory>(compileSourceRoots.size());
        for (String file : compileSourceRoots) {
            Path directory = Path.of(file, new String[0]);
            if (!Files.exists(directory, new LinkOption[0])) continue;
            roots.add(new SourceDirectory(directory, List.of(), List.of(), JavaFileObject.Kind.SOURCE, moduleName, release, outputDirectory, JavaFileObject.Kind.CLASS));
        }
        return roots;
    }

    static boolean isModuleInfoSource(Path file) {
        return "module-info.java".equals(file.getFileName().toString());
    }

    void visit(Path sourceFile) {
        if (SourceDirectory.isModuleInfoSource(sourceFile) && (this.moduleInfo == null || this.moduleInfo.getNameCount() >= sourceFile.getNameCount())) {
            this.moduleInfo = sourceFile;
        }
    }

    public Optional<Path> getModuleInfo() {
        return Optional.ofNullable(this.moduleInfo);
    }

    public Optional<SourceVersion> getSpecificVersion() {
        return Optional.ofNullable(this.isVersioned ? this.release : null);
    }

    public Path getOutputDirectory() {
        return this.outputDirectory;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SourceDirectory) {
            SourceDirectory other = (SourceDirectory)obj;
            return this.root.equals(other.root) && this.includes.equals(other.includes) && this.excludes.equals(other.excludes) && this.fileKind == other.fileKind && Objects.equals(this.moduleName, other.moduleName) && this.release == other.release && this.outputDirectory.equals(other.outputDirectory) && this.outputFileKind == other.outputFileKind;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.root, this.moduleName, this.release});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(100).append('\"').append(this.root).append('\"');
        if (this.moduleName != null) {
            sb.append(" for module \"").append(this.moduleName).append('\"');
        }
        if (this.release != null) {
            sb.append(" on Java release ").append((Object)this.release);
        }
        return sb.toString();
    }
}

