/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import kafka.tools.MessageInfo;
import kafka.tools.ReplicaVerificationTool$;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005Ue\u0001B\u0001\u0003\t\u001d\u0011QBU3qY&\u001c\u0017MQ;gM\u0016\u0014(BA\u0002\u0005\u0003\u0015!xn\u001c7t\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0004\u0001!q\u0001CA\u0005\r\u001b\u0005Q!\"A\u0006\u0002\u000bM\u001c\u0017\r\\1\n\u00055Q!AB!osJ+g\r\u0005\u0002\u0010%5\t\u0001C\u0003\u0002\u0012\t\u0005)Q\u000f^5mg&\u00111\u0003\u0005\u0002\b\u0019><w-\u001b8h\u0011!)\u0002A!A!\u0002\u00131\u0012!I3ya\u0016\u001cG/\u001a3SKBd\u0017nY1t!\u0016\u0014Hk\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0003B\f\u001fC1r!\u0001\u0007\u000f\u0011\u0005eQQ\"\u0001\u000e\u000b\u0005m1\u0011A\u0002\u001fs_>$h(\u0003\u0002\u001e\u0015\u00051\u0001K]3eK\u001aL!a\b\u0011\u0003\u00075\u000b\u0007O\u0003\u0002\u001e\u0015A\u0011!EK\u0007\u0002G)\u0011A%J\u0001\u0007G>lWn\u001c8\u000b\u0005\u00151#BA\u0014)\u0003\u0019\t\u0007/Y2iK*\t\u0011&A\u0002pe\u001eL!aK\u0012\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]B\u0011\u0011\"L\u0005\u0003])\u00111!\u00138u\u0011!\u0001\u0004A!A!\u0002\u0013\t\u0014AD5oSRL\u0017\r\\(gMN,Go\u001d\t\u0005/y\t#\u0007\u0005\u0002\ng%\u0011AG\u0003\u0002\u0005\u0019>tw\r\u0003\u00057\u0001\t\u0005\t\u0015!\u0003-\u0003M)\u0007\u0010]3di\u0016$g*^7GKR\u001c\u0007.\u001a:t\u0011!A\u0004A!A!\u0002\u0013\u0011\u0014A\u0004:fa>\u0014H/\u00138uKJ4\u0018\r\u001c\u0005\u0006u\u0001!\taO\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000bqrt\bQ!\u0011\u0005u\u0002Q\"\u0001\u0002\t\u000bUI\u0004\u0019\u0001\f\t\u000bAJ\u0004\u0019A\u0019\t\u000bYJ\u0004\u0019\u0001\u0017\t\u000baJ\u0004\u0019\u0001\u001a\t\u000f\r\u0003!\u0019!C\u0005\t\u0006qa-\u001a;dQ>3gm]3u\u001b\u0006\u0004X#A#\u0011\t=1\u0015EM\u0005\u0003\u000fB\u0011A\u0001U8pY\"1\u0011\n\u0001Q\u0001\n\u0015\u000bqBZ3uG\"|eMZ:fi6\u000b\u0007\u000f\t\u0005\b\u0017\u0002\u0011\r\u0011\"\u0003M\u00031\u0011XmY8sIN\u001c\u0015m\u00195f+\u0005i\u0005\u0003B\bGC9\u0003Ba\u0004$-\u001fB\u0019\u0001KV-\u000f\u0005E#V\"\u0001*\u000b\u0005M\u001b\u0013\u0001\u0003:fcV,7\u000f^:\n\u0005U\u0013\u0016!\u0004$fi\u000eD'+Z:q_:\u001cX-\u0003\u0002X1\ni\u0001+\u0019:uSRLwN\u001c#bi\u0006T!!\u0016*\u0011\u0005ikV\"A.\u000b\u0005q\u001b\u0013A\u0002:fG>\u0014H-\u0003\u0002_7\niQ*Z7pef\u0014VmY8sINDa\u0001\u0019\u0001!\u0002\u0013i\u0015!\u0004:fG>\u0014Hm]\"bG\",\u0007\u0005C\u0004c\u0001\t\u0007I\u0011B2\u0002\u001d\u0019,Go\u00195fe\n\u000b'O]5feV\tA\rE\u0002f]Bl\u0011A\u001a\u0006\u0003O\"\fa!\u0019;p[&\u001c'BA5k\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003W2\fA!\u001e;jY*\tQ.\u0001\u0003kCZ\f\u0017BA8g\u0005=\tEo\\7jGJ+g-\u001a:f]\u000e,\u0007CA9s\u001b\u0005A\u0017BA:i\u00059\u0019u.\u001e8u\t><h\u000eT1uG\"Da!\u001e\u0001!\u0002\u0013!\u0017a\u00044fi\u000eDWM\u001d\"beJLWM\u001d\u0011\t\u000f]\u0004!\u0019!C\u0005G\u0006\u0019b/\u001a:jM&\u001c\u0017\r^5p]\n\u000b'O]5fe\"1\u0011\u0010\u0001Q\u0001\n\u0011\fAC^3sS\u001aL7-\u0019;j_:\u0014\u0015M\u001d:jKJ\u0004\u0003bB>\u0001\u0001\u0004%I\u0001`\u0001\u000fY\u0006\u001cHOU3q_J$H+[7f+\u0005\u0011\u0004b\u0002@\u0001\u0001\u0004%Ia`\u0001\u0013Y\u0006\u001cHOU3q_J$H+[7f?\u0012*\u0017\u000f\u0006\u0003\u0002\u0002\u0005\u001d\u0001cA\u0005\u0002\u0004%\u0019\u0011Q\u0001\u0006\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003\u0013i\u0018\u0011!a\u0001e\u0005\u0019\u0001\u0010J\u0019\t\u000f\u00055\u0001\u0001)Q\u0005e\u0005yA.Y:u%\u0016\u0004xN\u001d;US6,\u0007\u0005\u000b\u0003\u0002\f\u0005E\u0001cA\u0005\u0002\u0014%\u0019\u0011Q\u0003\u0006\u0003\u0011Y|G.\u0019;jY\u0016D\u0001\"!\u0007\u0001\u0001\u0004%I\u0001`\u0001\u0007[\u0006DH*Y4\t\u0013\u0005u\u0001\u00011A\u0005\n\u0005}\u0011AC7bq2\u000bwm\u0018\u0013fcR!\u0011\u0011AA\u0011\u0011%\tI!a\u0007\u0002\u0002\u0003\u0007!\u0007C\u0004\u0002&\u0001\u0001\u000b\u0015\u0002\u001a\u0002\u000f5\f\u0007\u0010T1hA!A\u0011\u0011\u0006\u0001A\u0002\u0013%A0\u0001\tpM\u001a\u001cX\r^,ji\"l\u0015\r\u001f'bO\"I\u0011Q\u0006\u0001A\u0002\u0013%\u0011qF\u0001\u0015_\u001a47/\u001a;XSRDW*\u0019=MC\u001e|F%Z9\u0015\t\u0005\u0005\u0011\u0011\u0007\u0005\n\u0003\u0013\tY#!AA\u0002IBq!!\u000e\u0001A\u0003&!'A\tpM\u001a\u001cX\r^,ji\"l\u0015\r\u001f'bO\u0002B\u0011\"!\u000f\u0001\u0001\u0004%I!a\u000f\u0002/5\f\u0007\u0010T1h)>\u0004\u0018nY!oIB\u000b'\u000f^5uS>tW#A\u0011\t\u0013\u0005}\u0002\u00011A\u0005\n\u0005\u0005\u0013aG7bq2\u000bw\rV8qS\u000e\fe\u000e\u001a)beRLG/[8o?\u0012*\u0017\u000f\u0006\u0003\u0002\u0002\u0005\r\u0003\"CA\u0005\u0003{\t\t\u00111\u0001\"\u0011\u001d\t9\u0005\u0001Q!\n\u0005\n\u0001$\\1y\u0019\u0006<Gk\u001c9jG\u0006sG\rU1si&$\u0018n\u001c8!\u0011\u001d\tY\u0005\u0001C\u0001\u0003\u001b\nqc\u0019:fCR,g*Z<GKR\u001c\u0007.\u001a:CCJ\u0014\u0018.\u001a:\u0015\u0005\u0005\u0005\u0001bBA)\u0001\u0011\u0005\u00111K\u0001\u0012O\u0016$h)\u001a;dQ\u0016\u0014()\u0019:sS\u0016\u0014H#\u00019\t\u000f\u0005]\u0003\u0001\"\u0001\u0002N\u0005a2M]3bi\u0016tUm\u001e,fe&4\u0017nY1uS>t')\u0019:sS\u0016\u0014\bbBA.\u0001\u0011\u0005\u00111K\u0001\u0017O\u0016$h+\u001a:jM&\u001c\u0017\r^5p]\n\u000b'O]5fe\"9\u0011q\f\u0001\u0005\n\u00055\u0013AC5oSRL\u0017\r\\5{K\"9\u00111\r\u0001\u0005\n\u00055\u0013!E:fi&s\u0017\u000e^5bY>3gm]3ug\"9\u0011q\r\u0001\u0005\u0002\u0005%\u0014AD1eI\u001a+Go\u00195fI\u0012\u000bG/\u0019\u000b\t\u0003\u0003\tY'a\u001c\u0002t!9\u0011QNA3\u0001\u0004\t\u0013!\u0005;pa&\u001c\u0017I\u001c3QCJ$\u0018\u000e^5p]\"9\u0011\u0011OA3\u0001\u0004a\u0013!\u0003:fa2L7-Y%e\u0011\u001d\t)(!\u001aA\u0002=\u000bQ\u0002]1si&$\u0018n\u001c8ECR\f\u0007bBA=\u0001\u0011\u0005\u00111P\u0001\nO\u0016$xJ\u001a4tKR$2AMA?\u0011\u001d\ti'a\u001eA\u0002\u0005Bq!!!\u0001\t\u0003\t\u0019)\u0001\bwKJLg-_\"iK\u000e\\7+^7\u0015\t\u0005\u0005\u0011Q\u0011\u0005\t\u0003\u000f\u000by\b1\u0001\u0002\n\u00069\u0001O]5oi2t\u0007cB\u0005\u0002\f\u0006=\u0015\u0011A\u0005\u0004\u0003\u001bS!!\u0003$v]\u000e$\u0018n\u001c82!\r9\u0012\u0011S\u0005\u0004\u0003'\u0003#AB*ue&tw\r")
public class ReplicaBuffer
implements Logging {
    private final Map<TopicPartition, Object> expectedReplicasPerTopicPartition;
    private final Map<TopicPartition, Object> initialOffsets;
    private final int expectedNumFetchers;
    private final long reportInterval;
    private final Pool<TopicPartition, Object> fetchOffsetMap;
    private final Pool<TopicPartition, Pool<Object, FetchResponse.PartitionData<MemoryRecords>>> recordsCache;
    private final AtomicReference<CountDownLatch> fetcherBarrier;
    private final AtomicReference<CountDownLatch> verificationBarrier;
    private volatile long lastReportTime;
    private long maxLag;
    private long offsetWithMaxLag;
    private TopicPartition maxLagTopicAndPartition;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ReplicaBuffer replicaBuffer = this;
        synchronized (replicaBuffer) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private Pool<TopicPartition, Object> fetchOffsetMap() {
        return this.fetchOffsetMap;
    }

    private Pool<TopicPartition, Pool<Object, FetchResponse.PartitionData<MemoryRecords>>> recordsCache() {
        return this.recordsCache;
    }

    private AtomicReference<CountDownLatch> fetcherBarrier() {
        return this.fetcherBarrier;
    }

    private AtomicReference<CountDownLatch> verificationBarrier() {
        return this.verificationBarrier;
    }

    private long lastReportTime() {
        return this.lastReportTime;
    }

    private void lastReportTime_$eq(long x$1) {
        this.lastReportTime = x$1;
    }

    private long maxLag() {
        return this.maxLag;
    }

    private void maxLag_$eq(long x$1) {
        this.maxLag = x$1;
    }

    private long offsetWithMaxLag() {
        return this.offsetWithMaxLag;
    }

    private void offsetWithMaxLag_$eq(long x$1) {
        this.offsetWithMaxLag = x$1;
    }

    private TopicPartition maxLagTopicAndPartition() {
        return this.maxLagTopicAndPartition;
    }

    private void maxLagTopicAndPartition_$eq(TopicPartition x$1) {
        this.maxLagTopicAndPartition = x$1;
    }

    public void createNewFetcherBarrier() {
        this.fetcherBarrier().set(new CountDownLatch(this.expectedNumFetchers));
    }

    public CountDownLatch getFetcherBarrier() {
        return this.fetcherBarrier().get();
    }

    public void createNewVerificationBarrier() {
        this.verificationBarrier().set(new CountDownLatch(1));
    }

    public CountDownLatch getVerificationBarrier() {
        return this.verificationBarrier().get();
    }

    private void initialize() {
        this.expectedReplicasPerTopicPartition.keySet().foreach((Function1 & Serializable & scala.Serializable)topicPartition -> this.recordsCache().put((TopicPartition)topicPartition, new Pool(Pool$.MODULE$.$lessinit$greater$default$1())));
        this.setInitialOffsets();
    }

    private void setInitialOffsets() {
        this.initialOffsets.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ReplicaBuffer.$anonfun$setInitialOffsets$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)ReplicaBuffer.$anonfun$setInitialOffsets$2(this, x$7)));
    }

    public void addFetchedData(TopicPartition topicAndPartition, int replicaId, FetchResponse.PartitionData<MemoryRecords> partitionData) {
        this.recordsCache().get(topicAndPartition).put(BoxesRunTime.boxToInteger((int)replicaId), partitionData);
    }

    public long getOffset(TopicPartition topicAndPartition) {
        return BoxesRunTime.unboxToLong((Object)this.fetchOffsetMap().get(topicAndPartition));
    }

    public void verifyCheckSum(Function1<String, BoxedUnit> println) {
        block0: {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Begin verification");
            this.maxLag_$eq(-1L);
            this.recordsCache().withFilter((Function1<Tuple2<TopicPartition, Pool<Object, FetchResponse.PartitionData<MemoryRecords>>>, Object>)(Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)ReplicaBuffer.$anonfun$verifyCheckSum$2(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
                ReplicaBuffer.$anonfun$verifyCheckSum$3(this, println, x$10);
                return BoxedUnit.UNIT;
            });
            long currentTimeMs = Time.SYSTEM.milliseconds();
            if (currentTimeMs - this.lastReportTime() <= this.reportInterval) break block0;
            println.apply((Object)new StringBuilder(57).append(ReplicaVerificationTool$.MODULE$.dateFormat().format(new Date(currentTimeMs))).append(": max lag is ").append(this.maxLag()).append(" for partition ").append(this.maxLagTopicAndPartition()).append(" at offset ").append(this.offsetWithMaxLag()).append(" among ").append(this.recordsCache().size()).append(" partitions").toString());
            this.lastReportTime_$eq(currentTimeMs);
        }
    }

    public static final /* synthetic */ boolean $anonfun$setInitialOffsets$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ long $anonfun$setInitialOffsets$2(ReplicaBuffer $this, Tuple2 x$7) {
        Tuple2 tuple2 = x$7;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        long offset = tuple2._2$mcJ$sp();
        long l = BoxesRunTime.unboxToLong((Object)$this.fetchOffsetMap().put(tp, BoxesRunTime.boxToLong((long)offset)));
        return l;
    }

    public static final /* synthetic */ boolean $anonfun$verifyCheckSum$2(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$verifyCheckSum$8(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$verifyCheckSum$9(ReplicaBuffer $this, Function1 println$1, TopicPartition topicPartition$1, Pool fetchResponsePerReplica$1, BooleanRef isMessageInAllReplicas$1, ObjectRef messageInfoFromFirstReplicaOpt$1, Tuple2 x$9) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x$9;
        if (tuple2 != null) {
            int replicaId = tuple2._1$mcI$sp();
            Iterator recordBatchIterator = (Iterator)tuple2._2();
            try {
                if (recordBatchIterator.hasNext()) {
                    MutableRecordBatch batch = (MutableRecordBatch)recordBatchIterator.next();
                    if (batch.lastOffset() >= ((FetchResponse.PartitionData)fetchResponsePerReplica$1.get(BoxesRunTime.boxToInteger((int)replicaId))).highWatermark) {
                        isMessageInAllReplicas$1.elem = false;
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    Option option = (Option)messageInfoFromFirstReplicaOpt$1.elem;
                    if (None$.MODULE$.equals(option)) {
                        messageInfoFromFirstReplicaOpt$1.elem = new Some((Object)new MessageInfo(replicaId, batch.lastOffset(), batch.nextOffset(), batch.checksum()));
                        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                    } else if (option instanceof Some) {
                        Some some = (Some)option;
                        MessageInfo messageInfoFromFirstReplica = (MessageInfo)some.value();
                        if (messageInfoFromFirstReplica.offset() != batch.lastOffset()) {
                            println$1.apply((Object)new StringBuilder(65).append(ReplicaVerificationTool$.MODULE$.getCurrentTimeString()).append(": partition ").append(topicPartition$1).append(": replica ").append(messageInfoFromFirstReplica.replicaId()).append("'s offset ").append(messageInfoFromFirstReplica.offset()).append(" doesn't match replica ").append(replicaId).append("'s offset ").append(batch.lastOffset()).toString());
                            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
                        }
                        BoxedUnit boxedUnit3 = messageInfoFromFirstReplica.checksum() != batch.checksum() ? (BoxedUnit)println$1.apply((Object)new StringBuilder(90).append(ReplicaVerificationTool$.MODULE$.getCurrentTimeString()).append(": partition ").append(topicPartition$1).append(" has unmatched checksum at offset ").append(batch.lastOffset()).append("; replica ").append(messageInfoFromFirstReplica.replicaId()).append("'s checksum ").append(messageInfoFromFirstReplica.checksum()).append("; replica ").append(replicaId).append("'s checksum ").append(batch.checksum()).toString()) : BoxedUnit.UNIT;
                    } else {
                        throw new MatchError((Object)option);
                    }
                    boxedUnit = BoxedUnit.UNIT;
                }
                isMessageInAllReplicas$1.elem = false;
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable t) {
                throw new RuntimeException(new StringOps(Predef$.MODULE$.augmentString("Error in processing replica %d in partition %s at offset %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)replicaId), topicPartition$1, $this.fetchOffsetMap().get(topicPartition$1)})), t);
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit4 = boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$verifyCheckSum$3(ReplicaBuffer $this, Function1 println$1, Tuple2 x$10) {
        Pool fetchResponsePerReplica;
        Tuple2 tuple2 = x$10;
        if (tuple2 != null) {
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            fetchResponsePerReplica = (Pool)tuple2._2();
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(10).append("Verifying ").append(topicPartition).toString());
            Predef$.MODULE$.assert(fetchResponsePerReplica.size() == BoxesRunTime.unboxToInt((Object)$this.expectedReplicasPerTopicPartition.apply((Object)topicPartition)), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("fetched ").append(fetchResponsePerReplica.size()).append(" replicas for ").append(topicPartition).append(", but expected ").append($this.expectedReplicasPerTopicPartition.apply((Object)topicPartition)).append(" replicas").toString());
            Iterable recordBatchIteratorMap = (Iterable)fetchResponsePerReplica.map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                Tuple2 tuple2 = x0$4;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int replicaId = tuple2._1$mcI$sp();
                FetchResponse.PartitionData fetchResponse = (FetchResponse.PartitionData)tuple2._2();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)replicaId)), ((MemoryRecords)fetchResponse.records).batches().iterator());
                return tuple22;
            }, Iterable$.MODULE$.canBuildFrom());
            long maxHw = BoxesRunTime.unboxToLong((Object)((TraversableOnce)fetchResponsePerReplica.values().map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.highWatermark), Iterable$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$));
            BooleanRef isMessageInAllReplicas = BooleanRef.create((boolean)true);
            while (isMessageInAllReplicas.elem) {
                ObjectRef messageInfoFromFirstReplicaOpt = ObjectRef.create((Object)None$.MODULE$);
                recordBatchIteratorMap.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)ReplicaBuffer.$anonfun$verifyCheckSum$8(check$ifrefutable$3))).foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
                    ReplicaBuffer.$anonfun$verifyCheckSum$9($this, println$1, topicPartition, fetchResponsePerReplica, isMessageInAllReplicas, messageInfoFromFirstReplicaOpt, x$9);
                    return BoxedUnit.UNIT;
                });
                if (!isMessageInAllReplicas.elem) continue;
                long nextOffset = ((MessageInfo)((Option)messageInfoFromFirstReplicaOpt.elem).get()).nextOffset();
                $this.fetchOffsetMap().put(topicPartition, BoxesRunTime.boxToLong((long)nextOffset));
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append(BoxesRunTime.unboxToInt((Object)$this.expectedReplicasPerTopicPartition.apply((Object)topicPartition))).append(" replicas match at offset ").append(nextOffset).append(" for ").append(topicPartition).toString());
            }
            if (maxHw - BoxesRunTime.unboxToLong((Object)$this.fetchOffsetMap().get(topicPartition)) > $this.maxLag()) {
                $this.offsetWithMaxLag_$eq(BoxesRunTime.unboxToLong((Object)$this.fetchOffsetMap().get(topicPartition)));
                $this.maxLag_$eq(maxHw - $this.offsetWithMaxLag());
                $this.maxLagTopicAndPartition_$eq(topicPartition);
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        fetchResponsePerReplica.clear();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public ReplicaBuffer(Map<TopicPartition, Object> expectedReplicasPerTopicPartition, Map<TopicPartition, Object> initialOffsets, int expectedNumFetchers, long reportInterval) {
        this.expectedReplicasPerTopicPartition = expectedReplicasPerTopicPartition;
        this.initialOffsets = initialOffsets;
        this.expectedNumFetchers = expectedNumFetchers;
        this.reportInterval = reportInterval;
        Logging.$init$(this);
        this.fetchOffsetMap = new Pool(Pool$.MODULE$.$lessinit$greater$default$1());
        this.recordsCache = new Pool(Pool$.MODULE$.$lessinit$greater$default$1());
        this.fetcherBarrier = new AtomicReference<CountDownLatch>(new CountDownLatch(expectedNumFetchers));
        this.verificationBarrier = new AtomicReference<CountDownLatch>(new CountDownLatch(1));
        this.lastReportTime = Time.SYSTEM.milliseconds();
        this.maxLag = -1L;
        this.offsetWithMaxLag = -1L;
        this.maxLagTopicAndPartition = null;
        this.initialize();
    }
}

