/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kafka.server.FetchContext;
import kafka.server.FetchSession;
import kafka.server.FetchSession$;
import kafka.server.FetchSessionCache;
import kafka.server.FullFetchContext;
import kafka.server.IncrementalFetchContext;
import kafka.server.SessionErrorContext;
import kafka.server.SessionlessFetchContext;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple3;
import scala.reflect.ScalaSignature;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001E4A!\u0001\u0002\u0001\u000f\taa)\u001a;dQ6\u000bg.Y4fe*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00119\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007CA\b\u0013\u001b\u0005\u0001\"BA\t\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0002CA\u0004M_\u001e<\u0017N\\4\t\u0011U\u0001!Q1A\u0005\nY\tA\u0001^5nKV\tq\u0003\u0005\u0002\u0019C5\t\u0011D\u0003\u0002\u00125)\u00111\u0004H\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015i\"B\u0001\u0010 \u0003\u0019\t\u0007/Y2iK*\t\u0001%A\u0002pe\u001eL!AI\r\u0003\tQKW.\u001a\u0005\tI\u0001\u0011\t\u0011)A\u0005/\u0005)A/[7fA!Aa\u0005\u0001BC\u0002\u0013%q%A\u0003dC\u000eDW-F\u0001)!\tI#&D\u0001\u0003\u0013\tY#AA\tGKR\u001c\u0007nU3tg&|gnQ1dQ\u0016D\u0001\"\f\u0001\u0003\u0002\u0003\u0006I\u0001K\u0001\u0007G\u0006\u001c\u0007.\u001a\u0011\t\u000b=\u0002A\u0011\u0001\u0019\u0002\rqJg.\u001b;?)\r\t$g\r\t\u0003S\u0001AQ!\u0006\u0018A\u0002]AQA\n\u0018A\u0002!BQ!\u000e\u0001\u0005\u0002Y\n!B\\3x\u0007>tG/\u001a=u)\u00159$HQ&Z!\tI\u0003(\u0003\u0002:\u0005\taa)\u001a;dQ\u000e{g\u000e^3yi\")1\b\u000ea\u0001y\u0005Y!/Z9NKR\fG-\u0019;b!\ti\u0004)D\u0001?\u0015\ty$$\u0001\u0005sKF,Xm\u001d;t\u0013\t\teHA\u0007GKR\u001c\u0007.T3uC\u0012\fG/\u0019\u0005\u0006\u0007R\u0002\r\u0001R\u0001\nM\u0016$8\r\u001b#bi\u0006\u0004\"!\u0012%\u000f\u0005%2\u0015BA$\u0003\u000311U\r^2i'\u0016\u001c8/[8o\u0013\tI%JA\u0004S\u000bF{V*\u0011)\u000b\u0005\u001d\u0013\u0001\"\u0002'5\u0001\u0004i\u0015\u0001\u0003;p\r>\u0014x-\u001a;\u0011\u00079\u001bV+D\u0001P\u0015\t\u0001\u0016+\u0001\u0003vi&d'\"\u0001*\u0002\t)\fg/Y\u0005\u0003)>\u0013A\u0001T5tiB\u0011akV\u0007\u00025%\u0011\u0001L\u0007\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0015QF\u00071\u0001\\\u0003)I7OR8mY><XM\u001d\t\u0003\u0013qK!!\u0018\u0006\u0003\u000f\t{w\u000e\\3b]\")q\f\u0001C\u0001A\u0006)\u0002/\u0019:uSRLwN\\:U_2{wm\u0015;sS:<GCA1m!\t\u0011\u0017N\u0004\u0002dOB\u0011AMC\u0007\u0002K*\u0011aMB\u0001\u0007yI|w\u000e\u001e \n\u0005!T\u0011A\u0002)sK\u0012,g-\u0003\u0002kW\n11\u000b\u001e:j]\u001eT!\u0001\u001b\u0006\t\u000b5t\u0006\u0019\u00018\u0002\u0015A\f'\u000f^5uS>t7\u000fE\u0002O_VK!\u0001](\u0003\u0015\r{G\u000e\\3di&|g\u000e")
public class FetchManager
implements Logging {
    private final Time time;
    private final FetchSessionCache cache;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        FetchManager fetchManager = this;
        synchronized (fetchManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private Time time() {
        return this.time;
    }

    private FetchSessionCache cache() {
        return this.cache;
    }

    public FetchContext newContext(FetchMetadata reqMetadata, Map<TopicPartition, FetchRequest.PartitionData> fetchData, List<TopicPartition> toForget, boolean isFollower) {
        FetchContext fetchContext;
        if (reqMetadata.isFull()) {
            FetchContext fetchContext2;
            ObjectRef removedFetchSessionStr = ObjectRef.create((Object)"");
            if (reqMetadata.sessionId() != 0 && this.cache().remove(reqMetadata.sessionId()).isDefined()) {
                removedFetchSessionStr.elem = new StringBuilder(24).append(" Removed fetch session ").append(reqMetadata.sessionId()).append(".").toString();
            }
            ObjectRef suffix = ObjectRef.create((Object)"");
            if (reqMetadata.epoch() == -1) {
                suffix.elem = " Will not try to create a new session.";
                fetchContext2 = new SessionlessFetchContext(fetchData);
            } else {
                fetchContext2 = new FullFetchContext(this.time(), this.cache(), reqMetadata, fetchData, isFollower);
            }
            FetchContext context = fetchContext2;
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Created a new full FetchContext with ").append(this.partitionsToLogString(fetchData.keySet())).append(".").append(new StringBuilder(0).append((String)removedFetchSessionStr$1.elem).append((String)suffix$1.elem).toString()).toString());
            fetchContext = context;
        } else {
            FetchSessionCache fetchSessionCache = this.cache();
            synchronized (fetchSessionCache) {
                SessionErrorContext sessionErrorContext;
                Option<FetchSession> option = this.cache().get(reqMetadata.sessionId());
                if (None$.MODULE$.equals(option)) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Session error for ").append(reqMetadata.sessionId()).append(": no such session ID found.").toString());
                    sessionErrorContext = new SessionErrorContext(Errors.FETCH_SESSION_ID_NOT_FOUND, reqMetadata);
                } else if (option instanceof Some) {
                    SessionErrorContext sessionErrorContext2;
                    FetchSession session;
                    Some some = (Some)option;
                    FetchSession fetchSession = session = (FetchSession)some.value();
                    synchronized (fetchSession) {
                        FetchContext fetchContext3;
                        if (session.epoch() != reqMetadata.epoch()) {
                            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Session error for ").append(reqMetadata.sessionId()).append(": expected epoch ").append(new StringBuilder(19).append(session.epoch()).append(", but got ").append(reqMetadata.epoch()).append(" instead.").toString()).toString());
                            fetchContext3 = new SessionErrorContext(Errors.INVALID_FETCH_SESSION_EPOCH, reqMetadata);
                        } else {
                            Tuple3<ArrayList<TopicPartition>, ArrayList<TopicPartition>, ArrayList<TopicPartition>> tuple3 = session.update(fetchData, toForget, reqMetadata);
                            if (tuple3 == null) {
                                throw new MatchError(tuple3);
                            }
                            ArrayList added = (ArrayList)tuple3._1();
                            ArrayList updated = (ArrayList)tuple3._2();
                            ArrayList removed = (ArrayList)tuple3._3();
                            Tuple3 tuple32 = new Tuple3((Object)added, (Object)updated, (Object)removed);
                            Tuple3 tuple33 = tuple32;
                            ArrayList added2 = (ArrayList)tuple33._1();
                            ArrayList updated2 = (ArrayList)tuple33._2();
                            ArrayList removed2 = (ArrayList)tuple33._3();
                            if (session.isEmpty()) {
                                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(98).append("Created a new sessionless FetchContext and closing session id ").append(session.id()).append(", ").append(new StringBuilder(25).append("epoch ").append(session.epoch()).append(": after removing ").append(this.partitionsToLogString(removed2)).append(", ").toString()).append("there are no more partitions left.").toString());
                                this.cache().remove(session);
                                fetchContext3 = new SessionlessFetchContext(fetchData);
                            } else {
                                if (session.size() != session.cachedSize()) {
                                    this.cache().touch(session, session.lastUsedMs());
                                }
                                session.epoch_$eq(FetchMetadata.nextEpoch((int)session.epoch()));
                                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Created a new incremental FetchContext for session id ").append(session.id()).append(", ").append(new StringBuilder(16).append("epoch ").append(session.epoch()).append(": added ").append(this.partitionsToLogString(added2)).append(", ").toString()).append(new StringBuilder(10).append("updated ").append(this.partitionsToLogString(updated2)).append(", ").toString()).append(new StringBuilder(8).append("removed ").append(this.partitionsToLogString(removed2)).toString()).toString());
                                fetchContext3 = new IncrementalFetchContext(this.time(), reqMetadata, session);
                            }
                        }
                        sessionErrorContext2 = fetchContext3;
                    }
                    sessionErrorContext = sessionErrorContext2;
                } else {
                    throw new MatchError(option);
                }
                SessionErrorContext sessionErrorContext3 = sessionErrorContext;
                // MONITOREXIT @DISABLED, blocks:[0, 2, 19] lbl64 : MonitorExitStatement: MONITOREXIT : var11_8
                fetchContext = sessionErrorContext3;
            }
        }
        FetchContext context = fetchContext;
        return context;
    }

    public String partitionsToLogString(Collection<TopicPartition> partitions) {
        return FetchSession$.MODULE$.partitionsToLogString(partitions, this.isTraceEnabled());
    }

    public FetchManager(Time time, FetchSessionCache cache) {
        this.time = time;
        this.cache = cache;
        Logging.$init$(this);
    }
}

