/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.api.LeaderAndIsr$;
import kafka.server.AdminManager;
import kafka.server.CreatePartitionsMetadata;
import kafka.server.DelayedOperation;
import kafka.server.DelayedOperation$;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u000194A!\u0001\u0002\u0001\u000f\t9B)\u001a7bs\u0016$7I]3bi\u0016\u0004\u0016M\u001d;ji&|gn\u001d\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u0013)i\u0011AA\u0005\u0003\u0017\t\u0011\u0001\u0003R3mCf,Gm\u00149fe\u0006$\u0018n\u001c8\t\u00135\u0001!\u0011!Q\u0001\n9!\u0012a\u00023fY\u0006LXj\u001d\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0005\u0019>tw-\u0003\u0002\u000e\u0015!Aa\u0003\u0001B\u0001B\u0003%q#\u0001\bde\u0016\fG/Z'fi\u0006$\u0017\r^1\u0011\u0007aYR$D\u0001\u001a\u0015\tQ\u0002#\u0001\u0006d_2dWm\u0019;j_:L!\u0001H\r\u0003\u0007M+\u0017\u000f\u0005\u0002\n=%\u0011qD\u0001\u0002\u0019\u0007J,\u0017\r^3QCJ$\u0018\u000e^5p]NlU\r^1eCR\f\u0007\u0002C\u0011\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0012\u0002\u0019\u0005$W.\u001b8NC:\fw-\u001a:\u0011\u0005%\u0019\u0013B\u0001\u0013\u0003\u00051\tE-\\5o\u001b\u0006t\u0017mZ3s\u0011!1\u0003A!A!\u0002\u00139\u0013\u0001\u0005:fgB|gn]3DC2d'-Y2l!\u0011y\u0001FK#\n\u0005%\u0002\"!\u0003$v]\u000e$\u0018n\u001c82!\u0011A2&\f\u001d\n\u00051J\"aA'baB\u0011a&\u000e\b\u0003_M\u0002\"\u0001\r\t\u000e\u0003ER!A\r\u0004\u0002\rq\u0012xn\u001c;?\u0013\t!\u0004#\u0001\u0004Qe\u0016$WMZ\u0005\u0003m]\u0012aa\u0015;sS:<'B\u0001\u001b\u0011!\tI4)D\u0001;\u0015\tYD(\u0001\u0005sKF,Xm\u001d;t\u0015\tid(\u0001\u0004d_6lwN\u001c\u0006\u0003\u000b}R!\u0001Q!\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0015aA8sO&\u0011AI\u000f\u0002\t\u0003BLWI\u001d:peB\u0011qBR\u0005\u0003\u000fB\u0011A!\u00168ji\")\u0011\n\u0001C\u0001\u0015\u00061A(\u001b8jiz\"Ra\u0013'N\u001d>\u0003\"!\u0003\u0001\t\u000b5A\u0005\u0019\u0001\b\t\u000bYA\u0005\u0019A\f\t\u000b\u0005B\u0005\u0019\u0001\u0012\t\u000b\u0019B\u0005\u0019A\u0014\t\u000bE\u0003A\u0011\t*\u0002\u0017Q\u0014\u0018pQ8na2,G/\u001a\u000b\u0002'B\u0011q\u0002V\u0005\u0003+B\u0011qAQ8pY\u0016\fg\u000eC\u0003X\u0001\u0011\u0005\u0003,\u0001\u0006p]\u000e{W\u000e\u001d7fi\u0016$\u0012!\u0012\u0005\u00065\u0002!\t\u0005W\u0001\r_:,\u0005\u0010]5sCRLwN\u001c\u0005\u00069\u0002!I!X\u0001\u0013[&\u001c8/\u001b8h\u0019\u0016\fG-\u001a:D_VtG\u000fF\u0002_C\u000e\u0004\"aD0\n\u0005\u0001\u0004\"aA%oi\")!m\u0017a\u0001[\u0005)Ao\u001c9jG\")Am\u0017a\u0001K\u0006Q\u0001/\u0019:uSRLwN\\:\u0011\u0007a1g,\u0003\u0002h3\t\u00191+\u001a;\t\u000b%\u0004A\u0011\u00026\u0002\u001f%\u001cX*[:tS:<G*Z1eKJ$2aU6m\u0011\u0015\u0011\u0007\u000e1\u0001.\u0011\u0015i\u0007\u000e1\u0001_\u0003%\u0001\u0018M\u001d;ji&|g\u000e")
public class DelayedCreatePartitions
extends DelayedOperation {
    private final Seq<CreatePartitionsMetadata> createMetadata;
    private final AdminManager adminManager;
    private final Function1<Map<String, ApiError>, BoxedUnit> responseCallback;

    @Override
    public boolean tryComplete() {
        boolean bl;
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Trying to complete operation for ").append($this.createMetadata).toString());
        int leaderlessPartitionCount = BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.createMetadata.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DelayedCreatePartitions.$anonfun$tryComplete$2(x$1)))).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToInteger((int)DelayedCreatePartitions.$anonfun$tryComplete$3(this, BoxesRunTime.unboxToInt((Object)x0$1), x1$1))));
        if (leaderlessPartitionCount == 0) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "All partitions have a leader, completing the delayed operation");
            bl = this.forceComplete();
        } else {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(70).append(leaderlessPartitionCount).append(" partitions do not have a leader, not completing the delayed operation").toString());
            bl = false;
        }
        return bl;
    }

    @Override
    public void onComplete() {
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Completing operation for ").append($this.createMetadata).toString());
        scala.collection.immutable.Map results = ((TraversableOnce)this.createMetadata.map((Function1 & Serializable & scala.Serializable)metadata -> metadata.error().isSuccess() && this.missingLeaderCount(metadata.topic(), (Set<Object>)metadata.replicaAssignments().keySet()) > 0 ? new Tuple2((Object)metadata.topic(), (Object)new ApiError(Errors.REQUEST_TIMED_OUT, null)) : new Tuple2((Object)metadata.topic(), (Object)metadata.error()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.responseCallback.apply((Object)results);
    }

    @Override
    public void onExpiration() {
    }

    private int missingLeaderCount(String topic, Set<Object> partitions) {
        return BoxesRunTime.unboxToInt((Object)partitions.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(x0$2, x1$2) -> {
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(x0$2, x1$2);
            if (sp2 == null) {
                throw new MatchError((Object)sp2);
            }
            int counter = sp2._1$mcI$sp();
            int partition = sp2._2$mcI$sp();
            int n = this.isMissingLeader(topic, partition) ? counter + 1 : counter;
            return n;
        }));
    }

    private boolean isMissingLeader(String topic, int partition) {
        Option<UpdateMetadataRequest.PartitionState> partitionInfo = this.adminManager.metadataCache().getPartitionInfo(topic, partition);
        return partitionInfo.isEmpty() || ((UpdateMetadataRequest.PartitionState)partitionInfo.get()).basePartitionState.leader == LeaderAndIsr$.MODULE$.NoLeader();
    }

    public static final /* synthetic */ boolean $anonfun$tryComplete$2(CreatePartitionsMetadata x$1) {
        return x$1.error().isSuccess();
    }

    public static final /* synthetic */ int $anonfun$tryComplete$3(DelayedCreatePartitions $this, int x0$1, CreatePartitionsMetadata x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$1), (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int topicCounter = tuple2._1$mcI$sp();
        CreatePartitionsMetadata metadata = (CreatePartitionsMetadata)tuple2._2();
        int n = topicCounter + $this.missingLeaderCount(metadata.topic(), (Set<Object>)metadata.replicaAssignments().keySet());
        return n;
    }

    public DelayedCreatePartitions(long delayMs, Seq<CreatePartitionsMetadata> createMetadata, AdminManager adminManager, Function1<Map<String, ApiError>, BoxedUnit> responseCallback) {
        this.createMetadata = createMetadata;
        this.adminManager = adminManager;
        this.responseCallback = responseCallback;
        super(delayMs, DelayedOperation$.MODULE$.$lessinit$greater$default$2());
    }
}

