/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.api.Request$;
import kafka.cluster.Partition$;
import kafka.cluster.Replica;
import kafka.cluster.Replica$;
import kafka.common.UnexpectedAppendOffsetException;
import kafka.controller.KafkaController$;
import kafka.log.Log;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.ConfigType$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogReadResult;
import kafka.server.LogReadResult$;
import kafka.server.ReplicaManager;
import kafka.server.TopicPartitionOperationKey;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.server.epoch.LeaderEpochCache;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.ReplicationUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.NotEnoughReplicasException;
import org.apache.kafka.common.errors.NotLeaderForPartitionException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.errors.ReplicaNotAvailableException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.Subtractable;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r%g\u0001B\u0001\u0003\u0001\u001d\u0011\u0011\u0002U1si&$\u0018n\u001c8\u000b\u0005\r!\u0011aB2mkN$XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u0001\t\u001dQ\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007CA\b\u0013\u001b\u0005\u0001\"BA\t\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0002CA\u0004M_\u001e<\u0017N\\4\u0011\u0005UAR\"\u0001\f\u000b\u0005]!\u0011aB7fiJL7m]\u0005\u00033Y\u0011\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q\u0011!Y\u0002A!b\u0001\n\u0003a\u0012!\u0002;pa&\u001cW#A\u000f\u0011\u0005y)cBA\u0010$!\t\u0001#\"D\u0001\"\u0015\t\u0011c!\u0001\u0004=e>|GOP\u0005\u0003I)\ta\u0001\u0015:fI\u00164\u0017B\u0001\u0014(\u0005\u0019\u0019FO]5oO*\u0011AE\u0003\u0005\tS\u0001\u0011\t\u0011)A\u0005;\u00051Ao\u001c9jG\u0002B\u0001b\u000b\u0001\u0003\u0006\u0004%\t\u0001L\u0001\fa\u0006\u0014H/\u001b;j_:LE-F\u0001.!\tIa&\u0003\u00020\u0015\t\u0019\u0011J\u001c;\t\u0011E\u0002!\u0011!Q\u0001\n5\nA\u0002]1si&$\u0018n\u001c8JI\u0002B\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001N\u0001\u0005i&lW\r\u0005\u00026}5\taG\u0003\u0002\u0012o)\u0011\u0001(O\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015Q$BA\u001e=\u0003\u0019\t\u0007/Y2iK*\tQ(A\u0002pe\u001eL!a\u0010\u001c\u0003\tQKW.\u001a\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\u0006q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\bCA\"G\u001b\u0005!%BA#\u0005\u0003\u0019\u0019XM\u001d<fe&\u0011q\t\u0012\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0011!I\u0005A!b\u0001\n\u0003Q\u0015!C5t\u001f\u001a4G.\u001b8f+\u0005Y\u0005CA\u0005M\u0013\ti%BA\u0004C_>dW-\u00198\t\u0011=\u0003!\u0011!Q\u0001\n-\u000b!\"[:PM\u001ad\u0017N\\3!\u0011\u0015\t\u0006\u0001\"\u0001S\u0003\u0019a\u0014N\\5u}Q11+\u0016,X1f\u0003\"\u0001\u0016\u0001\u000e\u0003\tAQa\u0007)A\u0002uAQa\u000b)A\u00025BQa\r)A\u0002QBQ!\u0011)A\u0002\tCq!\u0013)\u0011\u0002\u0003\u00071\nC\u0004\\\u0001\t\u0007I\u0011\u0001/\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]V\tQ\f\u0005\u0002_?6\tq'\u0003\u0002ao\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007B\u00022\u0001A\u0003%Q,A\bu_BL7\rU1si&$\u0018n\u001c8!\u0011\u001d!\u0007A1A\u0005\n1\nQ\u0002\\8dC2\u0014%o\\6fe&#\u0007B\u00024\u0001A\u0003%Q&\u0001\bm_\u000e\fGN\u0011:pW\u0016\u0014\u0018\n\u001a\u0011\t\u000f!\u0004!\u0019!C\u0005S\u0006QAn\\4NC:\fw-\u001a:\u0016\u0003)\u0004\"a\u001b8\u000e\u00031T!!\u001c\u0003\u0002\u00071|w-\u0003\u0002pY\nQAj\\4NC:\fw-\u001a:\t\rE\u0004\u0001\u0015!\u0003k\u0003-awnZ'b]\u0006<WM\u001d\u0011\t\u000fM\u0004!\u0019!C\u0005i\u0006A!p[\"mS\u0016tG/F\u0001v!\t1\u00180D\u0001x\u0015\tAH!\u0001\u0002{W&\u0011!p\u001e\u0002\u000e\u0017\u000647.\u0019.l\u00072LWM\u001c;\t\rq\u0004\u0001\u0015!\u0003v\u0003%Q8n\u00117jK:$\b\u0005C\u0004\u007f\u0001\t\u0007I\u0011B@\u0002\u001d\u0005dGNU3qY&\u001c\u0017m]'baV\u0011\u0011\u0011\u0001\t\u0007\u001f\u0005\rQ&a\u0002\n\u0007\u0005\u0015\u0001C\u0001\u0003Q_>d\u0007c\u0001+\u0002\n%\u0019\u00111\u0002\u0002\u0003\u000fI+\u0007\u000f\\5dC\"A\u0011q\u0002\u0001!\u0002\u0013\t\t!A\bbY2\u0014V\r\u001d7jG\u0006\u001cX*\u00199!\u0011%\t\u0019\u0002\u0001b\u0001\n\u0013\t)\"A\nmK\u0006$WM]%teV\u0003H-\u0019;f\u0019>\u001c7.\u0006\u0002\u0002\u0018A!\u0011\u0011DA\u0016\u001b\t\tYB\u0003\u0003\u0002\u001e\u0005}\u0011!\u00027pG.\u001c(\u0002BA\u0011\u0003G\t!bY8oGV\u0014(/\u001a8u\u0015\u0011\t)#a\n\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003S\tAA[1wC&!\u0011QFA\u000e\u0005Y\u0011V-\u001a8ue\u0006tGOU3bI^\u0013\u0018\u000e^3M_\u000e\\\u0007\u0002CA\u0019\u0001\u0001\u0006I!a\u0006\u0002)1,\u0017\rZ3s\u0013N\u0014X\u000b\u001d3bi\u0016dunY6!\u0011!\t)\u0004\u0001a\u0001\n\u0013a\u0013!\u0003>l-\u0016\u00148/[8o\u0011%\tI\u0004\u0001a\u0001\n\u0013\tY$A\u0007{WZ+'o]5p]~#S-\u001d\u000b\u0005\u0003{\t\u0019\u0005E\u0002\n\u0003\u007fI1!!\u0011\u000b\u0005\u0011)f.\u001b;\t\u0013\u0005\u0015\u0013qGA\u0001\u0002\u0004i\u0013a\u0001=%c!9\u0011\u0011\n\u0001!B\u0013i\u0013A\u0003>l-\u0016\u00148/[8oA!A\u0011Q\n\u0001A\u0002\u0013%A&A\u0006mK\u0006$WM]#q_\u000eD\u0007\"CA)\u0001\u0001\u0007I\u0011BA*\u0003=aW-\u00193fe\u0016\u0003xn\u00195`I\u0015\fH\u0003BA\u001f\u0003+B\u0011\"!\u0012\u0002P\u0005\u0005\t\u0019A\u0017\t\u000f\u0005e\u0003\u0001)Q\u0005[\u0005aA.Z1eKJ,\u0005o\\2iA!\"\u0011qKA/!\rI\u0011qL\u0005\u0004\u0003CR!\u0001\u0003<pY\u0006$\u0018\u000e\\3\t\u0013\u0005\u0015\u0004\u00011A\u0005\u0002\u0005\u001d\u0014A\u00057fC\u0012,'OU3qY&\u001c\u0017-\u00133PaR,\"!!\u001b\u0011\t%\tY'L\u0005\u0004\u0003[R!AB(qi&|g\u000eC\u0005\u0002r\u0001\u0001\r\u0011\"\u0001\u0002t\u00051B.Z1eKJ\u0014V\r\u001d7jG\u0006LEm\u00149u?\u0012*\u0017\u000f\u0006\u0003\u0002>\u0005U\u0004BCA#\u0003_\n\t\u00111\u0001\u0002j!A\u0011\u0011\u0010\u0001!B\u0013\tI'A\nmK\u0006$WM\u001d*fa2L7-Y%e\u001fB$\b\u0005\u000b\u0003\u0002x\u0005u\u0003\"CA@\u0001\u0001\u0007I\u0011AAA\u00039IgnU=oGJ+\u0007\u000f\\5dCN,\"!a!\u0011\u000by\t))a\u0002\n\u0007\u0005\u001duEA\u0002TKRD\u0011\"a#\u0001\u0001\u0004%\t!!$\u0002%%t7+\u001f8d%\u0016\u0004H.[2bg~#S-\u001d\u000b\u0005\u0003{\ty\t\u0003\u0006\u0002F\u0005%\u0015\u0011!a\u0001\u0003\u0007C\u0001\"a%\u0001A\u0003&\u00111Q\u0001\u0010S:\u001c\u0016P\\2SKBd\u0017nY1tA!\"\u0011\u0011SA/\u0011!\tI\n\u0001a\u0001\n\u0013a\u0013aD2p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195\t\u0013\u0005u\u0005\u00011A\u0005\n\u0005}\u0015aE2p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195`I\u0015\fH\u0003BA\u001f\u0003CC\u0011\"!\u0012\u0002\u001c\u0006\u0005\t\u0019A\u0017\t\u000f\u0005\u0015\u0006\u0001)Q\u0005[\u0005\u00012m\u001c8ue>dG.\u001a:Fa>\u001c\u0007\u000e\t\u0005\b\u0003S\u0003A\u0011BAV\u00039I7OU3qY&\u001c\u0017\rT8dC2$2aSAW\u0011\u001d\ty+a*A\u00025\n\u0011B]3qY&\u001c\u0017-\u00133\t\u0013\u0005M\u0006A1A\u0005\n\u0005U\u0016\u0001\u0002;bON,\"!a.\u0011\u0011\u0005e\u0016qXAb\u0003\u0007l!!a/\u000b\u0007\u0005u&\"\u0001\u0006d_2dWm\u0019;j_:LA!!1\u0002<\n\u0019Q*\u00199\u0011\t\u0005\u0015\u00171Z\u0007\u0003\u0003\u000fTA!!3\u0002(\u0005!A.\u00198h\u0013\r1\u0013q\u0019\u0005\t\u0003\u001f\u0004\u0001\u0015!\u0003\u00028\u0006)A/Y4tA!1\u00111\u001b\u0001\u0005\n)\u000bA#[:MK\u0006$WM\u001d*fa2L7-\u0019'pG\u0006d\u0007BBAl\u0001\u0011\u0005!*A\tjgVsG-\u001a:SKBd\u0017nY1uK\u0012Da!a7\u0001\t\u0003Q\u0015!D5t+:$WM]'j]&\u001b(\u000fC\u0004\u0002`\u0002!\t!!9\u000215\f\u0017PY3De\u0016\fG/\u001a$viV\u0014XMU3qY&\u001c\u0017\rF\u0002L\u0003GDq!!:\u0002^\u0002\u0007Q$\u0001\u0004m_\u001e$\u0015N\u001d\u0005\b\u0003S\u0004A\u0011AAv\u0003I9W\r^(s\u0007J,\u0017\r^3SKBd\u0017nY1\u0015\r\u0005\u001d\u0011Q^Ax\u0011%\ty+a:\u0011\u0002\u0003\u0007Q\u0006C\u0005\u0002r\u0006\u001d\b\u0013!a\u0001\u0017\u0006)\u0011n\u001d(fo\"9\u0011Q\u001f\u0001\u0005\u0002\u0005]\u0018AC4fiJ+\u0007\u000f\\5dCR!\u0011\u0011`A~!\u0015I\u00111NA\u0004\u0011%\ty+a=\u0011\u0002\u0003\u0007Q\u0006C\u0004\u0002\u0000\u0002!\tA!\u0001\u0002+\u001d,GOU3qY&\u001c\u0017m\u0014:Fq\u000e,\u0007\u000f^5p]R!\u0011q\u0001B\u0002\u0011%\ty+!@\u0011\u0002\u0003\u0007Q\u0006C\u0004\u0003\b\u0001!\tA!\u0003\u0002)1,\u0017\rZ3s%\u0016\u0004H.[2b\u0013\u001adunY1m+\t\tI\u0010C\u0004\u0003\u000e\u0001!\tAa\u0004\u0002+\u0005$GMU3qY&\u001c\u0017-\u00134O_R,\u00050[:ugR!\u0011q\u0001B\t\u0011!\u0011\u0019Ba\u0003A\u0002\u0005\u001d\u0011a\u0002:fa2L7-\u0019\u0005\b\u0005/\u0001A\u0011AAA\u0003A\t7o]5h]\u0016$'+\u001a9mS\u000e\f7\u000fC\u0004\u0003\u001c\u0001!\t!!!\u0002\u0017\u0005dGNU3qY&\u001c\u0017m\u001d\u0005\b\u0005?\u0001A\u0011\u0002B\u0011\u00035\u0011X-\\8wKJ+\u0007\u000f\\5dCR!\u0011Q\bB\u0012\u0011\u001d\tyK!\bA\u00025BqAa\n\u0001\t\u0003\u0011I#A\fgkR,(/\u001a*fa2L7-\u0019#je\u000eC\u0017M\\4fIR\u00191Ja\u000b\t\u000f\t5\"Q\u0005a\u0001;\u0005\tb.Z<EKN$\u0018N\\1uS>tG)\u001b:\t\u000f\tE\u0002\u0001\"\u0001\u00034\u0005A\"/Z7pm\u00164U\u000f^;sK2{7-\u00197SKBd\u0017nY1\u0015\t\u0005u\"Q\u0007\u0005\n\u0005o\u0011y\u0003%AA\u0002-\u000b\u0001\u0003Z3mKR,gI]8n\u0019><G)\u001b:\t\u000f\tm\u0002\u0001\"\u0001\u0003>\u0005!S.Y=cKJ+\u0007\u000f\\1dK\u000e+(O]3oi^KG\u000f\u001b$viV\u0014XMU3qY&\u001c\u0017\rF\u0001L\u0011\u001d\u0011\t\u0005\u0001C\u0001\u0005\u0007\na\u0001Z3mKR,GCAA\u001f\u0011\u0019\u00119\u0005\u0001C\u0001Y\u0005qq-\u001a;MK\u0006$WM]#q_\u000eD\u0007b\u0002B&\u0001\u0011\u0005!QJ\u0001\u000b[\u0006\\W\rT3bI\u0016\u0014HcB&\u0003P\tM#1\u000e\u0005\b\u0005#\u0012I\u00051\u0001.\u00031\u0019wN\u001c;s_2dWM]%e\u0011!\u0011)F!\u0013A\u0002\t]\u0013A\u00059beRLG/[8o'R\fG/Z%oM>\u0004BA!\u0017\u0003f9!!1\fB1\u001b\t\u0011iFC\u0002\u0003`]\n\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0005G\u0012i&A\nMK\u0006$WM]!oI&\u001b(OU3rk\u0016\u001cH/\u0003\u0003\u0003h\t%$A\u0004)beRLG/[8o'R\fG/\u001a\u0006\u0005\u0005G\u0012i\u0006C\u0004\u0003n\t%\u0003\u0019A\u0017\u0002\u001b\r|'O]3mCRLwN\\%e\u0011\u001d\u0011\t\b\u0001C\u0001\u0005g\nA\"\\1lK\u001a{G\u000e\\8xKJ$ra\u0013B;\u0005o\u0012I\bC\u0004\u0003R\t=\u0004\u0019A\u0017\t\u0011\tU#q\u000ea\u0001\u0005/BqA!\u001c\u0003p\u0001\u0007Q\u0006C\u0004\u0003~\u0001!\tAa \u00025U\u0004H-\u0019;f%\u0016\u0004H.[2b\u0019><'+Z1e%\u0016\u001cX\u000f\u001c;\u0015\u000b-\u0013\tIa!\t\u0011\tM!1\u0010a\u0001\u0003\u000fA\u0001B!\"\u0003|\u0001\u0007!qQ\u0001\u000eY><'+Z1e%\u0016\u001cX\u000f\u001c;\u0011\u0007\r\u0013I)C\u0002\u0003\f\u0012\u0013Q\u0002T8h%\u0016\fGMU3tk2$\bb\u0002BH\u0001\u0011\u0005!\u0011S\u0001\u000f[\u0006L(-Z#ya\u0006tG-S:s)\u0015Y%1\u0013BK\u0011\u001d\tyK!$A\u00025B\u0001B!\"\u0003\u000e\u0002\u0007!q\u0011\u0005\b\u00053\u0003A\u0011\u0001BN\u0003y\u0019\u0007.Z2l\u000b:|Wo\u001a5SKBd\u0017nY1t%\u0016\f7\r[(gMN,G\u000f\u0006\u0003\u0003\u001e\n=\u0006CB\u0005\u0003 .\u0013\u0019+C\u0002\u0003\"*\u0011a\u0001V;qY\u0016\u0014\u0004\u0003\u0002BS\u0005Wk!Aa*\u000b\u0007\t%v'\u0001\u0005qe>$xnY8m\u0013\u0011\u0011iKa*\u0003\r\u0015\u0013(o\u001c:t\u0011!\u0011\tLa&A\u0002\tM\u0016A\u0004:fcVL'/\u001a3PM\u001a\u001cX\r\u001e\t\u0004\u0013\tU\u0016b\u0001B\\\u0015\t!Aj\u001c8h\u0011\u001d\u0011Y\f\u0001C\u0005\u0005{\u000ba#\\1zE\u0016Len\u0019:f[\u0016tG\u000fT3bI\u0016\u0014\bj\u0016\u000b\u0006\u0017\n}&1\u0019\u0005\t\u0005\u0003\u0014I\f1\u0001\u0002\b\u0005iA.Z1eKJ\u0014V\r\u001d7jG\u0006D!B!2\u0003:B\u0005\t\u0019\u0001BZ\u0003\u001d\u0019WO\u001d+j[\u0016DqA!3\u0001\t\u0003\u0011Y-\u0001\u000bm_^<\u0016\r^3s[\u0006\u00148.\u00134MK\u0006$WM]\u000b\u0003\u0005gCqAa4\u0001\t\u0013\u0011\u0019%\u0001\u000euef\u001cu.\u001c9mKR,G)\u001a7bs\u0016$'+Z9vKN$8\u000fC\u0004\u0003T\u0002!\tA!6\u0002\u001d5\f\u0017PY3TQJLgn[%teR!\u0011Q\bBl\u0011!\u0011IN!5A\u0002\tM\u0016a\u0005:fa2L7-Y'bq2\u000bw\rV5nK6\u001b\bb\u0002Bo\u0001\u0011\u0005!q\\\u0001\u0015O\u0016$x*\u001e;PMNKhn\u0019*fa2L7-Y:\u0015\r\u0005\r%\u0011\u001dBr\u0011!\u0011\tMa7A\u0002\u0005\u001d\u0001\u0002\u0003Bs\u00057\u0004\rAa-\u0002\u00115\f\u0007\u0010T1h\u001bNDqA!;\u0001\t\u0013\u0011Y/\u0001\u0015e_\u0006\u0003\b/\u001a8e%\u0016\u001cwN\u001d3t)>4u\u000e\u001c7po\u0016\u0014xJ\u001d$viV\u0014XMU3qY&\u001c\u0017\r\u0006\u0004\u0002>\t5(Q \u0005\t\u0005_\u00149\u000f1\u0001\u0003r\u00069!/Z2pe\u0012\u001c\b\u0003\u0002Bz\u0005sl!A!>\u000b\u0007\t]x'\u0001\u0004sK\u000e|'\u000fZ\u0005\u0005\u0005w\u0014)PA\u0007NK6|'/\u001f*fG>\u0014Hm\u001d\u0005\b\u0005\u007f\u00149\u000f1\u0001L\u0003!I7OR;ukJ,\u0007bBB\u0002\u0001\u0011\u00051QA\u0001'CB\u0004XM\u001c3SK\u000e|'\u000fZ:U_\u001a{G\u000e\\8xKJ|%OR;ukJ,'+\u001a9mS\u000e\fGCBA\u001f\u0007\u000f\u0019I\u0001\u0003\u0005\u0003p\u000e\u0005\u0001\u0019\u0001By\u0011\u001d\u0011yp!\u0001A\u0002-Cqa!\u0004\u0001\t\u0003\u0019y!A\u000bbaB,g\u000e\u001a*fG>\u0014Hm\u001d+p\u0019\u0016\fG-\u001a:\u0015\u0011\rE1qCB\r\u0007;\u00012a[B\n\u0013\r\u0019)\u0002\u001c\u0002\u000e\u0019><\u0017\t\u001d9f]\u0012LeNZ8\t\u0011\t=81\u0002a\u0001\u0005cDqaa\u0007\u0004\f\u0001\u00071*\u0001\u0007jg\u001a\u0013x.\\\"mS\u0016tG\u000fC\u0005\u0004 \r-\u0001\u0013!a\u0001[\u0005a!/Z9vSJ,G-Q2lg\"911\u0005\u0001\u0005\u0002\t-\u0017A\u00047pON#\u0018M\u001d;PM\u001a\u001cX\r\u001e\u0005\b\u0007O\u0001A\u0011AB\u0015\u0003U!W\r\\3uKJ+7m\u001c:eg>sG*Z1eKJ$BAa-\u0004,!A1QFB\u0013\u0001\u0004\u0011\u0019,\u0001\u0004pM\u001a\u001cX\r\u001e\u0005\b\u0007c\u0001A\u0011AB\u001a\u0003)!(/\u001e8dCR,Gk\u001c\u000b\u0007\u0003{\u0019)da\u000e\t\u0011\r52q\u0006a\u0001\u0005gCqAa@\u00040\u0001\u00071\nC\u0004\u0004<\u0001!\ta!\u0010\u0002/Q\u0014XO\\2bi\u00164U\u000f\u001c7z\u0003:$7\u000b^1si\u0006#HCBA\u001f\u0007\u007f\u0019\u0019\u0005\u0003\u0005\u0004B\re\u0002\u0019\u0001BZ\u0003%qWm^(gMN,G\u000fC\u0004\u0003\u0000\u000ee\u0002\u0019A&\t\u000f\r\u001d\u0003\u0001\"\u0001\u0004J\u0005AB.Y:u\u001f\u001a47/\u001a;G_JdU-\u00193fe\u0016\u0003xn\u00195\u0015\t\r-3\u0011\u000b\t\u0005\u00057\u001ai%\u0003\u0003\u0004P\tu#AD#q_\u000eDWI\u001c3PM\u001a\u001cX\r\u001e\u0005\b\u0003\u001b\u001a)\u00051\u0001.\u0011\u001d\u0019)\u0006\u0001C\u0005\u0007/\n\u0011\"\u001e9eCR,\u0017j\u001d:\u0015\t\u0005u2\u0011\f\u0005\t\u00077\u001a\u0019\u00061\u0001\u0002\u0004\u00061a.Z<JgJDqaa\u0018\u0001\t\u0003\u0011\u0019%\u0001\fsK6|g/\u001a)beRLG/[8o\u001b\u0016$(/[2t\u0011\u001d\u0019\u0019\u0007\u0001C!\u0007K\na!Z9vC2\u001cHcA&\u0004h!A1\u0011NB1\u0001\u0004\u0019Y'\u0001\u0003uQ\u0006$\bcA\u0005\u0004n%\u00191q\u000e\u0006\u0003\u0007\u0005s\u0017\u0010C\u0004\u0004t\u0001!\te!\u001e\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012!\f\u0005\b\u0007s\u0002A\u0011IB>\u0003!!xn\u0015;sS:<G#A\u000f\t\u0013\r}\u0004!%A\u0005\u0002\r\u0005\u0015\u0001F4fiJ+\u0007\u000f\\5dC\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0004\u0004*\u001aQf!\",\u0005\r\u001d\u0005\u0003BBE\u0007'k!aa#\u000b\t\r55qR\u0001\nk:\u001c\u0007.Z2lK\u0012T1a!%\u000b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007+\u001bYIA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011b!'\u0001#\u0003%\ta!!\u00029\u001d,Go\u0014:De\u0016\fG/\u001a*fa2L7-\u0019\u0013eK\u001a\fW\u000f\u001c;%c!I1Q\u0014\u0001\u0012\u0002\u0013\u00051qT\u0001\u001dO\u0016$xJ]\"sK\u0006$XMU3qY&\u001c\u0017\r\n3fM\u0006,H\u000e\u001e\u00133+\t\u0019\tKK\u0002L\u0007\u000bC\u0011b!*\u0001#\u0003%\ta!!\u0002?\u001d,GOU3qY&\u001c\u0017m\u0014:Fq\u000e,\u0007\u000f^5p]\u0012\"WMZ1vYR$\u0013\u0007C\u0005\u0004*\u0002\t\n\u0011\"\u0001\u0004 \u0006\u0011#/Z7pm\u00164U\u000f^;sK2{7-\u00197SKBd\u0017nY1%I\u00164\u0017-\u001e7uIEB\u0011b!,\u0001#\u0003%Iaa,\u0002A5\f\u0017PY3J]\u000e\u0014X-\\3oi2+\u0017\rZ3s\u0011^#C-\u001a4bk2$HEM\u000b\u0003\u0007cSCAa-\u0004\u0006\"I1Q\u0017\u0001\u0012\u0002\u0013\u00051\u0011Q\u0001 CB\u0004XM\u001c3SK\u000e|'\u000fZ:U_2+\u0017\rZ3sI\u0011,g-Y;mi\u0012\u001at!CB]\u0005\u0005\u0005\t\u0012AB^\u0003%\u0001\u0016M\u001d;ji&|g\u000eE\u0002U\u0007{3\u0001\"\u0001\u0002\u0002\u0002#\u00051qX\n\u0004\u0007{C\u0001bB)\u0004>\u0012\u000511\u0019\u000b\u0003\u0007wC!ba2\u0004>F\u0005I\u0011ABP\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%k\u0001")
public class Partition
implements KafkaMetricsGroup {
    private final String topic;
    private final int partitionId;
    private final Time time;
    public final ReplicaManager kafka$cluster$Partition$$replicaManager;
    private final boolean isOffline;
    private final TopicPartition topicPartition;
    private final int localBrokerId;
    private final LogManager logManager;
    private final KafkaZkClient zkClient;
    private final Pool<Object, Replica> allReplicasMap;
    private final ReentrantReadWriteLock leaderIsrUpdateLock;
    private int zkVersion;
    private volatile int leaderEpoch;
    private volatile Option<Object> leaderReplicaIdOpt;
    private volatile Set<Replica> inSyncReplicas;
    private int controllerEpoch;
    private final Map<String, String> tags;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$5() {
        return Partition$.MODULE$.$lessinit$greater$default$5();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        Partition partition = this;
        synchronized (partition) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public boolean isOffline() {
        return this.isOffline;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    private int localBrokerId() {
        return this.localBrokerId;
    }

    private LogManager logManager() {
        return this.logManager;
    }

    private KafkaZkClient zkClient() {
        return this.zkClient;
    }

    private Pool<Object, Replica> allReplicasMap() {
        return this.allReplicasMap;
    }

    private ReentrantReadWriteLock leaderIsrUpdateLock() {
        return this.leaderIsrUpdateLock;
    }

    private int zkVersion() {
        return this.zkVersion;
    }

    private void zkVersion_$eq(int x$1) {
        this.zkVersion = x$1;
    }

    private int leaderEpoch() {
        return this.leaderEpoch;
    }

    private void leaderEpoch_$eq(int x$1) {
        this.leaderEpoch = x$1;
    }

    public Option<Object> leaderReplicaIdOpt() {
        return this.leaderReplicaIdOpt;
    }

    public void leaderReplicaIdOpt_$eq(Option<Object> x$1) {
        this.leaderReplicaIdOpt = x$1;
    }

    public Set<Replica> inSyncReplicas() {
        return this.inSyncReplicas;
    }

    public void inSyncReplicas_$eq(Set<Replica> x$1) {
        this.inSyncReplicas = x$1;
    }

    private int controllerEpoch() {
        return this.controllerEpoch;
    }

    private void controllerEpoch_$eq(int x$1) {
        this.controllerEpoch = x$1;
    }

    private boolean isReplicaLocal(int replicaId) {
        return replicaId == this.localBrokerId() || replicaId == Request$.MODULE$.FutureLocalReplicaId();
    }

    private Map<String, String> tags() {
        return this.tags;
    }

    public boolean kafka$cluster$Partition$$isLeaderReplicaLocal() {
        return this.leaderReplicaIfLocal().isDefined();
    }

    public boolean isUnderReplicated() {
        return this.kafka$cluster$Partition$$isLeaderReplicaLocal() && this.inSyncReplicas().size() < this.assignedReplicas().size();
    }

    public boolean isUnderMinIsr() {
        boolean bl;
        Option<Replica> option = this.leaderReplicaIfLocal();
        if (option instanceof Some) {
            Some some = (Some)option;
            Replica leaderReplica = (Replica)some.value();
            bl = this.inSyncReplicas().size() < Predef$.MODULE$.Integer2int(((Log)leaderReplica.log().get()).config().minInSyncReplicas());
        } else if (None$.MODULE$.equals(option)) {
            bl = false;
        } else {
            throw new MatchError(option);
        }
        return bl;
    }

    public boolean maybeCreateFutureReplica(String logDir) {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inWriteLock(this.leaderIsrUpdateLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            boolean bl;
            Replica currentReplica = (Replica)this.getReplica(this.getReplica$default$1()).get();
            String string = ((Log)currentReplica.log().get()).dir().getParent();
            String string2 = logDir;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                bl = false;
            } else if (this.getReplica(Request$.MODULE$.FutureLocalReplicaId()).isDefined()) {
                String futureReplicaLogDir;
                String string3 = futureReplicaLogDir = ((Log)((Replica)this.getReplica(Request$.MODULE$.FutureLocalReplicaId()).get()).log().get()).dir().getParent();
                String string4 = logDir;
                if (string3 == null ? string4 != null : !string3.equals(string4)) {
                    throw new IllegalStateException(new java.lang.StringBuilder(64).append("The future log dir ").append(futureReplicaLogDir).append(" of ").append(this.topicPartition()).append(" is different from the requested log dir ").append(logDir).toString());
                }
                bl = false;
            } else {
                this.getOrCreateReplica(Request$.MODULE$.FutureLocalReplicaId(), this.getOrCreateReplica$default$2());
                bl = true;
            }
            return bl;
        }));
    }

    public Replica getOrCreateReplica(int replicaId, boolean isNew) {
        return this.allReplicasMap().getAndMaybePut(BoxesRunTime.boxToInteger((int)replicaId), (Function0<Replica>)(Function0 & Serializable & scala.Serializable)() -> {
            Replica replica;
            if (this.isReplicaLocal(replicaId)) {
                AdminZkClient adminZkClient = new AdminZkClient(this.zkClient());
                Properties props = adminZkClient.fetchEntityConfig(ConfigType$.MODULE$.Topic(), this.topic());
                LogConfig config = LogConfig$.MODULE$.fromProps(this.logManager().currentDefaultConfig().originals(), props);
                Log log = this.logManager().getOrCreateLog(this.topicPartition(), config, isNew, replicaId == Request$.MODULE$.FutureLocalReplicaId());
                OffsetCheckpointFile checkpoint = (OffsetCheckpointFile)$this.kafka$cluster$Partition$$replicaManager.highWatermarkCheckpoints().apply((Object)log.dir().getParent());
                Map<TopicPartition, Object> offsetMap = checkpoint.read();
                if (!offsetMap.contains((Object)this.topicPartition())) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(53).append("No checkpointed highwatermark is found for partition ").append(this.topicPartition()).toString());
                }
                long offset = package$.MODULE$.min(BoxesRunTime.unboxToLong((Object)offsetMap.getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)), log.logEndOffset());
                replica = new Replica(replicaId, this.topicPartition(), $this.time, offset, (Option<Log>)new Some((Object)log));
            } else {
                replica = new Replica(replicaId, this.topicPartition(), $this.time, Replica$.MODULE$.$lessinit$greater$default$4(), Replica$.MODULE$.$lessinit$greater$default$5());
            }
            return replica;
        });
    }

    public int getOrCreateReplica$default$1() {
        return this.localBrokerId();
    }

    public boolean getOrCreateReplica$default$2() {
        return false;
    }

    public Option<Replica> getReplica(int replicaId) {
        return Option$.MODULE$.apply((Object)this.allReplicasMap().get(BoxesRunTime.boxToInteger((int)replicaId)));
    }

    public int getReplica$default$1() {
        return this.localBrokerId();
    }

    public Replica getReplicaOrException(int replicaId) {
        return (Replica)this.getReplica(replicaId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new ReplicaNotAvailableException(new java.lang.StringBuilder(40).append("Replica ").append(replicaId).append(" is not available for partition ").append(this.topicPartition()).toString());
        });
    }

    public int getReplicaOrException$default$1() {
        return this.localBrokerId();
    }

    public Option<Replica> leaderReplicaIfLocal() {
        return this.leaderReplicaIdOpt().filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$1 -> x$1 == this.localBrokerId()).flatMap((Function1 & Serializable & scala.Serializable)replicaId -> this.getReplica(BoxesRunTime.unboxToInt((Object)replicaId)));
    }

    public Replica addReplicaIfNotExists(Replica replica) {
        return this.allReplicasMap().putIfNotExists(BoxesRunTime.boxToInteger((int)replica.brokerId()), replica);
    }

    public Set<Replica> assignedReplicas() {
        return ((TraversableOnce)this.allReplicasMap().values().filter((Function1 & Serializable & scala.Serializable)replica -> BoxesRunTime.boxToBoolean((boolean)Request$.MODULE$.isValidBrokerId(replica.brokerId())))).toSet();
    }

    public Set<Replica> allReplicas() {
        return this.allReplicasMap().values().toSet();
    }

    private void removeReplica(int replicaId) {
        this.allReplicasMap().remove(BoxesRunTime.boxToInteger((int)replicaId));
    }

    public boolean futureReplicaDirChanged(String newDestinationDir) {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inReadLock(this.leaderIsrUpdateLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            boolean bl;
            Option<Replica> option = this.getReplica(Request$.MODULE$.FutureLocalReplicaId());
            if (option instanceof Some) {
                Some some = (Some)option;
                Replica futureReplica = (Replica)some.value();
                String string = ((Log)futureReplica.log().get()).dir().getParent();
                String string2 = newDestinationDir;
                bl = string == null ? string2 != null : !string.equals(string2);
            } else if (None$.MODULE$.equals(option)) {
                bl = false;
            } else {
                throw new MatchError(option);
            }
            return bl;
        }));
    }

    public void removeFutureLocalReplica(boolean deleteFromLogDir) {
        CoreUtils$.MODULE$.inWriteLock(this.leaderIsrUpdateLock(), (Function0 & Serializable & scala.Serializable)() -> {
            this.allReplicasMap().remove(BoxesRunTime.boxToInteger((int)Request$.MODULE$.FutureLocalReplicaId()));
            return deleteFromLogDir ? this.logManager().asyncDelete(this.topicPartition(), true) : BoxedUnit.UNIT;
        });
    }

    public boolean removeFutureLocalReplica$default$1() {
        return true;
    }

    public boolean maybeReplaceCurrentWithFutureReplica() {
        Replica replica = (Replica)this.getReplica(this.getReplica$default$1()).get();
        Option futureReplicaLEO = this.getReplica(Request$.MODULE$.FutureLocalReplicaId()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.logEndOffset());
        return futureReplicaLEO.contains((Object)replica.logEndOffset()) ? BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inWriteLock(this.leaderIsrUpdateLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            boolean bl;
            Option<Replica> option = this.getReplica(Request$.MODULE$.FutureLocalReplicaId());
            if (option instanceof Some) {
                boolean bl2;
                Some some = (Some)option;
                Replica futureReplica = (Replica)some.value();
                LogOffsetMetadata logOffsetMetadata = replica.logEndOffset();
                LogOffsetMetadata logOffsetMetadata2 = futureReplica.logEndOffset();
                if (!(logOffsetMetadata != null ? !((Object)logOffsetMetadata).equals(logOffsetMetadata2) : logOffsetMetadata2 != null)) {
                    this.logManager().replaceCurrentWithFutureLog(this.topicPartition());
                    replica.log_$eq(futureReplica.log());
                    futureReplica.log_$eq((Option<Log>)None$.MODULE$);
                    this.allReplicasMap().remove(BoxesRunTime.boxToInteger((int)Request$.MODULE$.FutureLocalReplicaId()));
                    bl2 = true;
                } else {
                    bl2 = false;
                }
                bl = bl2;
            } else if (None$.MODULE$.equals(option)) {
                bl = false;
            } else {
                throw new MatchError(option);
            }
            return bl;
        })) : false;
    }

    public void delete() {
        CoreUtils$.MODULE$.inWriteLock(this.leaderIsrUpdateLock(), (Function0 & Serializable & scala.Serializable)() -> {
            this.allReplicasMap().clear();
            this.inSyncReplicas_$eq((Set<Replica>)Predef$.MODULE$.Set().empty());
            this.leaderReplicaIdOpt_$eq((Option<Object>)None$.MODULE$);
            this.removePartitionMetrics();
            this.logManager().asyncDelete(this.topicPartition(), this.logManager().asyncDelete$default$2());
            return this.logManager().asyncDelete(this.topicPartition(), true);
        });
    }

    public int getLeaderEpoch() {
        return this.leaderEpoch();
    }

    public boolean makeLeader(int controllerId, LeaderAndIsrRequest.PartitionState partitionStateInfo, int correlationId) {
        boolean isNewLeader;
        block1: {
            Tuple2 tuple2 = (Tuple2)CoreUtils$.MODULE$.inWriteLock(this.leaderIsrUpdateLock(), (Function0 & Serializable & scala.Serializable)() -> {
                Buffer newAssignedReplicas = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionStateInfo$1.basePartitionState.replicas).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$3)), Buffer$.MODULE$.canBuildFrom());
                this.controllerEpoch_$eq(partitionStateInfo$1.basePartitionState.controllerEpoch);
                Set newInSyncReplicas = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionStateInfo$1.basePartitionState.isr).asScala()).map((Function1 & Serializable & scala.Serializable)r -> this.getOrCreateReplica(Predef$.MODULE$.Integer2int(r), partitionStateInfo$1.isNew), Buffer$.MODULE$.canBuildFrom())).toSet();
                ((IterableLike)((Subtractable)this.assignedReplicas().map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.brokerId()), Set$.MODULE$.canBuildFrom())).$minus$minus((GenTraversableOnce)newAssignedReplicas)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)replicaId -> this.removeReplica(replicaId));
                this.inSyncReplicas_$eq((Set<Replica>)newInSyncReplicas);
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(30).append(this.topicPartition()).append(" starts at Leader Epoch ").append(partitionStateInfo$1.basePartitionState.leaderEpoch).append(" from ").append(new java.lang.StringBuilder(36).append("offset ").append(((Replica)this.getReplica(this.getReplica$default$1()).get()).logEndOffset().messageOffset()).append(". Previous Leader Epoch was: ").append(this.leaderEpoch()).toString()).toString());
                this.leaderEpoch_$eq(partitionStateInfo$1.basePartitionState.leaderEpoch);
                newAssignedReplicas.foreach((Function1 & Serializable & scala.Serializable)id -> this.getOrCreateReplica(BoxesRunTime.unboxToInt((Object)id), partitionStateInfo.isNew));
                this.zkVersion_$eq(partitionStateInfo$1.basePartitionState.zkVersion);
                boolean isNewLeader = BoxesRunTime.unboxToBoolean((Object)this.leaderReplicaIdOpt().map((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$5 -> x$5 != this.localBrokerId()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true));
                Replica leaderReplica = (Replica)this.getReplica(this.getReplica$default$1()).get();
                long curLeaderLogEndOffset = leaderReplica.logEndOffset().messageOffset();
                long curTimeMs = $this.time.milliseconds();
                this.assignedReplicas().$minus((Object)leaderReplica).foreach((Function1 & Serializable & scala.Serializable)replica -> {
                    Partition.$anonfun$makeLeader$10(this, curLeaderLogEndOffset, curTimeMs, replica);
                    return BoxedUnit.UNIT;
                });
                if (isNewLeader) {
                    leaderReplica.convertHWToLocalOffsetMetadata();
                    this.leaderReplicaIdOpt_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)this.localBrokerId())));
                    ((IterableLike)this.assignedReplicas().filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)Partition.$anonfun$makeLeader$11(this, x$6)))).foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                        x$7.updateLogReadResult(LogReadResult$.MODULE$.UnknownLogReadResult());
                        return BoxedUnit.UNIT;
                    });
                }
                return new Tuple2.mcZZ.sp(this.maybeIncrementLeaderHW(leaderReplica, this.maybeIncrementLeaderHW$default$2()), isNewLeader);
            });
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            boolean leaderHWIncremented = tuple2._1$mcZ$sp();
            boolean isNewLeader2 = tuple2._2$mcZ$sp();
            Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(leaderHWIncremented, isNewLeader2);
            Tuple2.mcZZ.sp sp3 = sp2;
            boolean leaderHWIncremented2 = sp3._1$mcZ$sp();
            isNewLeader = sp3._2$mcZ$sp();
            if (!leaderHWIncremented2) break block1;
            this.tryCompleteDelayedRequests();
        }
        return isNewLeader;
    }

    public boolean makeFollower(int controllerId, LeaderAndIsrRequest.PartitionState partitionStateInfo, int correlationId) {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inWriteLock(this.leaderIsrUpdateLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            boolean bl;
            Buffer newAssignedReplicas = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionStateInfo$2.basePartitionState.replicas).asScala()).map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$9)), Buffer$.MODULE$.canBuildFrom());
            int newLeaderBrokerId = partitionStateInfo$2.basePartitionState.leader;
            this.controllerEpoch_$eq(partitionStateInfo$2.basePartitionState.controllerEpoch);
            newAssignedReplicas.foreach((Function1 & Serializable & scala.Serializable)r -> this.getOrCreateReplica(BoxesRunTime.unboxToInt((Object)r), partitionStateInfo.isNew));
            ((IterableLike)((Subtractable)this.assignedReplicas().map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.brokerId()), Set$.MODULE$.canBuildFrom())).$minus$minus((GenTraversableOnce)newAssignedReplicas)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)replicaId -> this.removeReplica(replicaId));
            this.inSyncReplicas_$eq((Set<Replica>)Predef$.MODULE$.Set().empty());
            this.leaderEpoch_$eq(partitionStateInfo$2.basePartitionState.leaderEpoch);
            this.zkVersion_$eq(partitionStateInfo$2.basePartitionState.zkVersion);
            if (this.leaderReplicaIdOpt().isDefined() && BoxesRunTime.unboxToInt((Object)this.leaderReplicaIdOpt().get()) == newLeaderBrokerId) {
                bl = false;
            } else {
                this.leaderReplicaIdOpt_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)newLeaderBrokerId)));
                bl = true;
            }
            return bl;
        }));
    }

    public boolean updateReplicaLogReadResult(Replica replica, LogReadResult logReadResult) {
        boolean result;
        int replicaId = replica.brokerId();
        long oldLeaderLW = this.kafka$cluster$Partition$$replicaManager.delayedDeleteRecordsPurgatory().delayed() > 0 ? this.lowWatermarkIfLeader() : -1L;
        replica.updateLogReadResult(logReadResult);
        long newLeaderLW = this.kafka$cluster$Partition$$replicaManager.delayedDeleteRecordsPurgatory().delayed() > 0 ? this.lowWatermarkIfLeader() : -1L;
        boolean leaderLWIncremented = newLeaderLW > oldLeaderLW;
        boolean leaderHWIncremented = this.maybeExpandIsr(replicaId, logReadResult);
        boolean bl = result = leaderLWIncremented || leaderHWIncremented;
        if (result) {
            this.tryCompleteDelayedRequests();
        }
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(49).append("Recorded replica ").append(replicaId).append(" log end offset (LEO) position ").append(logReadResult.info().fetchOffsetMetadata().messageOffset()).append(".").toString());
        return result;
    }

    public boolean maybeExpandIsr(int replicaId, LogReadResult logReadResult) {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inWriteLock(this.leaderIsrUpdateLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            boolean bl;
            Option<Replica> option = this.leaderReplicaIfLocal();
            if (option instanceof Some) {
                Some some = (Some)option;
                Replica leaderReplica = (Replica)some.value();
                Replica replica = (Replica)this.getReplica(replicaId).get();
                LogOffsetMetadata leaderHW = leaderReplica.highWatermark();
                if (!this.inSyncReplicas().contains((Object)replica) && ((SetLike)this.assignedReplicas().map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11.brokerId()), Set$.MODULE$.canBuildFrom())).contains((Object)BoxesRunTime.boxToInteger((int)replicaId)) && replica.logEndOffset().offsetDiff(leaderHW) >= 0L) {
                    Set newInSyncReplicas = (Set)this.inSyncReplicas().$plus((Object)replica);
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(20).append("Expanding ISR from ").append(((TraversableOnce)this.inSyncReplicas().map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.brokerId()), Set$.MODULE$.canBuildFrom())).mkString(",")).append(" ").append(new java.lang.StringBuilder(3).append("to ").append(((TraversableOnce)newInSyncReplicas.map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToInteger((int)x$13.brokerId()), Set$.MODULE$.canBuildFrom())).mkString(",")).toString()).toString());
                    this.updateIsr((Set<Replica>)newInSyncReplicas);
                    $this.kafka$cluster$Partition$$replicaManager.isrExpandRate().mark();
                }
                bl = this.maybeIncrementLeaderHW(leaderReplica, logReadResult.fetchTimeMs());
            } else if (None$.MODULE$.equals(option)) {
                bl = false;
            } else {
                throw new MatchError(option);
            }
            return bl;
        }));
    }

    public Tuple2<Object, Errors> checkEnoughReplicasReachOffset(long requiredOffset) {
        Tuple2 tuple2;
        Option<Replica> option = this.leaderReplicaIfLocal();
        if (option instanceof Some) {
            Some some = (Some)option;
            Replica leaderReplica = (Replica)some.value();
            Set<Replica> curInSyncReplicas = this.inSyncReplicas();
            if (this.isTraceEnabled()) {
                Tuple2 tuple22 = curInSyncReplicas.partition((Function1 & Serializable & scala.Serializable)replica -> BoxesRunTime.boxToBoolean((boolean)Partition.$anonfun$checkEnoughReplicasReachOffset$1(requiredOffset, replica)));
                if (tuple22 == null) {
                    throw new MatchError((Object)tuple22);
                }
                Set ackedReplicas = (Set)tuple22._1();
                Set awaitingReplicas = (Set)tuple22._2();
                Tuple2 tuple23 = new Tuple2((Object)ackedReplicas, (Object)awaitingReplicas);
                Tuple2 tuple24 = tuple23;
                Set ackedReplicas2 = (Set)tuple24._1();
                Set awaitingReplicas2 = (Set)tuple24._2();
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(49).append("Progress awaiting ISR acks for offset ").append(requiredOffset).append(": acked: ").append(ackedReplicas2.map((Function1 & Serializable & scala.Serializable)r -> Partition.logEndOffsetString$1(r), Set$.MODULE$.canBuildFrom())).append(", ").append(new java.lang.StringBuilder(9).append("awaiting ").append(awaitingReplicas2.map((Function1 & Serializable & scala.Serializable)r -> Partition.logEndOffsetString$1(r), Set$.MODULE$.canBuildFrom())).toString()).toString());
            }
            Integer minIsr = ((Log)leaderReplica.log().get()).config().minInSyncReplicas();
            tuple2 = leaderReplica.highWatermark().messageOffset() >= requiredOffset ? (Predef$.MODULE$.Integer2int(minIsr) <= curInSyncReplicas.size() ? new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)Errors.NONE) : new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND)) : new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)Errors.NONE);
        } else if (None$.MODULE$.equals(option)) {
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)Errors.NOT_LEADER_FOR_PARTITION);
        } else {
            throw new MatchError(option);
        }
        return tuple2;
    }

    private boolean maybeIncrementLeaderHW(Replica leaderReplica, long curTime) {
        boolean bl;
        Set allLogEndOffsets = (Set)((SetLike)this.assignedReplicas().filter((Function1 & Serializable & scala.Serializable)replica -> BoxesRunTime.boxToBoolean((boolean)Partition.$anonfun$maybeIncrementLeaderHW$1(this, curTime, replica)))).map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.logEndOffset(), Set$.MODULE$.canBuildFrom());
        LogOffsetMetadata newHighWatermark = (LogOffsetMetadata)allLogEndOffsets.min((Ordering)new LogOffsetMetadata.OffsetOrdering());
        LogOffsetMetadata oldHighWatermark = leaderReplica.highWatermark();
        if (oldHighWatermark.messageOffset() < newHighWatermark.messageOffset() || oldHighWatermark.messageOffset() == newHighWatermark.messageOffset() && oldHighWatermark.onOlderSegment(newHighWatermark)) {
            leaderReplica.highWatermark_$eq(newHighWatermark);
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(26).append("High watermark updated to ").append(newHighWatermark).toString());
            bl = true;
        } else {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(73).append("Skipping update high watermark since new hw ").append(newHighWatermark).append(" is not larger than old hw ").append(oldHighWatermark).append(". ").append(new java.lang.StringBuilder(21).append("All current LEOs are ").append(this.assignedReplicas().map((Function1 & Serializable & scala.Serializable)r -> Partition.logEndOffsetString$2(r), Set$.MODULE$.canBuildFrom())).toString()).toString());
            bl = false;
        }
        return bl;
    }

    private long maybeIncrementLeaderHW$default$2() {
        return this.time.milliseconds();
    }

    public long lowWatermarkIfLeader() {
        if (!this.kafka$cluster$Partition$$isLeaderReplicaLocal()) {
            throw new NotLeaderForPartitionException(new java.lang.StringBuilder(42).append("Leader not local for partition ").append(this.topicPartition()).append(" on broker ").append(this.localBrokerId()).toString());
        }
        Set logStartOffsets = (Set)this.allReplicas().collect((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Partition $outer;

            public final <A1 extends Replica, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = this.$outer.kafka$cluster$Partition$$replicaManager.metadataCache().isBrokerAlive(A1.brokerId()) || A1.brokerId() == Request$.MODULE$.FutureLocalReplicaId() ? BoxesRunTime.boxToLong((long)A1.logStartOffset()) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Replica x1) {
                Replica replica = x1;
                boolean bl = this.$outer.kafka$cluster$Partition$$replicaManager.metadataCache().isBrokerAlive(replica.brokerId()) || replica.brokerId() == Request$.MODULE$.FutureLocalReplicaId();
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Set$.MODULE$.canBuildFrom());
        return BoxesRunTime.unboxToLong((Object)CoreUtils$.MODULE$.min(logStartOffsets, BoxesRunTime.boxToLong((long)0L), Ordering.Long$.MODULE$));
    }

    private void tryCompleteDelayedRequests() {
        TopicPartitionOperationKey requestKey = new TopicPartitionOperationKey(this.topicPartition());
        this.kafka$cluster$Partition$$replicaManager.tryCompleteDelayedFetch(requestKey);
        this.kafka$cluster$Partition$$replicaManager.tryCompleteDelayedProduce(requestKey);
        this.kafka$cluster$Partition$$replicaManager.tryCompleteDelayedDeleteRecords(requestKey);
    }

    public void maybeShrinkIsr(long replicaMaxLagTimeMs) {
        block0: {
            boolean leaderHWIncremented = BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inWriteLock(this.leaderIsrUpdateLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                boolean bl;
                Option<Replica> option = this.leaderReplicaIfLocal();
                if (option instanceof Some) {
                    boolean bl2;
                    Some some = (Some)option;
                    Replica leaderReplica = (Replica)some.value();
                    Set<Replica> outOfSyncReplicas = this.getOutOfSyncReplicas(leaderReplica, replicaMaxLagTimeMs);
                    if (outOfSyncReplicas.nonEmpty()) {
                        Set newInSyncReplicas = (Set)this.inSyncReplicas().$minus$minus(outOfSyncReplicas);
                        Predef$.MODULE$.assert(newInSyncReplicas.nonEmpty());
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Shrinking ISR from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)this.inSyncReplicas().map((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToInteger((int)x$16.brokerId()), Set$.MODULE$.canBuildFrom())).mkString(","), ((TraversableOnce)newInSyncReplicas.map((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToInteger((int)x$17.brokerId()), Set$.MODULE$.canBuildFrom())).mkString(",")})));
                        this.updateIsr((Set<Replica>)newInSyncReplicas);
                        $this.kafka$cluster$Partition$$replicaManager.isrShrinkRate().mark();
                        bl2 = this.maybeIncrementLeaderHW(leaderReplica, this.maybeIncrementLeaderHW$default$2());
                    } else {
                        bl2 = false;
                    }
                    bl = bl2;
                } else if (None$.MODULE$.equals(option)) {
                    bl = false;
                } else {
                    throw new MatchError(option);
                }
                return bl;
            }));
            if (!leaderHWIncremented) break block0;
            this.tryCompleteDelayedRequests();
        }
    }

    public Set<Replica> getOutOfSyncReplicas(Replica leaderReplica, long maxLagMs) {
        Set laggingReplicas;
        block0: {
            Set candidateReplicas = (Set)this.inSyncReplicas().$minus((Object)leaderReplica);
            laggingReplicas = (Set)candidateReplicas.filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)Partition.$anonfun$getOutOfSyncReplicas$1(this, maxLagMs, r)));
            if (!laggingReplicas.nonEmpty()) break block0;
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Lagging replicas are %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)laggingReplicas.map((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToInteger((int)x$18.brokerId()), Set$.MODULE$.canBuildFrom())).mkString(",")})));
        }
        return laggingReplicas;
    }

    private void doAppendRecordsToFollowerOrFutureReplica(MemoryRecords records, boolean isFuture) {
        CoreUtils$.MODULE$.inReadLock(this.leaderIsrUpdateLock(), (Function0 & Serializable & scala.Serializable)() -> isFuture ? CoreUtils$.MODULE$.inReadLock(this.leaderIsrUpdateLock(), (Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            Option<Replica> option = this.getReplica(Request$.MODULE$.FutureLocalReplicaId());
            if (option instanceof Some) {
                Some some = (Some)option;
                Replica replica = (Replica)some.value();
                object = ((Log)replica.log().get()).appendAsFollower(records);
            } else if (None$.MODULE$.equals(option)) {
                object = BoxedUnit.UNIT;
            } else {
                throw new MatchError(option);
            }
            return object;
        }) : ((Log)this.getReplicaOrException(this.getReplicaOrException$default$1()).log().get()).appendAsFollower(records));
    }

    public void appendRecordsToFollowerOrFutureReplica(MemoryRecords records, boolean isFuture) {
        try {
            this.doAppendRecordsToFollowerOrFutureReplica(records, isFuture);
        }
        catch (UnexpectedAppendOffsetException e) {
            Replica replica = isFuture ? this.getReplicaOrException(Request$.MODULE$.FutureLocalReplicaId()) : this.getReplicaOrException(this.getReplicaOrException$default$1());
            long logEndOffset = replica.logEndOffset().messageOffset();
            if (logEndOffset == replica.logStartOffset() && e.firstOffset() < logEndOffset && e.lastOffset() >= logEndOffset) {
                String replicaName = isFuture ? "future replica" : "follower";
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(78).append("Unexpected offset in append to ").append(this.topicPartition()).append(". First offset ").append(e.firstOffset()).append(" is less than log start offset ").append(replica.logStartOffset()).append(".").append(new java.lang.StringBuilder(94).append(" Since this is the first record to be appended to the ").append(replicaName).append("'s log, will start the log from offset ").append(e.firstOffset()).append(".").toString()).toString());
                this.truncateFullyAndStartAt(e.firstOffset(), isFuture);
                this.doAppendRecordsToFollowerOrFutureReplica(records, isFuture);
            }
            throw e;
        }
    }

    public LogAppendInfo appendRecordsToLeader(MemoryRecords records, boolean isFromClient, int requiredAcks) {
        LogAppendInfo info;
        block1: {
            Tuple2 tuple2 = (Tuple2)CoreUtils$.MODULE$.inReadLock(this.leaderIsrUpdateLock(), (Function0 & Serializable & scala.Serializable)() -> {
                Log log;
                Replica leaderReplica;
                Option<Replica> option = this.leaderReplicaIfLocal();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    leaderReplica = (Replica)some.value();
                    log = (Log)leaderReplica.log().get();
                    Integer minIsr = log.config().minInSyncReplicas();
                    int inSyncSize = this.inSyncReplicas().size();
                    if (inSyncSize < Predef$.MODULE$.Integer2int(minIsr) && requiredAcks == -1) {
                        throw new NotEnoughReplicasException(new StringOps(Predef$.MODULE$.augmentString("Number of insync replicas for partition %s is [%d], below required minimum [%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), BoxesRunTime.boxToInteger((int)inSyncSize), minIsr})));
                    }
                } else {
                    if (None$.MODULE$.equals(option)) {
                        throw new NotLeaderForPartitionException(new StringOps(Predef$.MODULE$.augmentString("Leader not local for partition %s on broker %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), BoxesRunTime.boxToInteger((int)this.localBrokerId())})));
                    }
                    throw new MatchError(option);
                }
                LogAppendInfo info = log.appendAsLeader(records, this.leaderEpoch(), isFromClient);
                $this.kafka$cluster$Partition$$replicaManager.tryCompleteDelayedFetch(new TopicPartitionOperationKey(this.topic(), this.partitionId()));
                Tuple2 tuple2 = new Tuple2((Object)info, (Object)BoxesRunTime.boxToBoolean((boolean)this.maybeIncrementLeaderHW(leaderReplica, this.maybeIncrementLeaderHW$default$2())));
                return tuple2;
            });
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            LogAppendInfo info2 = (LogAppendInfo)tuple2._1();
            boolean leaderHWIncremented = tuple2._2$mcZ$sp();
            Tuple2 tuple22 = new Tuple2((Object)info2, (Object)BoxesRunTime.boxToBoolean((boolean)leaderHWIncremented));
            Tuple2 tuple23 = tuple22;
            info = (LogAppendInfo)tuple23._1();
            boolean leaderHWIncremented2 = tuple23._2$mcZ$sp();
            if (!leaderHWIncremented2) break block1;
            this.tryCompleteDelayedRequests();
        }
        return info;
    }

    public int appendRecordsToLeader$default$3() {
        return 0;
    }

    public long logStartOffset() {
        return BoxesRunTime.unboxToLong(CoreUtils$.MODULE$.inReadLock(this.leaderIsrUpdateLock(), (JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToLong((Object)this.leaderReplicaIfLocal().map((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToLong((long)Partition.$anonfun$logStartOffset$2(x$20))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L))));
    }

    public long deleteRecordsOnLeader(long offset) {
        return BoxesRunTime.unboxToLong(CoreUtils$.MODULE$.inReadLock(this.leaderIsrUpdateLock(), (JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> {
            Replica leaderReplica;
            Option<Replica> option = this.leaderReplicaIfLocal();
            if (option instanceof Some) {
                Some some = (Some)option;
                leaderReplica = (Replica)some.value();
                if (!((Log)leaderReplica.log().get()).config().delete()) {
                    throw new PolicyViolationException(new StringOps(Predef$.MODULE$.augmentString("Records of partition %s can not be deleted due to the configured policy")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition()})));
                }
            } else {
                if (None$.MODULE$.equals(option)) {
                    throw new NotLeaderForPartitionException(new StringOps(Predef$.MODULE$.augmentString("Leader not local for partition %s on broker %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), BoxesRunTime.boxToInteger((int)this.localBrokerId())})));
                }
                throw new MatchError(option);
            }
            leaderReplica.maybeIncrementLogStartOffset(offset);
            long l = this.lowWatermarkIfLeader();
            return l;
        }));
    }

    public void truncateTo(long offset, boolean isFuture) {
        CoreUtils$.MODULE$.inReadLock(this.leaderIsrUpdateLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.logManager().truncateTo((Map<TopicPartition, Object>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)BoxesRunTime.boxToLong((long)offset))}))), isFuture));
    }

    public void truncateFullyAndStartAt(long newOffset, boolean isFuture) {
        CoreUtils$.MODULE$.inReadLock(this.leaderIsrUpdateLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.logManager().truncateFullyAndStartAt(this.topicPartition(), newOffset, isFuture));
    }

    public EpochEndOffset lastOffsetForLeaderEpoch(int leaderEpoch) {
        return (EpochEndOffset)CoreUtils$.MODULE$.inReadLock(this.leaderIsrUpdateLock(), (Function0 & Serializable & scala.Serializable)() -> {
            EpochEndOffset epochEndOffset;
            Option<Replica> option = this.leaderReplicaIfLocal();
            if (option instanceof Some) {
                Some some = (Some)option;
                Replica leaderReplica = (Replica)some.value();
                Tuple2<Object, Object> tuple2 = ((LeaderEpochCache)leaderReplica.epochs().get()).endOffsetFor(leaderEpoch);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                int epoch = tuple2._1$mcI$sp();
                long offset = tuple2._2$mcJ$sp();
                Tuple2.mcIJ.sp sp2 = new Tuple2.mcIJ.sp(epoch, offset);
                Tuple2.mcIJ.sp sp3 = sp2;
                int epoch2 = sp3._1$mcI$sp();
                long offset2 = sp3._2$mcJ$sp();
                epochEndOffset = new EpochEndOffset(Errors.NONE, epoch2, offset2);
            } else if (None$.MODULE$.equals(option)) {
                epochEndOffset = new EpochEndOffset(Errors.NOT_LEADER_FOR_PARTITION, -1, -1L);
            } else {
                throw new MatchError(option);
            }
            return epochEndOffset;
        });
    }

    private void updateIsr(Set<Replica> newIsr) {
        LeaderAndIsr newLeaderAndIsr = new LeaderAndIsr(this.localBrokerId(), this.leaderEpoch(), (List<Object>)((TraversableOnce)newIsr.map((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToInteger((int)x$22.brokerId()), Set$.MODULE$.canBuildFrom())).toList(), this.zkVersion());
        Tuple2<Object, Object> tuple2 = ReplicationUtils$.MODULE$.updateLeaderAndIsr(this.zkClient(), this.topicPartition(), newLeaderAndIsr, this.controllerEpoch());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        boolean updateSucceeded = tuple2._1$mcZ$sp();
        int newVersion = tuple2._2$mcI$sp();
        Tuple2.mcZI.sp sp2 = new Tuple2.mcZI.sp(updateSucceeded, newVersion);
        Tuple2.mcZI.sp sp3 = sp2;
        boolean updateSucceeded2 = sp3._1$mcZ$sp();
        int newVersion2 = sp3._2$mcI$sp();
        if (updateSucceeded2) {
            this.kafka$cluster$Partition$$replicaManager.recordIsrChange(this.topicPartition());
            this.inSyncReplicas_$eq(newIsr);
            this.zkVersion_$eq(newVersion2);
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("ISR updated to [%s] and zkVersion updated to [%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newIsr.mkString(","), BoxesRunTime.boxToInteger((int)this.zkVersion())})));
        } else {
            this.kafka$cluster$Partition$$replicaManager.failedIsrUpdatesRate().mark();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Cached zkVersion [%d] not equal to that in zookeeper, skip updating ISR")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.zkVersion())})));
        }
    }

    public void removePartitionMetrics() {
        this.removeMetric("UnderReplicated", this.tags());
        this.removeMetric("UnderMinIsr", this.tags());
        this.removeMetric("InSyncReplicasCount", this.tags());
        this.removeMetric("ReplicasCount", this.tags());
        this.removeMetric("LastStableOffsetLag", this.tags());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        Object object = that;
        if (!(object instanceof Partition)) return false;
        Partition partition = (Partition)object;
        if (this.partitionId() != partition.partitionId()) return false;
        String string = this.topic();
        String string2 = partition.topic();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.isOffline() != partition.isOffline()) return false;
        return true;
    }

    public int hashCode() {
        return 31 + this.topic().hashCode() + 17 * this.partitionId() + (this.isOffline() ? 1 : 0);
    }

    public String toString() {
        StringBuilder partitionString = new StringBuilder();
        partitionString.append(new java.lang.StringBuilder(7).append("Topic: ").append(this.topic()).toString());
        partitionString.append(new java.lang.StringBuilder(13).append("; Partition: ").append(this.partitionId()).toString());
        partitionString.append(new java.lang.StringBuilder(10).append("; Leader: ").append(this.leaderReplicaIdOpt()).toString());
        partitionString.append(new java.lang.StringBuilder(15).append("; AllReplicas: ").append(this.allReplicasMap().keys().mkString(",")).toString());
        partitionString.append(new java.lang.StringBuilder(18).append("; InSyncReplicas: ").append(((TraversableOnce)this.inSyncReplicas().map((Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToInteger((int)x$24.brokerId()), Set$.MODULE$.canBuildFrom())).mkString(",")).toString());
        return partitionString.toString();
    }

    public static final /* synthetic */ void $anonfun$makeLeader$10(Partition $this, long curLeaderLogEndOffset$1, long curTimeMs$1, Replica replica) {
        long lastCaughtUpTimeMs = $this.inSyncReplicas().contains((Object)replica) ? curTimeMs$1 : 0L;
        replica.resetLastCaughtUpTime(curLeaderLogEndOffset$1, curTimeMs$1, lastCaughtUpTimeMs);
    }

    public static final /* synthetic */ boolean $anonfun$makeLeader$11(Partition $this, Replica x$6) {
        return x$6.brokerId() != $this.localBrokerId();
    }

    private static final String logEndOffsetString$1(Replica r) {
        return new java.lang.StringBuilder(9).append("broker ").append(r.brokerId()).append(": ").append(r.logEndOffset().messageOffset()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$checkEnoughReplicasReachOffset$1(long requiredOffset$1, Replica replica) {
        return replica.logEndOffset().messageOffset() >= requiredOffset$1;
    }

    public static final /* synthetic */ boolean $anonfun$maybeIncrementLeaderHW$1(Partition $this, long curTime$1, Replica replica) {
        return curTime$1 - replica.lastCaughtUpTimeMs() <= Predef$.MODULE$.Long2long($this.kafka$cluster$Partition$$replicaManager.config().replicaLagTimeMaxMs()) || $this.inSyncReplicas().contains((Object)replica);
    }

    private static final String logEndOffsetString$2(Replica r) {
        return new java.lang.StringBuilder(10).append("replica ").append(r.brokerId()).append(": ").append(r.logEndOffset()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$getOutOfSyncReplicas$1(Partition $this, long maxLagMs$1, Replica r) {
        return $this.time.milliseconds() - r.lastCaughtUpTimeMs() > maxLagMs$1;
    }

    public static final /* synthetic */ long $anonfun$logStartOffset$2(Replica x$20) {
        return ((Log)x$20.log().get()).logStartOffset();
    }

    public Partition(String topic, int partitionId, Time time, ReplicaManager replicaManager, boolean isOffline) {
        Gauge<Object> gauge;
        this.topic = topic;
        this.partitionId = partitionId;
        this.time = time;
        this.kafka$cluster$Partition$$replicaManager = replicaManager;
        this.isOffline = isOffline;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.topicPartition = new TopicPartition(topic, partitionId);
        this.localBrokerId = !isOffline ? replicaManager.config().brokerId() : -1;
        this.logManager = !isOffline ? replicaManager.logManager() : null;
        this.zkClient = !isOffline ? replicaManager.zkClient() : null;
        this.allReplicasMap = new Pool(Pool$.MODULE$.$lessinit$greater$default$1());
        this.leaderIsrUpdateLock = new ReentrantReadWriteLock();
        this.zkVersion = LeaderAndIsr$.MODULE$.initialZKVersion();
        this.leaderEpoch = LeaderAndIsr$.MODULE$.initialLeaderEpoch() - 1;
        this.leaderReplicaIdOpt = None$.MODULE$;
        this.inSyncReplicas = Predef$.MODULE$.Set().empty();
        this.controllerEpoch = KafkaController$.MODULE$.InitialControllerEpoch() - 1;
        this.logIdent_$eq(new java.lang.StringBuilder(21).append("[Partition ").append(this.topicPartition()).append(" broker=").append(this.localBrokerId()).append("] ").toString());
        this.tags = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)topic), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partition"), (Object)((Object)BoxesRunTime.boxToInteger((int)partitionId)).toString())}));
        if (!isOffline) {
            this.newGauge("UnderReplicated", new Gauge<Object>(this){
                private final /* synthetic */ Partition $outer;

                public int value() {
                    return this.$outer.isUnderReplicated() ? 1 : 0;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, this.tags());
            this.newGauge("InSyncReplicasCount", new Gauge<Object>(this){
                private final /* synthetic */ Partition $outer;

                public int value() {
                    return this.$outer.kafka$cluster$Partition$$isLeaderReplicaLocal() ? this.$outer.inSyncReplicas().size() : 0;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, this.tags());
            this.newGauge("UnderMinIsr", new Gauge<Object>(this){
                private final /* synthetic */ Partition $outer;

                public int value() {
                    return this.$outer.isUnderMinIsr() ? 1 : 0;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, this.tags());
            this.newGauge("ReplicasCount", new Gauge<Object>(this){
                private final /* synthetic */ Partition $outer;

                public int value() {
                    return this.$outer.kafka$cluster$Partition$$isLeaderReplicaLocal() ? this.$outer.assignedReplicas().size() : 0;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, this.tags());
            gauge = this.newGauge("LastStableOffsetLag", new Gauge<Object>(this){
                private final /* synthetic */ Partition $outer;

                public long value() {
                    return BoxesRunTime.unboxToLong((Object)this.$outer.leaderReplicaIfLocal().map((Function1 & Serializable & scala.Serializable)replica -> BoxesRunTime.boxToLong((long)$anon$5.$anonfun$value$1(replica))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
                }

                public static final /* synthetic */ long $anonfun$value$1(Replica replica) {
                    return replica.highWatermark().messageOffset() - replica.lastStableOffset().messageOffset();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$1$adapted(kafka.cluster.Replica ), $anonfun$value$2()}, serializedLambda);
                }
            }, this.tags());
        } else {
            gauge = BoxedUnit.UNIT;
        }
    }
}

