/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions.gui;

import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.apache.jmeter.assertions.SizeAssertion;
import org.apache.jmeter.assertions.gui.AbstractAssertionGui;
import org.apache.jmeter.gui.GUIMenuSortOrder;
import org.apache.jmeter.testelement.AbstractScopedTestElement;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.layout.VerticalLayout;

@GUIMenuSortOrder(value=3)
public class SizeAssertionGui
extends AbstractAssertionGui
implements ActionListener {
    private static final long serialVersionUID = 241L;
    private JRadioButton responseBodyButton;
    private JRadioButton responseNetworkButton;
    private JRadioButton responseMessageButton;
    private JRadioButton responseCodeButton;
    private JRadioButton responseHeadersButton;
    private JTextField size;
    private JRadioButton equalButton;
    private JRadioButton notequalButton;
    private JRadioButton greaterthanButton;
    private JRadioButton lessthanButton;
    private JRadioButton greaterthanequalButton;
    private JRadioButton lessthanequalButton;
    private int execState;

    public SizeAssertionGui() {
        this.init();
    }

    public String getLabelResource() {
        return "size_assertion_title";
    }

    public TestElement createTestElement() {
        SizeAssertion el = new SizeAssertion();
        this.modifyTestElement((TestElement)el);
        return el;
    }

    public void modifyTestElement(TestElement el) {
        this.configureTestElement(el);
        SizeAssertion assertion = (SizeAssertion)el;
        if (this.responseHeadersButton.isSelected()) {
            assertion.setTestFieldResponseHeaders();
        } else if (this.responseBodyButton.isSelected()) {
            assertion.setTestFieldResponseBody();
        } else if (this.responseCodeButton.isSelected()) {
            assertion.setTestFieldResponseCode();
        } else if (this.responseMessageButton.isSelected()) {
            assertion.setTestFieldResponseMessage();
        } else {
            assertion.setTestFieldNetworkSize();
        }
        assertion.setAllowedSize(this.size.getText());
        assertion.setCompOper(this.getState());
        this.saveScopeSettings((AbstractScopedTestElement)assertion);
    }

    public void clearGui() {
        super.clearGui();
        this.responseNetworkButton.setSelected(true);
        this.responseHeadersButton.setSelected(false);
        this.responseBodyButton.setSelected(false);
        this.responseCodeButton.setSelected(false);
        this.responseMessageButton.setSelected(false);
        this.size.setText("");
        this.equalButton.setSelected(true);
        this.notequalButton.setSelected(false);
        this.greaterthanButton.setSelected(false);
        this.lessthanButton.setSelected(false);
        this.greaterthanequalButton.setSelected(false);
        this.lessthanequalButton.setSelected(false);
        this.execState = 1;
    }

    public void configure(TestElement el) {
        super.configure(el);
        SizeAssertion assertion = (SizeAssertion)el;
        this.size.setText(assertion.getAllowedSize());
        this.setState(assertion.getCompOper());
        this.showScopeSettings((AbstractScopedTestElement)assertion, true);
        if (assertion.isTestFieldResponseHeaders()) {
            this.responseHeadersButton.setSelected(true);
        } else if (assertion.isTestFieldResponseBody()) {
            this.responseBodyButton.setSelected(true);
        } else if (assertion.isTestFieldResponseCode()) {
            this.responseCodeButton.setSelected(true);
        } else if (assertion.isTestFieldResponseMessage()) {
            this.responseMessageButton.setSelected(true);
        } else {
            this.responseNetworkButton.setSelected(true);
        }
    }

    public void setState(int state) {
        if (state == 1) {
            this.equalButton.setSelected(true);
            this.execState = state;
        } else if (state == 2) {
            this.notequalButton.setSelected(true);
            this.execState = state;
        } else if (state == 3) {
            this.greaterthanButton.setSelected(true);
            this.execState = state;
        } else if (state == 4) {
            this.lessthanButton.setSelected(true);
            this.execState = state;
        } else if (state == 5) {
            this.greaterthanequalButton.setSelected(true);
            this.execState = state;
        } else if (state == 6) {
            this.lessthanequalButton.setSelected(true);
            this.execState = state;
        }
    }

    public int getState() {
        return this.execState;
    }

    private void init() {
        this.setLayout((LayoutManager)new VerticalLayout(5, 3, 1));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel());
        this.add(this.createScopePanel(true));
        this.add(this.createFieldPanel());
        JPanel sizePanel = new JPanel();
        sizePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"size_assertion_size_test")));
        sizePanel.add(new JLabel(JMeterUtils.getResString((String)"size_assertion_label")));
        this.size = new JTextField(12);
        sizePanel.add(this.size);
        sizePanel.add(this.createComparatorButtonPanel());
        this.add(sizePanel);
    }

    private JPanel createFieldPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"assertion_resp_size_field")));
        this.responseNetworkButton = new JRadioButton(JMeterUtils.getResString((String)"assertion_network_size"));
        this.responseHeadersButton = new JRadioButton(JMeterUtils.getResString((String)"assertion_headers"));
        this.responseBodyButton = new JRadioButton(JMeterUtils.getResString((String)"assertion_body_resp"));
        this.responseCodeButton = new JRadioButton(JMeterUtils.getResString((String)"assertion_code_resp"));
        this.responseMessageButton = new JRadioButton(JMeterUtils.getResString((String)"assertion_message_resp"));
        ButtonGroup group = new ButtonGroup();
        group.add(this.responseNetworkButton);
        group.add(this.responseHeadersButton);
        group.add(this.responseBodyButton);
        group.add(this.responseCodeButton);
        group.add(this.responseMessageButton);
        panel.add(this.responseNetworkButton);
        panel.add(this.responseHeadersButton);
        panel.add(this.responseBodyButton);
        panel.add(this.responseCodeButton);
        panel.add(this.responseMessageButton);
        this.responseNetworkButton.setSelected(true);
        return panel;
    }

    private Box createComparatorButtonPanel() {
        ButtonGroup group = new ButtonGroup();
        this.equalButton = this.createComparatorButton("=", 1, group);
        this.notequalButton = this.createComparatorButton("!=", 2, group);
        this.greaterthanButton = this.createComparatorButton(">", 3, group);
        this.lessthanButton = this.createComparatorButton("<", 4, group);
        this.greaterthanequalButton = this.createComparatorButton(">=", 5, group);
        this.lessthanequalButton = this.createComparatorButton("<=", 6, group);
        this.equalButton.setSelected(true);
        this.execState = Integer.parseInt(this.equalButton.getActionCommand());
        Box checkPanel = Box.createVerticalBox();
        JLabel compareLabel = new JLabel(JMeterUtils.getResString((String)"size_assertion_comparator_label"));
        checkPanel.add(compareLabel);
        checkPanel.add(this.equalButton);
        checkPanel.add(this.notequalButton);
        checkPanel.add(this.greaterthanButton);
        checkPanel.add(this.lessthanButton);
        checkPanel.add(this.greaterthanequalButton);
        checkPanel.add(this.lessthanequalButton);
        return checkPanel;
    }

    private JRadioButton createComparatorButton(String name, int value, ButtonGroup group) {
        JRadioButton button = new JRadioButton(name);
        button.setActionCommand(String.valueOf(value));
        button.addActionListener(this);
        group.add(button);
        return button;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int comparator;
        this.execState = comparator = Integer.parseInt(e.getActionCommand());
    }
}

