/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.columnstats.aggr;

import java.util.List;
import org.apache.hadoop.hive.metastore.api.BinaryColumnStatsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.columnstats.aggr.ColumnStatsAggregator;
import org.apache.hadoop.hive.metastore.columnstats.aggr.ColumnStatsAggregatorFactory;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;

public class BinaryColumnStatsAggregator
extends ColumnStatsAggregator {
    @Override
    public ColumnStatisticsObj aggregate(List<MetaStoreUtils.ColStatsObjWithSourceInfo> colStatsWithSourceInfo, List<String> partNames, boolean areAllPartsFound) throws MetaException {
        ColumnStatisticsObj statsObj = null;
        String colType = null;
        String colName = null;
        BinaryColumnStatsData aggregateData = null;
        for (MetaStoreUtils.ColStatsObjWithSourceInfo csp : colStatsWithSourceInfo) {
            ColumnStatisticsObj cso = csp.getColStatsObj();
            if (statsObj == null) {
                colName = cso.getColName();
                colType = cso.getColType();
                statsObj = ColumnStatsAggregatorFactory.newColumnStaticsObj(colName, colType, (ColumnStatisticsData._Fields)cso.getStatsData().getSetField());
            }
            BinaryColumnStatsData newData = cso.getStatsData().getBinaryStats();
            if (aggregateData == null) {
                aggregateData = newData.deepCopy();
                continue;
            }
            aggregateData.setMaxColLen(Math.max(aggregateData.getMaxColLen(), newData.getMaxColLen()));
            aggregateData.setAvgColLen(Math.max(aggregateData.getAvgColLen(), newData.getAvgColLen()));
            aggregateData.setNumNulls(aggregateData.getNumNulls() + newData.getNumNulls());
        }
        ColumnStatisticsData columnStatisticsData = new ColumnStatisticsData();
        columnStatisticsData.setBinaryStats(aggregateData);
        statsObj.setStatsData(columnStatisticsData);
        return statsObj;
    }
}

