/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.replication.ReplicationEndpoint;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.VerifyWALEntriesReplicationEndpoint;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ReplicationTests.class, MediumTests.class})
public class TestVerifyCellsReplicationEndpoint {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestVerifyCellsReplicationEndpoint.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestVerifyCellsReplicationEndpoint.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final TableName TABLE_NAME = TableName.valueOf((String)"empty");
    private static final byte[] CF = Bytes.toBytes((String)"family");
    private static final byte[] CQ = Bytes.toBytes((String)"qualifier");
    private static final String PEER_ID = "empty";
    private static final BlockingQueue<Cell> CELLS = new LinkedBlockingQueue<Cell>();

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.startMiniCluster(3);
        UTIL.createTable(TABLE_NAME, CF);
        UTIL.getAdmin().addReplicationPeer(PEER_ID, ReplicationPeerConfig.newBuilder().setClusterKey("zk1:8888:/hbase").setReplicationEndpointImpl(EndpointForTest.class.getName()).build());
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void test() throws Exception {
        int i;
        try (Table table = UTIL.getConnection().getTable(TABLE_NAME);){
            for (i = 0; i < 100; ++i) {
                table.put(new Put(Bytes.toBytes((int)i)).addColumn(CF, CQ, Bytes.toBytes((int)i)));
            }
        }
        long lastNoCellTime = -1L;
        i = 0;
        while (i < 100) {
            Cell cell = (Cell)CELLS.poll();
            if (cell == null) {
                if (lastNoCellTime < 0L) {
                    lastNoCellTime = System.nanoTime();
                } else if (System.nanoTime() - lastNoCellTime >= TimeUnit.SECONDS.toNanos(30L)) {
                    throw new TimeoutException("Timeout waiting for wal edit");
                }
                Thread.sleep(1000L);
                continue;
            }
            lastNoCellTime = -1L;
            if (!Bytes.equals((byte[])CF, (byte[])CellUtil.cloneFamily((Cell)cell))) continue;
            Assert.assertArrayEquals((byte[])Bytes.toBytes((int)i), (byte[])CellUtil.cloneRow((Cell)cell));
            Assert.assertArrayEquals((byte[])CQ, (byte[])CellUtil.cloneQualifier((Cell)cell));
            Assert.assertArrayEquals((byte[])Bytes.toBytes((int)i), (byte[])CellUtil.cloneValue((Cell)cell));
            ++i;
        }
    }

    public static final class EndpointForTest
    extends VerifyWALEntriesReplicationEndpoint {
        public boolean replicate(ReplicationEndpoint.ReplicateContext replicateContext) {
            LOG.info(replicateContext.getEntries().toString());
            replicateContext.entries.stream().map(WAL.Entry::getEdit).map(WALEdit::getCells).forEachOrdered(CELLS::addAll);
            return super.replicate(replicateContext);
        }
    }
}

