/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.replication.ReplicationAdmin;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.TestReplicationBase;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSyncUp;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ReplicationTests.class, LargeTests.class})
public class TestReplicationSyncUpTool
extends TestReplicationBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReplicationSyncUpTool.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestReplicationSyncUpTool.class);
    private static final TableName t1_su = TableName.valueOf((String)"t1_syncup");
    private static final TableName t2_su = TableName.valueOf((String)"t2_syncup");
    protected static final byte[] famName = Bytes.toBytes((String)"cf1");
    private static final byte[] qualName = Bytes.toBytes((String)"q1");
    protected static final byte[] noRepfamName = Bytes.toBytes((String)"norep");
    private HTableDescriptor t1_syncupSource;
    private HTableDescriptor t1_syncupTarget;
    private HTableDescriptor t2_syncupSource;
    private HTableDescriptor t2_syncupTarget;
    protected Table ht1Source;
    protected Table ht2Source;
    protected Table ht1TargetAtPeer1;
    protected Table ht2TargetAtPeer1;

    @Before
    public void setUp() throws Exception {
        this.t1_syncupSource = new HTableDescriptor(t1_su);
        HColumnDescriptor fam = new HColumnDescriptor(famName);
        fam.setScope(1);
        this.t1_syncupSource.addFamily(fam);
        fam = new HColumnDescriptor(noRepfamName);
        this.t1_syncupSource.addFamily(fam);
        this.t1_syncupTarget = new HTableDescriptor(t1_su);
        fam = new HColumnDescriptor(famName);
        this.t1_syncupTarget.addFamily(fam);
        fam = new HColumnDescriptor(noRepfamName);
        this.t1_syncupTarget.addFamily(fam);
        this.t2_syncupSource = new HTableDescriptor(t2_su);
        fam = new HColumnDescriptor(famName);
        fam.setScope(1);
        this.t2_syncupSource.addFamily(fam);
        fam = new HColumnDescriptor(noRepfamName);
        this.t2_syncupSource.addFamily(fam);
        this.t2_syncupTarget = new HTableDescriptor(t2_su);
        fam = new HColumnDescriptor(famName);
        this.t2_syncupTarget.addFamily(fam);
        fam = new HColumnDescriptor(noRepfamName);
        this.t2_syncupTarget.addFamily(fam);
    }

    @Override
    @After
    public void tearDownBase() throws Exception {
    }

    @Test
    public void testSyncUpTool() throws Exception {
        this.setupReplication();
        this.putAndReplicateRows();
        this.mimicSyncUpAfterDelete();
        this.mimicSyncUpAfterPut();
    }

    protected void setupReplication() throws Exception {
        ReplicationAdmin admin1 = new ReplicationAdmin(conf1);
        ReplicationAdmin admin2 = new ReplicationAdmin(conf2);
        Admin ha = utility1.getAdmin();
        ha.createTable((TableDescriptor)this.t1_syncupSource);
        ha.createTable((TableDescriptor)this.t2_syncupSource);
        ha.close();
        ha = utility2.getAdmin();
        ha.createTable((TableDescriptor)this.t1_syncupTarget);
        ha.createTable((TableDescriptor)this.t2_syncupTarget);
        ha.close();
        Connection connection1 = ConnectionFactory.createConnection((Configuration)utility1.getConfiguration());
        Connection connection2 = ConnectionFactory.createConnection((Configuration)utility2.getConfiguration());
        this.ht1Source = connection1.getTable(t1_su);
        this.ht2Source = connection1.getTable(t2_su);
        this.ht1TargetAtPeer1 = connection2.getTable(t1_su);
        this.ht2TargetAtPeer1 = connection2.getTable(t2_su);
        ReplicationPeerConfig rpc = new ReplicationPeerConfig();
        rpc.setClusterKey(utility2.getClusterKey());
        admin1.addPeer("1", rpc, null);
        admin1.close();
        admin2.close();
    }

    private void putAndReplicateRows() throws Exception {
        Put p;
        int i;
        LOG.debug("putAndReplicateRows");
        for (i = 0; i < 100; ++i) {
            p = new Put(Bytes.toBytes((String)("row" + i)));
            p.addColumn(famName, qualName, Bytes.toBytes((String)("val" + i)));
            this.ht1Source.put(p);
        }
        p = new Put(Bytes.toBytes((String)"row9999"));
        p.addColumn(noRepfamName, qualName, Bytes.toBytes((String)"val9999"));
        this.ht1Source.put(p);
        for (i = 0; i < 200; ++i) {
            p = new Put(Bytes.toBytes((String)("row" + i)));
            p.addColumn(famName, qualName, Bytes.toBytes((String)("val" + i)));
            this.ht2Source.put(p);
        }
        p = new Put(Bytes.toBytes((String)"row9999"));
        p.addColumn(noRepfamName, qualName, Bytes.toBytes((String)"val9999"));
        this.ht2Source.put(p);
        Thread.sleep(500L);
        int rowCount_ht1Source = utility1.countRows(this.ht1Source);
        for (int i2 = 0; i2 < 50; ++i2) {
            int rowCount_ht1TargetAtPeer1 = utility2.countRows(this.ht1TargetAtPeer1);
            if (i2 == 49) {
                Assert.assertEquals((String)"t1_syncup has 101 rows on source, and 100 on slave1", (long)(rowCount_ht1Source - 1), (long)rowCount_ht1TargetAtPeer1);
            }
            if (rowCount_ht1Source - 1 == rowCount_ht1TargetAtPeer1) break;
            Thread.sleep(500L);
        }
        int rowCount_ht2Source = utility1.countRows(this.ht2Source);
        for (int i3 = 0; i3 < 50; ++i3) {
            int rowCount_ht2TargetAtPeer1 = utility2.countRows(this.ht2TargetAtPeer1);
            if (i3 == 49) {
                Assert.assertEquals((String)"t2_syncup has 201 rows on source, and 200 on slave1", (long)(rowCount_ht2Source - 1), (long)rowCount_ht2TargetAtPeer1);
            }
            if (rowCount_ht2Source - 1 == rowCount_ht2TargetAtPeer1) break;
            Thread.sleep(500L);
        }
    }

    private void mimicSyncUpAfterDelete() throws Exception {
        Delete del;
        String rowKey;
        int i;
        LOG.debug("mimicSyncUpAfterDelete");
        utility2.shutdownMiniHBaseCluster();
        ArrayList<Delete> list = new ArrayList<Delete>();
        for (i = 0; i < 50; ++i) {
            rowKey = "row" + i;
            del = new Delete(Bytes.toBytes((String)rowKey));
            list.add(del);
        }
        this.ht1Source.delete(list);
        for (i = 0; i < 100; ++i) {
            rowKey = "row" + i;
            del = new Delete(Bytes.toBytes((String)rowKey));
            list.add(del);
        }
        this.ht2Source.delete(list);
        int rowCount_ht1Source = utility1.countRows(this.ht1Source);
        Assert.assertEquals((String)"t1_syncup has 51 rows on source, after remove 50 of the replicated colfam", (long)51L, (long)rowCount_ht1Source);
        int rowCount_ht2Source = utility1.countRows(this.ht2Source);
        Assert.assertEquals((String)"t2_syncup has 101 rows on source, after remove 100 of the replicated colfam", (long)101L, (long)rowCount_ht2Source);
        utility1.shutdownMiniHBaseCluster();
        utility2.restartHBaseCluster(1);
        Thread.sleep(500L);
        int rowCount_ht1TargetAtPeer1 = utility2.countRows(this.ht1TargetAtPeer1);
        int rowCount_ht2TargetAtPeer1 = utility2.countRows(this.ht2TargetAtPeer1);
        Assert.assertEquals((String)"@Peer1 t1_syncup should still have 100 rows", (long)100L, (long)rowCount_ht1TargetAtPeer1);
        Assert.assertEquals((String)"@Peer1 t2_syncup should still have 200 rows", (long)200L, (long)rowCount_ht2TargetAtPeer1);
        for (int i2 = 0; i2 < 50; ++i2) {
            this.syncUp(utility1);
            rowCount_ht1TargetAtPeer1 = utility2.countRows(this.ht1TargetAtPeer1);
            rowCount_ht2TargetAtPeer1 = utility2.countRows(this.ht2TargetAtPeer1);
            if (i2 == 49) {
                if (rowCount_ht1TargetAtPeer1 != 50 || rowCount_ht2TargetAtPeer1 != 100) {
                    utility1.restartHBaseCluster(1);
                    rowCount_ht1Source = utility1.countRows(this.ht1Source);
                    LOG.debug("t1_syncup should have 51 rows at source, and it is " + rowCount_ht1Source);
                    rowCount_ht2Source = utility1.countRows(this.ht2Source);
                    LOG.debug("t2_syncup should have 101 rows at source, and it is " + rowCount_ht2Source);
                }
                Assert.assertEquals((String)"@Peer1 t1_syncup should be sync up and have 50 rows", (long)50L, (long)rowCount_ht1TargetAtPeer1);
                Assert.assertEquals((String)"@Peer1 t2_syncup should be sync up and have 100 rows", (long)100L, (long)rowCount_ht2TargetAtPeer1);
            }
            if (rowCount_ht1TargetAtPeer1 == 50 && rowCount_ht2TargetAtPeer1 == 100) {
                LOG.info("SyncUpAfterDelete succeeded at retry = " + i2);
                break;
            }
            LOG.debug("SyncUpAfterDelete failed at retry = " + i2 + ", with rowCount_ht1TargetPeer1 =" + rowCount_ht1TargetAtPeer1 + " and rowCount_ht2TargetAtPeer1 =" + rowCount_ht2TargetAtPeer1);
            Thread.sleep(500L);
        }
    }

    private void mimicSyncUpAfterPut() throws Exception {
        Put p;
        int i;
        LOG.debug("mimicSyncUpAfterPut");
        utility1.restartHBaseCluster(1);
        utility2.shutdownMiniHBaseCluster();
        for (i = 0; i < 100; ++i) {
            p = new Put(Bytes.toBytes((String)("row" + i)));
            p.addColumn(famName, qualName, Bytes.toBytes((String)("val" + i)));
            this.ht1Source.put(p);
        }
        p = new Put(Bytes.toBytes((String)"row9998"));
        p.addColumn(noRepfamName, qualName, Bytes.toBytes((String)"val9998"));
        this.ht1Source.put(p);
        for (i = 0; i < 200; ++i) {
            p = new Put(Bytes.toBytes((String)("row" + i)));
            p.addColumn(famName, qualName, Bytes.toBytes((String)("val" + i)));
            this.ht2Source.put(p);
        }
        p = new Put(Bytes.toBytes((String)"row9998"));
        p.addColumn(noRepfamName, qualName, Bytes.toBytes((String)"val9998"));
        this.ht2Source.put(p);
        int rowCount_ht1Source = utility1.countRows(this.ht1Source);
        Assert.assertEquals((String)"t1_syncup has 102 rows on source", (long)102L, (long)rowCount_ht1Source);
        int rowCount_ht2Source = utility1.countRows(this.ht2Source);
        Assert.assertEquals((String)"t2_syncup has 202 rows on source", (long)202L, (long)rowCount_ht2Source);
        utility1.shutdownMiniHBaseCluster();
        utility2.restartHBaseCluster(1);
        Thread.sleep(500L);
        int rowCount_ht1TargetAtPeer1 = utility2.countRows(this.ht1TargetAtPeer1);
        int rowCount_ht2TargetAtPeer1 = utility2.countRows(this.ht2TargetAtPeer1);
        Assert.assertEquals((String)"@Peer1 t1_syncup should be NOT sync up and have 50 rows", (long)50L, (long)rowCount_ht1TargetAtPeer1);
        Assert.assertEquals((String)"@Peer1 t2_syncup should be NOT sync up and have 100 rows", (long)100L, (long)rowCount_ht2TargetAtPeer1);
        for (int i2 = 0; i2 < 50; ++i2) {
            this.syncUp(utility1);
            rowCount_ht1TargetAtPeer1 = utility2.countRows(this.ht1TargetAtPeer1);
            rowCount_ht2TargetAtPeer1 = utility2.countRows(this.ht2TargetAtPeer1);
            if (i2 == 49) {
                if (rowCount_ht1TargetAtPeer1 != 100 || rowCount_ht2TargetAtPeer1 != 200) {
                    utility1.restartHBaseCluster(1);
                    rowCount_ht1Source = utility1.countRows(this.ht1Source);
                    LOG.debug("t1_syncup should have 102 rows at source, and it is " + rowCount_ht1Source);
                    rowCount_ht2Source = utility1.countRows(this.ht2Source);
                    LOG.debug("t2_syncup should have 202 rows at source, and it is " + rowCount_ht2Source);
                }
                Assert.assertEquals((String)"@Peer1 t1_syncup should be sync up and have 100 rows", (long)100L, (long)rowCount_ht1TargetAtPeer1);
                Assert.assertEquals((String)"@Peer1 t2_syncup should be sync up and have 200 rows", (long)200L, (long)rowCount_ht2TargetAtPeer1);
            }
            if (rowCount_ht1TargetAtPeer1 == 100 && rowCount_ht2TargetAtPeer1 == 200) {
                LOG.info("SyncUpAfterPut succeeded at retry = " + i2);
                break;
            }
            LOG.debug("SyncUpAfterPut failed at retry = " + i2 + ", with rowCount_ht1TargetPeer1 =" + rowCount_ht1TargetAtPeer1 + " and rowCount_ht2TargetAtPeer1 =" + rowCount_ht2TargetAtPeer1);
            Thread.sleep(500L);
        }
    }

    protected void syncUp(HBaseTestingUtility ut) throws Exception {
        ToolRunner.run((Configuration)ut.getConfiguration(), (Tool)new ReplicationSyncUp(), (String[])new String[0]);
    }
}

