/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.SimpleRegionObserver;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestRegionCoprocessorHost {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionCoprocessorHost.class);

    @Test
    public void testLoadDuplicateCoprocessor() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.setBoolean("hbase.coprocessor.enabled", true);
        conf.setBoolean("hbase.coprocessor.user.enabled", true);
        conf.setBoolean("hbase.skip.load.duplicate.table.coprocessor", true);
        conf.set("hbase.coprocessor.region.classes", SimpleRegionObserver.class.getName());
        TableName tableName = TableName.valueOf((String)"testDoubleLoadingCoprocessor");
        RegionInfo regionInfo = RegionInfoBuilder.newBuilder((TableName)tableName).build();
        TableDescriptor tableDesc = TableDescriptorBuilder.newBuilder((TableName)tableName).setCoprocessor(SimpleRegionObserver.class.getName()).build();
        HRegion region = (HRegion)Mockito.mock(HRegion.class);
        Mockito.when((Object)region.getRegionInfo()).thenReturn((Object)regionInfo);
        Mockito.when((Object)region.getTableDescriptor()).thenReturn((Object)tableDesc);
        RegionServerServices rsServices = (RegionServerServices)Mockito.mock(RegionServerServices.class);
        RegionCoprocessorHost host = new RegionCoprocessorHost(region, rsServices, conf);
        Assert.assertEquals((long)1L, (long)host.coprocEnvironments.size());
        conf.setBoolean("hbase.skip.load.duplicate.table.coprocessor", false);
        host = new RegionCoprocessorHost(region, rsServices, conf);
        Assert.assertEquals((long)2L, (long)host.coprocEnvironments.size());
    }
}

