/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MiscTests.class, MediumTests.class})
public class TestHColumnDescriptorDefaultVersions {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHColumnDescriptorDefaultVersions.class);
    @Rule
    public TestName name = new TestName();
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static TableName TABLE_NAME = null;
    private static final byte[] FAMILY = Bytes.toBytes((String)"cf0");

    @BeforeClass
    public static void beforeAllTests() throws Exception {
        TEST_UTIL.startMiniCluster(1);
    }

    @Before
    public void setup() {
        TABLE_NAME = TableName.valueOf((String)this.name.getMethodName());
    }

    @AfterClass
    public static void afterAllTests() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateTableWithDefault() throws IOException {
        Admin admin = TEST_UTIL.getAdmin();
        HTableDescriptor baseHtd = new HTableDescriptor(TABLE_NAME);
        HColumnDescriptor hcd = new HColumnDescriptor(FAMILY);
        baseHtd.addFamily(hcd);
        admin.createTable((TableDescriptor)baseHtd);
        admin.disableTable(TABLE_NAME);
        try {
            this.verifyHColumnDescriptor(1, TABLE_NAME, new byte[][]{FAMILY});
        }
        finally {
            admin.deleteTable(TABLE_NAME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateTableWithDefaultFromConf() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
        TEST_UTIL.getConfiguration().setInt("hbase.column.max.version", 3);
        TEST_UTIL.startMiniCluster(1);
        Admin admin = TEST_UTIL.getAdmin();
        HTableDescriptor baseHtd = new HTableDescriptor(TABLE_NAME);
        HColumnDescriptor hcd = new HColumnDescriptor(FAMILY);
        hcd.setMaxVersions(TEST_UTIL.getConfiguration().getInt("hbase.column.max.version", 1));
        baseHtd.addFamily(hcd);
        admin.createTable((TableDescriptor)baseHtd);
        admin.disableTable(TABLE_NAME);
        try {
            this.verifyHColumnDescriptor(3, TABLE_NAME, new byte[][]{FAMILY});
        }
        finally {
            admin.deleteTable(TABLE_NAME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateTableWithSetVersion() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
        TEST_UTIL.getConfiguration().setInt("hbase.column.max.version", 3);
        TEST_UTIL.startMiniCluster(1);
        Admin admin = TEST_UTIL.getAdmin();
        HTableDescriptor baseHtd = new HTableDescriptor(TABLE_NAME);
        HColumnDescriptor hcd = new HColumnDescriptor(FAMILY);
        hcd.setMaxVersions(5);
        baseHtd.addFamily(hcd);
        admin.createTable((TableDescriptor)baseHtd);
        admin.disableTable(TABLE_NAME);
        try {
            this.verifyHColumnDescriptor(5, TABLE_NAME, new byte[][]{FAMILY});
        }
        finally {
            admin.deleteTable(TABLE_NAME);
        }
    }

    @Test
    public void testHColumnDescriptorCachedMaxVersions() throws Exception {
        HColumnDescriptor hcd = new HColumnDescriptor(FAMILY);
        hcd.setMaxVersions(5);
        Assert.assertEquals((long)5L, (long)hcd.getMaxVersions());
        hcd.setValue(Bytes.toBytes((String)"VERSIONS"), Bytes.toBytes((String)"8"));
        Assert.assertEquals((long)8L, (long)hcd.getMaxVersions());
    }

    private void verifyHColumnDescriptor(int expected, TableName tableName, byte[] ... families) throws IOException {
        Admin admin = TEST_UTIL.getAdmin();
        TableDescriptor htd = admin.getDescriptor(tableName);
        ColumnFamilyDescriptor[] hcds = htd.getColumnFamilies();
        this.verifyHColumnDescriptor(expected, hcds, tableName, families);
        MasterFileSystem mfs = TEST_UTIL.getMiniHBaseCluster().getMaster().getMasterFileSystem();
        Path tableDir = FSUtils.getTableDir((Path)mfs.getRootDir(), (TableName)tableName);
        TableDescriptor td = FSTableDescriptors.getTableDescriptorFromFs((FileSystem)mfs.getFileSystem(), (Path)tableDir);
        hcds = td.getColumnFamilies();
        this.verifyHColumnDescriptor(expected, hcds, tableName, families);
    }

    private void verifyHColumnDescriptor(int expected, ColumnFamilyDescriptor[] hcds, TableName tableName, byte[] ... families) {
        for (ColumnFamilyDescriptor hcd : hcds) {
            Assert.assertEquals((long)expected, (long)hcd.getMaxVersions());
        }
    }
}

