/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionProgress;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.regionserver.compactions.Compactor;

@InterfaceAudience.Private
public class DefaultCompactor
extends Compactor {
    public DefaultCompactor(Configuration conf, Store store) {
        super(conf, store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public List<Path> compact(CompactionRequest request) throws IOException {
        ArrayList<Path> newFiles;
        block20: {
            StoreFile.Writer writer;
            Compactor.FileDetails fd;
            block21: {
                InternalScanner scanner;
                IOException e;
                long smallestReadPoint;
                block15: {
                    ArrayList<Path> arrayList;
                    block17: {
                        block18: {
                            block16: {
                                fd = this.getFileDetails(request.getFiles(), request.isMajor());
                                this.progress = new CompactionProgress(fd.maxKeyCount);
                                smallestReadPoint = this.getSmallestReadPoint();
                                List<StoreFileScanner> scanners = this.createFileScanners(request.getFiles(), smallestReadPoint);
                                writer = null;
                                newFiles = new ArrayList<Path>();
                                e = null;
                                scanner = null;
                                ScanType scanType = request.isMajor() ? ScanType.COMPACT_DROP_DELETES : ScanType.COMPACT_RETAIN_DELETES;
                                scanner = this.preCreateCoprocScanner(request, scanType, fd.earliestPutTs, scanners);
                                if (scanner == null) {
                                    scanner = this.createScanner(this.store, scanners, scanType, smallestReadPoint, fd.earliestPutTs);
                                }
                                if ((scanner = this.postCreateCoprocScanner(request, scanType, scanner)) != null) break block15;
                                arrayList = newFiles;
                                if (scanner == null) break block16;
                                scanner.close();
                            }
                            if (writer == null) break block17;
                            if (e == null) break block18;
                            writer.close();
                            break block17;
                        }
                        writer.appendMetadata(fd.maxSeqId, request.isMajor());
                        writer.close();
                        newFiles.add(writer.getPath());
                    }
                    return arrayList;
                }
                try {
                    block19: {
                        writer = this.store.createWriterInTmp(fd.maxKeyCount, this.compactionCompression, true, fd.maxMVCCReadpoint >= smallestReadPoint, fd.maxTagsLength > 0);
                        boolean finished = this.performCompaction(scanner, writer, smallestReadPoint);
                        if (!finished) {
                            writer.close();
                            this.store.getFileSystem().delete(writer.getPath(), false);
                            writer = null;
                            throw new InterruptedIOException("Aborting compaction of store " + this.store + " in region " + this.store.getRegionInfo().getRegionNameAsString() + " because it was interrupted.");
                        }
                        break block19;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        finally {
                            if (scanner != null) {
                                scanner.close();
                            }
                        }
                    }
                    if (writer == null) break block20;
                    if (e == null) break block21;
                }
                catch (IOException ioe) {
                    try {
                        e = ioe;
                        throw ioe;
                    }
                    catch (Throwable throwable) {
                        if (writer != null) {
                            if (e != null) {
                                writer.close();
                            } else {
                                writer.appendMetadata(fd.maxSeqId, request.isMajor());
                                writer.close();
                                newFiles.add(writer.getPath());
                            }
                        }
                        throw throwable;
                    }
                }
                writer.close();
                break block20;
            }
            writer.appendMetadata(fd.maxSeqId, request.isMajor());
            writer.close();
            newFiles.add(writer.getPath());
        }
        return newFiles;
    }

    public List<Path> compactForTesting(Collection<StoreFile> filesToCompact, boolean isMajor) throws IOException {
        CompactionRequest cr = new CompactionRequest(filesToCompact);
        cr.setIsMajor(isMajor);
        return this.compact(cr);
    }
}

