/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.mapreduce.TableOutputCommitter;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class TableOutputFormat<KEY>
extends OutputFormat<KEY, Mutation>
implements Configurable {
    private final Log LOG = LogFactory.getLog(TableOutputFormat.class);
    public static final String OUTPUT_TABLE = "hbase.mapred.outputtable";
    public static final String QUORUM_ADDRESS = "hbase.mapred.output.quorum";
    public static final String QUORUM_PORT = "hbase.mapred.output.quorum.port";
    public static final String REGION_SERVER_CLASS = "hbase.mapred.output.rs.class";
    public static final String REGION_SERVER_IMPL = "hbase.mapred.output.rs.impl";
    private Configuration conf = null;
    private HTable table;

    public RecordWriter<KEY, Mutation> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new TableRecordWriter(this.table);
    }

    public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new TableOutputCommitter();
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration otherConf) {
        this.conf = HBaseConfiguration.create((Configuration)otherConf);
        String tableName = this.conf.get(OUTPUT_TABLE);
        if (tableName == null || tableName.length() <= 0) {
            throw new IllegalArgumentException("Must specify table name");
        }
        String address = this.conf.get(QUORUM_ADDRESS);
        int zkClientPort = this.conf.getInt(QUORUM_PORT, 0);
        String serverClass = this.conf.get(REGION_SERVER_CLASS);
        String serverImpl = this.conf.get(REGION_SERVER_IMPL);
        try {
            if (address != null) {
                ZKUtil.applyClusterKeyToConf((Configuration)this.conf, (String)address);
            }
            if (serverClass != null) {
                this.conf.set("hbase.regionserver.impl", serverImpl);
            }
            if (zkClientPort != 0) {
                this.conf.setInt("hbase.zookeeper.property.clientPort", zkClientPort);
            }
            this.table = new HTable(this.conf, tableName);
            this.table.setAutoFlush(false, true);
            this.LOG.info((Object)("Created table instance for " + tableName));
        }
        catch (IOException e) {
            this.LOG.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    protected static class TableRecordWriter<KEY>
    extends RecordWriter<KEY, Mutation> {
        private HTable table;

        public TableRecordWriter(HTable table) {
            this.table = table;
        }

        public void close(TaskAttemptContext context) throws IOException {
            this.table.close();
        }

        public void write(KEY key, Mutation value) throws IOException {
            if (value instanceof Put) {
                this.table.put(new Put((Put)value));
            } else if (value instanceof Delete) {
                this.table.delete(new Delete((Delete)value));
            } else {
                throw new IOException("Pass a Delete or a Put");
            }
        }
    }
}

