/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.crypto;

import java.security.Key;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hadoop.hbase.io.crypto.KeyProvider;
import org.apache.hadoop.hbase.io.crypto.KeyProviderForTesting;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestKeyProvider {
    @Test
    public void testTestProvider() {
        Configuration conf = HBaseConfiguration.create();
        conf.set("hbase.crypto.keyprovider", KeyProviderForTesting.class.getName());
        KeyProvider provider = Encryption.getKeyProvider((Configuration)conf);
        Assert.assertNotNull((String)"Null returned for provider", (Object)provider);
        Assert.assertTrue((String)"Provider is not the expected type", (boolean)(provider instanceof KeyProviderForTesting));
        Key key = provider.getKey("foo");
        Assert.assertNotNull((String)"Test provider did not return a key as expected", (Object)key);
        Assert.assertEquals((String)"Test provider did not create a key for AES", (Object)"AES", (Object)key.getAlgorithm());
        Assert.assertEquals((String)"Test provider did not create a key of adequate length", (long)16L, (long)key.getEncoded().length);
    }
}

