/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
@InterfaceStability.Stable
public final class ReplicationSerDeHelper {
    private static final Log LOG = LogFactory.getLog(ReplicationSerDeHelper.class);

    private ReplicationSerDeHelper() {
    }

    public static ReplicationPeerConfig parsePeerFrom(byte[] bytes) throws DeserializationException {
        if (ProtobufUtil.isPBMagicPrefix(bytes)) {
            ZooKeeperProtos.ReplicationPeer peer;
            int pblen = ProtobufUtil.lengthOfPBMagic();
            ZooKeeperProtos.ReplicationPeer.Builder builder = ZooKeeperProtos.ReplicationPeer.newBuilder();
            try {
                ProtobufUtil.mergeFrom((Message.Builder)builder, bytes, pblen, bytes.length - pblen);
                peer = builder.build();
            }
            catch (IOException e) {
                throw new DeserializationException(e);
            }
            return ReplicationSerDeHelper.convert(peer);
        }
        if (bytes.length > 0) {
            return new ReplicationPeerConfig().setClusterKey(Bytes.toString((byte[])bytes));
        }
        return new ReplicationPeerConfig().setClusterKey("");
    }

    private static ReplicationPeerConfig convert(ZooKeeperProtos.ReplicationPeer peer) {
        ReplicationPeerConfig peerConfig = new ReplicationPeerConfig();
        if (peer.hasClusterkey()) {
            peerConfig.setClusterKey(peer.getClusterkey());
        }
        if (peer.hasReplicationEndpointImpl()) {
            peerConfig.setReplicationEndpointImpl(peer.getReplicationEndpointImpl());
        }
        for (HBaseProtos.BytesBytesPair pair : peer.getDataList()) {
            peerConfig.getPeerData().put(pair.getFirst().toByteArray(), pair.getSecond().toByteArray());
        }
        for (HBaseProtos.BytesBytesPair pair : peer.getConfigurationList()) {
            peerConfig.getConfiguration().put(pair.getName(), pair.getValue());
        }
        return peerConfig;
    }

    public static byte[] toByteArray(ReplicationPeerConfig peerConfig) {
        byte[] bytes = ReplicationSerDeHelper.convert(peerConfig).toByteArray();
        return ProtobufUtil.prependPBMagic(bytes);
    }

    private static ZooKeeperProtos.ReplicationPeer convert(ReplicationPeerConfig peerConfig) {
        ZooKeeperProtos.ReplicationPeer.Builder builder = ZooKeeperProtos.ReplicationPeer.newBuilder();
        if (peerConfig.getClusterKey() != null) {
            builder.setClusterkey(peerConfig.getClusterKey());
        }
        if (peerConfig.getReplicationEndpointImpl() != null) {
            builder.setReplicationEndpointImpl(peerConfig.getReplicationEndpointImpl());
        }
        for (Map.Entry<byte[], byte[]> entry : peerConfig.getPeerData().entrySet()) {
            builder.addData(HBaseProtos.BytesBytesPair.newBuilder().setFirst(ByteString.copyFrom((byte[])entry.getKey())).setSecond(ByteString.copyFrom((byte[])entry.getValue())).build());
        }
        for (Map.Entry<Object, Object> entry : peerConfig.getConfiguration().entrySet()) {
            builder.addConfiguration(HBaseProtos.NameStringPair.newBuilder().setName((String)entry.getKey()).setValue((String)entry.getValue()).build());
        }
        return builder.build();
    }
}

