/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.NodeAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeAllocationInfo;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ActivitiesInfo {
    protected String nodeId;
    protected String timeStamp;
    protected String diagnostic = null;
    protected List<NodeAllocationInfo> allocations;
    private static final Log LOG = LogFactory.getLog(ActivitiesInfo.class);

    public ActivitiesInfo() {
    }

    public ActivitiesInfo(String errorMessage, String nodeId) {
        this.diagnostic = errorMessage;
        this.nodeId = nodeId;
    }

    public ActivitiesInfo(List<NodeAllocation> nodeAllocations, String nodeId) {
        this.nodeId = nodeId;
        this.allocations = new ArrayList<NodeAllocationInfo>();
        if (nodeAllocations == null) {
            this.diagnostic = nodeId != null ? "waiting for display" : "waiting for next allocation";
        } else if (nodeAllocations.size() == 0) {
            this.diagnostic = "do not have available resources";
        } else {
            this.nodeId = nodeAllocations.get(0).getNodeId();
            Date date = new Date();
            date.setTime(nodeAllocations.get(0).getTimeStamp());
            this.timeStamp = date.toString();
            for (int i = 0; i < nodeAllocations.size(); ++i) {
                NodeAllocation nodeAllocation = nodeAllocations.get(i);
                NodeAllocationInfo allocationInfo = new NodeAllocationInfo(nodeAllocation);
                this.allocations.add(allocationInfo);
            }
        }
    }
}

