/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor.invariants;

import java.io.IOException;
import java.util.Collection;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.invariants.InvariantViolationException;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.invariants.InvariantsChecker;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.Plan;
import org.apache.hadoop.yarn.util.UTCClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReservationInvariantsChecker
extends InvariantsChecker {
    private static final Logger LOG = LoggerFactory.getLogger(ReservationInvariantsChecker.class);
    private UTCClock clock = new UTCClock();

    @Override
    public void editSchedule() {
        Collection<Plan> plans = this.getContext().getReservationSystem().getAllPlans().values();
        try {
            for (Plan plan : plans) {
                long numberReservationQueues;
                long currReservations = plan.getReservationsAtTime(this.clock.getTime()).size();
                if (currReservations == (numberReservationQueues = (long)this.getContext().getScheduler().getQueueInfo(plan.getQueueName(), true, false).getChildQueues().size()) - 1L) continue;
                this.logOrThrow("Number of reservations (" + currReservations + ") does NOT match the number of reservationQueues (" + (numberReservationQueues - 1L) + "), while it should.");
            }
        }
        catch (IOException io) {
            throw new InvariantViolationException("Issue during invariant check: ", io);
        }
    }
}

