/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity;

import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.AbstractPreemptionEntity;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

public class TempAppPerPartition
extends AbstractPreemptionEntity {
    private final int priority;
    private final ApplicationId applicationId;
    FiCaSchedulerApp app;

    TempAppPerPartition(FiCaSchedulerApp app, Resource usedPerPartition, Resource amUsedPerPartition, Resource reserved, Resource pendingPerPartition) {
        super(app.getQueueName(), usedPerPartition, amUsedPerPartition, reserved, pendingPerPartition);
        this.priority = app.getPriority().getPriority();
        this.applicationId = app.getApplicationId();
        this.app = app;
    }

    public FiCaSchedulerApp getFiCaSchedulerApp() {
        return this.app;
    }

    public void assignPreemption(Resource killable) {
        Resources.addTo((Resource)this.toBePreempted, (Resource)killable);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" NAME: " + this.getApplicationId()).append(" PRIO: ").append(this.priority).append(" CUR: ").append(this.getUsed()).append(" PEN: ").append(this.pending).append(" RESERVED: ").append(this.reserved).append(" IDEAL_ASSIGNED: ").append(this.idealAssigned).append(" PREEMPT_OTHER: ").append(this.getToBePreemptFromOther()).append(" IDEAL_PREEMPT: ").append(this.toBePreempted).append(" ACTUAL_PREEMPT: ").append(this.getActuallyToBePreempted()).append("\n");
        return sb.toString();
    }

    void appendLogString(StringBuilder sb) {
        sb.append(this.queueName).append(", ").append(this.getUsed().getMemorySize()).append(", ").append(this.getUsed().getVirtualCores()).append(", ").append(this.pending.getMemorySize()).append(", ").append(this.pending.getVirtualCores()).append(", ").append(this.idealAssigned.getMemorySize()).append(", ").append(this.idealAssigned.getVirtualCores()).append(", ").append(this.toBePreempted.getMemorySize()).append(", ").append(this.toBePreempted.getVirtualCores()).append(", ").append(this.getActuallyToBePreempted().getMemorySize()).append(", ").append(this.getActuallyToBePreempted().getVirtualCores());
    }

    public int getPriority() {
        return this.priority;
    }

    public ApplicationId getApplicationId() {
        return this.applicationId;
    }

    public String getUser() {
        return this.app.getUser();
    }

    public void deductActuallyToBePreempted(ResourceCalculator resourceCalculator, Resource cluster, Resource toBeDeduct) {
        if (Resources.greaterThan((ResourceCalculator)resourceCalculator, (Resource)cluster, (Resource)this.getActuallyToBePreempted(), (Resource)toBeDeduct)) {
            Resources.subtractFrom((Resource)this.getActuallyToBePreempted(), (Resource)toBeDeduct);
        }
    }
}

