/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Inject;
import com.google.inject.servlet.RequestScoped;
import java.util.Collection;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.FairSchedulerAppsBlock;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.MetricsOverviewTable;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RmView;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.SchedulerPageUtil;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.FairSchedulerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.FairSchedulerLeafQueueInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.FairSchedulerQueueInfo;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.ResponseInfo;
import org.apache.hadoop.yarn.webapp.SubView;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.HtmlPage;
import org.apache.hadoop.yarn.webapp.view.InfoBlock;

public class FairSchedulerPage
extends RmView {
    static final String _Q = ".ui-state-default.ui-corner-all";
    static final float Q_MAX_WIDTH = 0.8f;
    static final float Q_STATS_POS = 0.85f;
    static final String Q_END = "left:101%";
    static final String Q_GIVEN = "left:0%;background:none;border:1px dashed rgba(0,0,0,0.25)";
    static final String Q_OVER = "background:rgba(255, 140, 0, 0.8)";
    static final String Q_UNDER = "background:rgba(50, 205, 50, 0.8)";

    protected void postHead(Hamlet.HTML<HtmlPage._> html) {
        ((Hamlet.HTML)((Hamlet.HTML)html.style().$type("text/css")._(new Object[]{"#cs { padding: 0.5em 0 1em 0; margin-bottom: 1em; position: relative }", "#cs ul { list-style: none }", "#cs a { font-weight: normal; margin: 2px; position: relative }", "#cs a span { font-weight: normal; font-size: 80% }", "#cs-wrapper .ui-widget-header { padding: 0.2em 0.5em }", ".qstats { font-weight: normal; font-size: 80%; position: absolute }", ".qlegend { font-weight: normal; padding: 0 1em; margin: 1em }", "table.info tr th {width: 50%}"})._()).script("/static/jt/jquery.jstree.js").script().$type("text/javascript")._(new Object[]{"$(function() {", "  $('#cs a span').addClass('ui-corner-all').css('position', 'absolute');", "  $('#cs').bind('loaded.jstree', function (e, data) {", "    var callback = { call:reopenQueryNodes }", "    data.inst.open_node('#pq', callback);", "   }).", "    jstree({", "    core: { animation: 188, html_titles: true },", "    plugins: ['themeroller', 'html_data', 'ui'],", "    themeroller: { item_open: 'ui-icon-minus',", "      item_clsd: 'ui-icon-plus', item_leaf: 'ui-icon-gear'", "    }", "  });", "  $('#cs').bind('select_node.jstree', function(e, data) {", "    var q = $('.q', data.rslt.obj).first().text();", "    if (q == 'root') q = '';", "    else q = '^' + q.substr(q.lastIndexOf('.') + 1) + '$';", "    $('#apps').dataTable().fnFilter(q, 3, true);", "  });", "  $('#cs').show();", "});"})._())._(SchedulerPageUtil.QueueBlockUtil.class);
    }

    @Override
    protected Class<? extends SubView> content() {
        return QueuesBlock.class;
    }

    static String percent(float f) {
        return String.format("%.1f%%", Float.valueOf(f * 100.0f));
    }

    static String width(float f) {
        return String.format("width:%.1f%%", Float.valueOf(f * 100.0f));
    }

    static String left(float f) {
        return String.format("left:%.1f%%", Float.valueOf(f * 100.0f));
    }

    @Override
    protected String getAppsTableColumnDefs() {
        StringBuilder sb = new StringBuilder();
        return sb.append("[\n").append("{'sType':'numeric', 'aTargets': [0]").append(", 'mRender': parseHadoopID }").append("\n, {'sType':'numeric', 'aTargets': [5, 6]").append(", 'mRender': renderHadoopDate }").append("\n, {'sType':'numeric', bSearchable:false, 'aTargets': [9]").append(", 'mRender': parseHadoopProgress }]").toString();
    }

    static class QueuesBlock
    extends HtmlBlock {
        final FairScheduler fs;
        final FSQInfo fsqinfo;

        @Inject
        QueuesBlock(ResourceManager rm, FSQInfo info) {
            this.fs = (FairScheduler)rm.getResourceScheduler();
            this.fsqinfo = info;
        }

        public void render(HtmlBlock.Block html) {
            html._(MetricsOverviewTable.class);
            Hamlet.UL ul = ((Hamlet.DIV)html.div("#cs-wrapper.ui-widget").div(".ui-widget-header.ui-corner-top")._(new Object[]{"Application Queues"})._()).div("#cs.ui-widget-content.ui-corner-bottom").ul();
            if (this.fs == null) {
                ((Hamlet.LI)((Hamlet.A)ul.li().a(FairSchedulerPage._Q).$style(FairSchedulerPage.width(0.8f)).span().$style(FairSchedulerPage.Q_END)._(new Object[]{"100% "})._()).span(".q", "default")._())._();
            } else {
                FairSchedulerInfo sinfo = new FairSchedulerInfo(this.fs);
                this.fsqinfo.qinfo = sinfo.getRootQueueInfo();
                float used = this.fsqinfo.qinfo.getUsedMemoryFraction();
                ((Hamlet.LI)((Hamlet.LI)((Hamlet.A)((Hamlet.UL)((Hamlet.LI)((Hamlet.LI)((Hamlet.LI)((Hamlet.LI)((Hamlet.LI)ul.li().$style("margin-bottom: 1em").span().$style("font-weight: bold")._(new Object[]{"Legend:"})._()).span().$class("qlegend ui-corner-all").$style(FairSchedulerPage.Q_GIVEN)._(new Object[]{"Fair Share"})._()).span().$class("qlegend ui-corner-all").$style(FairSchedulerPage.Q_UNDER)._(new Object[]{"Used"})._()).span().$class("qlegend ui-corner-all").$style(FairSchedulerPage.Q_OVER)._(new Object[]{"Used (over fair share)"})._()).span().$class("qlegend ui-corner-all ui-state-default")._(new Object[]{"Max Capacity"})._())._()).li().a(FairSchedulerPage._Q).$style(FairSchedulerPage.width(0.8f)).span().$style(StringHelper.join((Object[])new Object[]{FairSchedulerPage.width(used), ";left:0%;", used > 1.0f ? FairSchedulerPage.Q_OVER : FairSchedulerPage.Q_UNDER}))._(new Object[]{"."})._()).span(".q", "root")._()).span().$class("qstats").$style(FairSchedulerPage.left(0.85f))._(new Object[]{StringHelper.join((Object[])new Object[]{FairSchedulerPage.percent(used), " used"})})._())._(QueueBlock.class)._();
            }
            ((Hamlet)((Hamlet.DIV)((Hamlet.DIV)((Hamlet.DIV)ul._())._()).script().$type("text/javascript")._(new Object[]{"$('#cs').hide();"})._())._())._(FairSchedulerAppsBlock.class);
        }
    }

    static class QueueBlock
    extends HtmlBlock {
        final FSQInfo fsqinfo;

        @Inject
        QueueBlock(FSQInfo info) {
            this.fsqinfo = info;
        }

        public void render(HtmlBlock.Block html) {
            Collection<FairSchedulerQueueInfo> subQueues = this.fsqinfo.qinfo.getChildQueues();
            Hamlet.UL ul = html.ul("#pq");
            for (FairSchedulerQueueInfo info : subQueues) {
                float capacity = info.getMaxResourcesFraction();
                float fairShare = info.getFairShareMemoryFraction();
                float used = info.getUsedMemoryFraction();
                Hamlet.LI li = (Hamlet.LI)((Hamlet.LI)((Hamlet.A)((Hamlet.A)ul.li().a(FairSchedulerPage._Q).$style(FairSchedulerPage.width(capacity * 0.8f)).$title(StringHelper.join((Object[])new Object[]{"Fair Share:", FairSchedulerPage.percent(fairShare)})).span().$style(StringHelper.join((Object[])new Object[]{FairSchedulerPage.Q_GIVEN, ";font-size:1px;", FairSchedulerPage.width(fairShare / capacity)}))._(new Object[]{Character.valueOf('.')})._()).span().$style(StringHelper.join((Object[])new Object[]{FairSchedulerPage.width(used / capacity), ";font-size:1px;left:0%;", used > fairShare ? FairSchedulerPage.Q_OVER : FairSchedulerPage.Q_UNDER}))._(new Object[]{Character.valueOf('.')})._()).span(".q", info.getQueueName())._()).span().$class("qstats").$style(FairSchedulerPage.left(0.85f))._(new Object[]{StringHelper.join((Object[])new Object[]{FairSchedulerPage.percent(used), " used"})})._();
                this.fsqinfo.qinfo = info;
                if (info instanceof FairSchedulerLeafQueueInfo) {
                    ((Hamlet.UL)li.ul("#lq").li()._(LeafQueueBlock.class)._())._();
                } else {
                    li._(QueueBlock.class);
                }
                li._();
            }
            ul._();
        }
    }

    static class LeafQueueBlock
    extends HtmlBlock {
        final FairSchedulerLeafQueueInfo qinfo;

        @Inject
        LeafQueueBlock(View.ViewContext ctx, FSQInfo info) {
            super(ctx);
            this.qinfo = (FairSchedulerLeafQueueInfo)info.qinfo;
        }

        protected void render(HtmlBlock.Block html) {
            ResponseInfo ri = this.info("'" + this.qinfo.getQueueName() + "' Queue Status")._("Used Resources:", (Object)this.qinfo.getUsedResources().toString())._("Num Active Applications:", (Object)this.qinfo.getNumActiveApplications())._("Num Pending Applications:", (Object)this.qinfo.getNumPendingApplications())._("Min Resources:", (Object)this.qinfo.getMinResources().toString())._("Max Resources:", (Object)this.qinfo.getMaxResources().toString());
            int maxApps = this.qinfo.getMaxApplications();
            if (maxApps < Integer.MAX_VALUE) {
                ri._("Max Running Applications:", (Object)this.qinfo.getMaxApplications());
            }
            ri._("Fair Share:", (Object)this.qinfo.getFairShare().toString());
            html._(InfoBlock.class);
            ri.clear();
        }
    }

    @RequestScoped
    static class FSQInfo {
        FairSchedulerQueueInfo qinfo;

        FSQInfo() {
        }
    }
}

