/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.sink.committer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.flink.connector.pulsar.sink.committer.PulsarCommittable;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.pulsar.client.api.transaction.TxnID;

public class PulsarCommittableSerializer
implements SimpleVersionedSerializer<PulsarCommittable> {
    private static final int CURRENT_VERSION = 1;

    public int getVersion() {
        return 1;
    }

    public byte[] serialize(PulsarCommittable obj) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream out = new DataOutputStream(baos);){
                TxnID txnID = obj.getTxnID();
                out.writeLong(txnID.getMostSigBits());
                out.writeLong(txnID.getLeastSigBits());
                out.writeUTF(obj.getTopic());
                out.flush();
                byArray = baos.toByteArray();
            }
            return byArray;
        }
    }

    public PulsarCommittable deserialize(int version, byte[] serialized) throws IOException {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(serialized);){
            PulsarCommittable pulsarCommittable;
            try (DataInputStream in = new DataInputStream(bais);){
                long mostSigBits = in.readLong();
                long leastSigBits = in.readLong();
                TxnID txnID = new TxnID(mostSigBits, leastSigBits);
                String topic = in.readUTF();
                pulsarCommittable = new PulsarCommittable(txnID, topic);
            }
            return pulsarCommittable;
        }
    }
}

