/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.AccessExecutionJobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.job.AbstractExecutionGraphHandler;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobVertexIdPathParameter;
import org.apache.flink.runtime.rest.messages.JobVertexMessageParameters;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;

public abstract class AbstractJobVertexHandler<R extends ResponseBody, M extends JobVertexMessageParameters>
extends AbstractExecutionGraphHandler<R, M> {
    protected AbstractJobVertexHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, R, M> messageHeaders, ExecutionGraphCache executionGraphCache, Executor executor) {
        super(leaderRetriever, timeout, responseHeaders, messageHeaders, executionGraphCache, executor);
    }

    @Override
    protected R handleRequest(HandlerRequest<EmptyRequestBody, M> request, AccessExecutionGraph executionGraph) throws RestHandlerException {
        JobVertexID jobVertexID = (JobVertexID)((Object)request.getPathParameter(JobVertexIdPathParameter.class));
        AccessExecutionJobVertex jobVertex = executionGraph.getJobVertex(jobVertexID);
        if (jobVertex == null) {
            throw new RestHandlerException("No vertex with ID '" + (Object)((Object)jobVertexID) + "' exists.", HttpResponseStatus.NOT_FOUND);
        }
        return this.handleRequest(request, jobVertex);
    }

    protected abstract R handleRequest(HandlerRequest<EmptyRequestBody, M> var1, AccessExecutionJobVertex var2) throws RestHandlerException;
}

