/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.WebOptions;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobWriter;
import org.apache.flink.runtime.execution.librarycache.BlobLibraryCacheManager;
import org.apache.flink.runtime.execution.librarycache.FlinkUserCodeClassLoaders;
import org.apache.flink.runtime.execution.librarycache.LibraryCacheManager;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategyFactory;
import org.apache.flink.runtime.rest.handler.legacy.backpressure.BackPressureStatsTracker;
import org.apache.flink.runtime.rest.handler.legacy.backpressure.BackPressureStatsTrackerImpl;
import org.apache.flink.runtime.rest.handler.legacy.backpressure.StackTraceSampleCoordinator;
import org.apache.flink.runtime.util.ExecutorThreadFactory;
import org.apache.flink.runtime.util.Hardware;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import scala.concurrent.duration.FiniteDuration;

public class JobManagerSharedServices {
    private final ScheduledExecutorService scheduledExecutorService;
    private final LibraryCacheManager libraryCacheManager;
    private final RestartStrategyFactory restartStrategyFactory;
    private final StackTraceSampleCoordinator stackTraceSampleCoordinator;
    private final BackPressureStatsTracker backPressureStatsTracker;
    @Nonnull
    private final BlobWriter blobWriter;

    public JobManagerSharedServices(ScheduledExecutorService scheduledExecutorService, LibraryCacheManager libraryCacheManager, RestartStrategyFactory restartStrategyFactory, StackTraceSampleCoordinator stackTraceSampleCoordinator, BackPressureStatsTracker backPressureStatsTracker, @Nonnull BlobWriter blobWriter) {
        this.scheduledExecutorService = (ScheduledExecutorService)Preconditions.checkNotNull((Object)scheduledExecutorService);
        this.libraryCacheManager = (LibraryCacheManager)Preconditions.checkNotNull((Object)libraryCacheManager);
        this.restartStrategyFactory = (RestartStrategyFactory)Preconditions.checkNotNull((Object)restartStrategyFactory);
        this.stackTraceSampleCoordinator = (StackTraceSampleCoordinator)Preconditions.checkNotNull((Object)stackTraceSampleCoordinator);
        this.backPressureStatsTracker = (BackPressureStatsTracker)Preconditions.checkNotNull((Object)backPressureStatsTracker);
        this.blobWriter = blobWriter;
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    public LibraryCacheManager getLibraryCacheManager() {
        return this.libraryCacheManager;
    }

    public RestartStrategyFactory getRestartStrategyFactory() {
        return this.restartStrategyFactory;
    }

    public BackPressureStatsTracker getBackPressureStatsTracker() {
        return this.backPressureStatsTracker;
    }

    @Nonnull
    public BlobWriter getBlobWriter() {
        return this.blobWriter;
    }

    public void shutdown() throws Exception {
        Throwable firstException = null;
        try {
            this.scheduledExecutorService.shutdownNow();
        }
        catch (Throwable t) {
            firstException = t;
        }
        this.libraryCacheManager.shutdown();
        this.stackTraceSampleCoordinator.shutDown();
        this.backPressureStatsTracker.shutDown();
        if (firstException != null) {
            ExceptionUtils.rethrowException((Throwable)firstException, (String)"Error while shutting down JobManager services");
        }
    }

    public static JobManagerSharedServices fromConfiguration(Configuration config, BlobServer blobServer) throws Exception {
        FiniteDuration timeout;
        Preconditions.checkNotNull((Object)config);
        Preconditions.checkNotNull((Object)blobServer);
        String classLoaderResolveOrder = config.getString(CoreOptions.CLASSLOADER_RESOLVE_ORDER);
        String[] alwaysParentFirstLoaderPatterns = CoreOptions.getParentFirstLoaderPatterns((Configuration)config);
        BlobLibraryCacheManager libraryCacheManager = new BlobLibraryCacheManager(blobServer, FlinkUserCodeClassLoaders.ResolveOrder.fromString(classLoaderResolveOrder), alwaysParentFirstLoaderPatterns);
        try {
            timeout = AkkaUtils.getTimeout(config);
        }
        catch (NumberFormatException e) {
            throw new IllegalConfigurationException(AkkaUtils.formatDurationParsingErrorMessage());
        }
        ScheduledExecutorService futureExecutor = Executors.newScheduledThreadPool(Hardware.getNumberCPUCores(), new ExecutorThreadFactory("jobmanager-future"));
        StackTraceSampleCoordinator stackTraceSampleCoordinator = new StackTraceSampleCoordinator(futureExecutor, timeout.toMillis());
        int cleanUpInterval = config.getInteger(WebOptions.BACKPRESSURE_CLEANUP_INTERVAL);
        BackPressureStatsTrackerImpl backPressureStatsTracker = new BackPressureStatsTrackerImpl(stackTraceSampleCoordinator, cleanUpInterval, config.getInteger(WebOptions.BACKPRESSURE_NUM_SAMPLES), config.getInteger(WebOptions.BACKPRESSURE_REFRESH_INTERVAL), Time.milliseconds((long)config.getInteger(WebOptions.BACKPRESSURE_DELAY)));
        futureExecutor.scheduleWithFixedDelay(backPressureStatsTracker::cleanUpOperatorStatsCache, cleanUpInterval, cleanUpInterval, TimeUnit.MILLISECONDS);
        return new JobManagerSharedServices(futureExecutor, libraryCacheManager, RestartStrategyFactory.createRestartStrategyFactory(config), stackTraceSampleCoordinator, backPressureStatsTracker, blobServer);
    }
}

